/* html.h
 * Written by David Allen
 * <s2mdalle@titan.vcu.edu> http://opop.nols.com/
 *
 * This file is released under the terms of the GNU General Public License.
 */

#define HTML_H

/* HTML defines */
/* Header defines for html_header();  Basically parameters */
#define H1                         1
#define H2                         2
#define H3                         3
#define H4                         4
#define H5                         5
#define H6                         6

/* No need for anything creative.  Just all need to be different numbers */
#define HTMLM                      1
#define FILEM                      2
#define EDITM                      3
#define MISCM                      4
#define OPTIONSM                   5
#define HELPM                      6
#define SHORTCUTSM                 7
#define OUTPUTM                    8

#define HTML_BGCOLOR               500
#define HTML_TEXT                  501
#define HTML_LINK                  502

/* Vanilla inserts text into output_text, and chocolate inserts into status */
void vanilla                                 (const char *input);
void chocolate                               (const char *input);

#ifndef INCLUDE_HTML
#  define INCLUDE_HTML
#endif /* INCLUDE_HTML */
#ifdef INCLUDE_HTML   /* Only compile if defined */
void html_header                             (GtkWidget *w, int data);
void html_title                              (void);
void html_doctype                            (void);
void html_head                               (void);
void html_head_close                         (void);
void html_template                           (void);
void html_list_item                          (void);
void html_list                               (void);
void html_ssi                                (void);
void html_font_color                         (void);
void html_font_size                          (void);
void html_blink                              (void);
void html_www                                (void);
void html_pre                                (void);
void html_paragraph                          (void);
void html_linebreak                          (void);
void html_image                              (void);
void html_center                             (void);
void html_link                               (void);
void html_html                               (void);
void html_italics                            (void);
void html_strong                             (void);
void html_em                                 (void);
void html_bold                               (void);
void html_ftp                                (void);
void html_http                               (void);
void html_news                               (void);
void html_gopher                             (void);
void html_telnet                             (void);
void html_mailto                             (void);
void html_hr                                 (void);
void html_html_close                         (void);
void html_body                               (void);
void html_body_close                         (void);
void html_table                              (void);
void html_table_row                          (void);
void html_table_data                         (void);
void html_comment                            (void);
void html_close_unnamed                      (void);
void html_strike                             (void);
void html_sub                                (void);
void html_super                              (void);
void html_nbsp                               (void);
void html_internal                           (GtkWidget *e, gint type);
#endif /* INCLUDE_HTML */


