/* winselect.h
 *
 * This file is released under the terms of the GNU General Public License
 * along with the rest of GTKeyboard
 *
 * Support file with function prototypes/macros for ../winselect.c
 */

#define WINSELECT_H
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <X11/extensions/shape.h>
#include <X11/Xmu/WinUtil.h>
#include <stdio.h>

typedef struct {
     long code;
     char *name;
} binding;

/* Prototypes */
char *Display_Window_Id(Window window, Bool newline_wanted);
int bad_window_handler(Display *disp, XErrorEvent *err);
char *LookupL(long code, binding *table);
char *Lookup(int code, binding *table);
void Display_Stats_Info(Window window);
void Display_Bits_Info(Window window);
void Display_Event_Mask(long mask);
void Display_Events_Info(Window window);
void display_tree_info_1(Window window, int recurse, int level);
void Display_Tree_Info(Window window, int recurse);
void Display_Hints(XSizeHints *hints);
void Display_Size_Hints(Window window);
void Display_WM_Info(Window window);
void Display_Window_Shape(Window window);
Window Select_Window_Args(int *rargc, char **rargv);
Window Select_Window(Display *dpy);
Window Window_With_Name(Display *dpy, Window top, char *name);
char *Get_Display_Name(int *pargc, char **argv);

