/* Copyright (C) 1999-2000 Aaron Lehmann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#ifdef HAVE_IMLIB
#include <gdk_imlib.h>
#endif

#include "gtkplot.h"
#include "gtkplotlayout.h"
#include "gtkplotcanvas.h"
#include "gtksheet.h"

#include "app.h"
#include "version.h"
#include "prefs.h"
#include "main.h"
#include "callbacks.h"
#include "calc.h"
#include "data.h"
#include "mathparsesym.h"
#include "mathparse.h"
#include "function.h"


GtkWidget *active_plot;
GtkWidget *window1, *ctlwin, *opmenu;
GtkWidget *layout;
GtkWidget *canvas = NULL;
GtkWidget *errlab;
GtkWidget *edit, *entry2, *entry3, *entry4, *entry6, *entry7, *entry8, *entry9;
GtkWidget *menu, *menu_item;
gint nlayers = 0;
func_thing *formn, *currform;
double rangexmi=-1, rangeymi=-1, rangexma=1, rangeyma=1, majorticks_h=0.2, majorticks_v=0.2, minorticks_h=0.1, minorticks_v=0.1;

gint nbrdatasets = 0, nbrrealdatasets = 0;
thing ** datasets;

gint nbrfuncs = 0, nbrrealfuncs = 0;
func_thing **funcs;

extern struct mp_stack *rangeidx[2][2];


void set_error (void);


extern void get_main_menu (GtkWidget *window, GtkWidget **menubar);




GtkWidget *
new_layer(GtkWidget *canvas)
{
    
    active_plot = gtk_plot_new_with_size(NULL, .75, .75);
    
    return active_plot;
}



void set_error (void)
{
    char *t;
    int i;
    
    t=malloc (1*sizeof(char));
    t[0]='\0';

    for (i=0; i != nbrfuncs; ++i)
    {
	if (funcs[i]->usable && funcs[i]->name && funcs[i]->error)
	{
	    /* append */
	    t = realloc (t, (strlen(funcs[i]->error)+strlen(t)+strlen(funcs[i]->name)+6)*sizeof(char));
	    sprintf (t, "%s  %s: %s;", t, funcs[i]->name, funcs[i]->error);
	}
    }
    
    for (i=0; i != nbrdatasets; ++i)
    {
	if (datasets[i]->usable && datasets[i]->name && datasets[i]->error)
	{
	    /* append */
	    t = realloc (t, (strlen(datasets[i]->error)+strlen(t)+strlen(datasets[i]->name)+5)*sizeof(char));
	    sprintf (t, "%s  %s: %s", t, datasets[i]->name, datasets[i]->error);
	}
    }
    
    gtk_label_set_text (GTK_LABEL(errlab), t);
    free (t);
}


#if 0

void	gtkgraph_quit( GtkWidget * w , gpointer * cdata )
{
    GtkPlotCanvas *plot_canvas = (GtkPlotCanvas *) cdata ;
    
    gtk_type_free (gtk_plot_canvas_get_type () , plot_canvas );
}

#endif


int main(int argc, char *argv[])
{
    GtkWidget *vbox1, *hbox1, *vbox2, *vbox3, *main_hbox;
    GtkWidget *menubar;
    GtkWidget *button;
    GtkWidget *label;
    GtkWidget *sep1;
    GtkWidget *frame;
    
    gint i;	/*	, j[MAX_FUNC];	*/
    
/*  extern char *errtext;	*/
/*  extern char errtext[ 40 ];	*/
    
    
    rangeidx[0][0] = 0;
    rangeidx[0][1] = 0;
    rangeidx[1][0] = 0;
    rangeidx[1][1] = 0;
    
    /* Inits...... Imlib is used in exporting the plot. */
    bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
    textdomain (PACKAGE);
    
    gtk_set_locale();
    gtk_init(&argc,&argv);

#ifdef HAVE_IMLIB
    gdk_imlib_init();
    
    /* Part of imlib initialization... no idea why */
    
    gtk_widget_push_visual(gdk_imlib_get_visual());
    gtk_widget_push_colormap(gdk_imlib_get_colormap());
    
#endif
    
/*  errtext = (char *) malloc (40);	*/
    
    /* Initialize parser symbol table */
    init_table ();
    
    /* Set up evaluation window */
    calc_new ();
    
    
    /* Make a new window, connect its close box to a quit function */
    
    window1=gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window1), OURNAME);
    gtk_widget_set_usize(window1,PREFS_DEFAULT_WINDOW_X, PREFS_DEFAULT_WINDOW_Y);
    gtk_container_border_width(GTK_CONTAINER(window1),0);
    
    gtk_signal_connect (GTK_OBJECT (window1), "delete-event",
			GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
    /*GTK_SIGNAL_FUNC (gtkgraph_quit), canvas );*/
    gtk_signal_connect (GTK_OBJECT (window1), "key-press-event",
			GTK_SIGNAL_FUNC (callback_keypress), NULL);
    
    vbox1=gtk_vbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(window1),vbox1);
    gtk_widget_show(vbox1);
    
    /* Menubar init code. */
    get_main_menu (window1, &menubar);
    gtk_box_pack_start (GTK_BOX(vbox1), menubar, FALSE, TRUE, 0);
    gtk_widget_show (menubar);
    
    /* We have 2 boxes, the main vbox for the window, and the box in the top for the entry, option menu, and button. */
    
    main_hbox=gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox1), main_hbox, FALSE, FALSE, 0);
    gtk_widget_show (main_hbox);
    
    
    sep1 = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX(vbox1), sep1, FALSE, TRUE, 0);
    gtk_widget_show (sep1);
    
    /* Make and set up the canvas that the gtkplot will draw into */
    
    canvas = gtk_plot_canvas_new(500, 500);
    GTK_PLOT_CANVAS_SET_FLAGS(GTK_PLOT_CANVAS(canvas), GTK_PLOT_CANVAS_DND_FLAGS);
    GTK_PLOT_CANVAS_SET_FLAGS(GTK_PLOT_CANVAS(canvas), GTK_PLOT_CANVAS_ALLOCATE_TITLES);
    GTK_PLOT_CANVAS_UNSET_FLAGS(GTK_PLOT_CANVAS(canvas), GTK_PLOT_CANVAS_CAN_RESIZE_PLOT);
    GTK_PLOT_CANVAS_UNSET_FLAGS(GTK_PLOT_CANVAS(canvas), GTK_PLOT_CANVAS_CAN_MOVE_PLOT);
    gtk_signal_connect (GTK_OBJECT(canvas), "click_on_title", GTK_SIGNAL_FUNC(callback_click_on_titles), NULL);
    gtk_signal_connect (GTK_OBJECT(canvas), "click_on_point", GTK_SIGNAL_FUNC(callback_click_on_points), NULL);
    gtk_signal_connect (GTK_OBJECT(canvas), "select_region", GTK_SIGNAL_FUNC(callback_select_region), NULL);

    layout = canvas;
    
    
    GTK_LAYOUT(layout)->vadjustment = (GtkAdjustment *) gtk_adjustment_new (0, 0, 0, 0, 0, 0);
    GTK_LAYOUT(layout)->hadjustment = GTK_LAYOUT(layout)->vadjustment;
    gtk_box_pack_start(GTK_BOX(vbox1),layout, TRUE, TRUE, 0);
    gtk_layout_set_size(GTK_LAYOUT(layout), 500, 500);
    
    /*button = gtk_button_new();
      gtk_widget_set_usize (button, 30, 60);
      gtk_layout_put (GTK_LAYOUT(canvas), button, 500 - */
    /* connect signal */
    
    
    /* DND setup */
    /*gtk_drag_source_set (GTK_WIDGET(layout), GDK_BUTTON1_MASK|GDK_BUTTON3_MASK, target_table, 1, GDK_ACTION_COPY);
      gtk_signal_connect (GTK_OBJECT (layout), "drag_data_get", GTK_SIGNAL_FUNC (callback_source_drag_data_get), NULL);*/
    
    
    ctlwin=gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(ctlwin), _("GtkGraph Range Selection"));
    gtk_container_border_width(GTK_CONTAINER(window1),0);
    gtk_signal_connect (GTK_OBJECT(ctlwin), "delete-event", GTK_SIGNAL_FUNC(callback_ctl_hide), GTK_OBJECT(ctlwin));
    
    hbox1=gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER(ctlwin), hbox1);
    gtk_container_set_border_width (GTK_CONTAINER(hbox1), 5);
    gtk_widget_show (hbox1);
    
    vbox2=gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(hbox1), vbox2, FALSE, FALSE, 0);
    gtk_widget_show (vbox2);
    
    vbox3=gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(hbox1), vbox3, FALSE, FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER(vbox3), 20);
    gtk_widget_show (vbox3);
    
    vbox3=gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(hbox1), vbox3, FALSE, FALSE, 0);
    gtk_widget_show (vbox3);
    
    hbox1=gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox2), hbox1, FALSE, FALSE, 0);
    gtk_widget_show (hbox1);
    
    
    entry2 = gtk_entry_new_with_max_length(8);
    gtk_entry_set_text (GTK_ENTRY(entry2), "0.25");
    gtk_widget_set_usize (entry2, 60, entry2->requisition.height);
    gtk_box_pack_end (GTK_BOX(hbox1), entry2, FALSE, FALSE, 0);
    gtk_widget_show (entry2);
    
    
    label = gtk_label_new (_("Scroll delta (X):   "));
    gtk_box_pack_end (GTK_BOX(hbox1), label, FALSE, FALSE, 0);
    gtk_widget_show (label);
    
    
    hbox1=gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox3), hbox1, FALSE, FALSE, 0);
    gtk_widget_show (hbox1);
    
    
    entry3 = gtk_entry_new_with_max_length(8);
    gtk_entry_set_text (GTK_ENTRY(entry3), "0.25");
    gtk_widget_set_usize (entry3, 60, entry3->requisition.height);
    gtk_box_pack_end (GTK_BOX(hbox1), entry3, FALSE, FALSE, 0);
    gtk_widget_show (entry3);
    
    
    label = gtk_label_new (_("Scroll delta (Y):   "));
    gtk_box_pack_end (GTK_BOX(hbox1), label, FALSE, FALSE, 0);
    gtk_widget_show (label);
    

    hbox1=gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox2), hbox1, FALSE, FALSE, 0);
    gtk_widget_show (hbox1);
    
    
    entry6 = gtk_entry_new_with_max_length(8);
    gtk_entry_set_text (GTK_ENTRY(entry6), "-1");
    gtk_widget_set_usize (entry6, 60, entry6->requisition.height);
    gtk_box_pack_end (GTK_BOX(hbox1), entry6, FALSE, FALSE, 0);
    gtk_widget_show (entry6);
    
    
    label = gtk_label_new (_("X minimum:   "));
    gtk_box_pack_end (GTK_BOX(hbox1), label, FALSE, FALSE, 0);
    gtk_widget_show (label);
    

    hbox1=gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox3), hbox1, FALSE, FALSE, 0);
    gtk_widget_show (hbox1);
    
    
    entry7 = gtk_entry_new_with_max_length(8);
    gtk_entry_set_text (GTK_ENTRY(entry7), "1");
    gtk_widget_set_usize (entry7, 60, entry7->requisition.height);
    gtk_box_pack_end (GTK_BOX(hbox1), entry7, FALSE, FALSE, 0);
    gtk_widget_show (entry7);
    

    label = gtk_label_new (_("X maximum:   "));
    gtk_box_pack_end (GTK_BOX(hbox1), label, FALSE, FALSE, 0);
    gtk_widget_show (label);
    

    hbox1=gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox2), hbox1, FALSE, FALSE, 0);
    gtk_widget_show (hbox1);
    
    
    entry8 = gtk_entry_new_with_max_length(8);
    gtk_entry_set_text (GTK_ENTRY(entry8), "-1");
    gtk_widget_set_usize (entry8, 60, entry8->requisition.height);
    gtk_box_pack_end (GTK_BOX(hbox1), entry8, FALSE, FALSE, 0);
    gtk_widget_show (entry8);
    
    
    label = gtk_label_new (_("Y minimum:   "));
    gtk_box_pack_end (GTK_BOX(hbox1), label, FALSE, FALSE, 0);
    gtk_widget_show (label);
    

    hbox1=gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox3), hbox1, FALSE, FALSE, 0);
    gtk_widget_show (hbox1);
    

    entry9 = gtk_entry_new_with_max_length(8);
    gtk_entry_set_text (GTK_ENTRY(entry9), "1");
    gtk_widget_set_usize (entry9, 60, entry9->requisition.height);
    gtk_box_pack_end (GTK_BOX(hbox1), entry9, FALSE, FALSE, 0);
    gtk_widget_show (entry9);


    label = gtk_label_new (_("Y maximum:   "));
    gtk_box_pack_end (GTK_BOX(hbox1), label, FALSE, FALSE, 0);
    gtk_widget_show (label);
    
    
    hbox1=gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox2), hbox1, FALSE, FALSE, 0);
    gtk_widget_show (hbox1);
    
    
    entry4 = gtk_entry_new_with_max_length(8);
    gtk_entry_set_text (GTK_ENTRY(entry4), "2");
    gtk_widget_set_usize (entry4, 60, entry4->requisition.height);
    gtk_box_pack_end (GTK_BOX(hbox1), entry4, FALSE, FALSE, 0);
    gtk_widget_show (entry4);


    label = gtk_label_new (_("Zoom delta:   "));
    gtk_box_pack_end (GTK_BOX(hbox1), label, FALSE, FALSE, 0);
    gtk_widget_show (label);
    
    
    hbox1=gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox3), hbox1, FALSE, FALSE, 0);
    gtk_widget_show (hbox1);
    
    
    button = gtk_button_new_with_label (_("Close"));
    gtk_box_pack_end (GTK_BOX(hbox1), button, FALSE, FALSE, 0);
    gtk_widget_set_usize (button, 100, 20);
    gtk_widget_show (button);
    gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (callback_ctl_hide), GTK_OBJECT(button));
    
    
    button = gtk_button_new_with_label (_("Apply"));
    gtk_box_pack_end (GTK_BOX(hbox1), button, FALSE, FALSE, 0);
    gtk_widget_set_usize (button, 125, 35);
    /*GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
    gtk_widget_grab_focus (button);
    gtk_widget_grab_default (button);*/
    gtk_widget_show (button);
    gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (callback_range_apply), NULL);

    gtk_signal_connect (GTK_OBJECT(entry2), "activate", GTK_SIGNAL_FUNC(callback_range_apply), NULL);
    gtk_signal_connect (GTK_OBJECT(entry3), "activate", GTK_SIGNAL_FUNC(callback_range_apply), NULL);
    gtk_signal_connect (GTK_OBJECT(entry4), "activate", GTK_SIGNAL_FUNC(callback_range_apply), NULL);
    gtk_signal_connect (GTK_OBJECT(entry6), "activate", GTK_SIGNAL_FUNC(callback_range_apply), NULL);
    gtk_signal_connect (GTK_OBJECT(entry7), "activate", GTK_SIGNAL_FUNC(callback_range_apply), NULL);
    gtk_signal_connect (GTK_OBJECT(entry8), "activate", GTK_SIGNAL_FUNC(callback_range_apply), NULL);
    gtk_signal_connect (GTK_OBJECT(entry9), "activate", GTK_SIGNAL_FUNC(callback_range_apply), NULL);

    
    
    /*adj = gtk_adjustment_new (0, -5, 6, 1, 1, 1);
      gtk_signal_connect (GTK_OBJECT(adj), "value_changed", GTK_SIGNAL_FUNC(callback_zoom_slider), NULL);
      
      scale = gtk_hscale_new (GTK_ADJUSTMENT(adj));
      gtk_scale_set_digits (GTK_SCALE(scale), 0);
      gtk_box_pack_end (GTK_BOX(hbox1), scale, TRUE, TRUE, 0);
      gtk_widget_show (scale);*/
    
    
    sep1 = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX(vbox1), sep1, FALSE, TRUE, 0);
    gtk_widget_show (sep1);
    
    
    frame = gtk_frame_new(NULL);
    gtk_container_set_border_width(GTK_CONTAINER(frame), 1);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
    gtk_box_pack_start(GTK_BOX(vbox1), frame, FALSE, FALSE, 0);
    gtk_widget_show (frame);
    

    hbox1=gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER(frame), hbox1);
    gtk_widget_show (hbox1);
    
    
    errlab = gtk_label_new (_("Ready"));
    gtk_widget_set_usize (errlab, hbox1->requisition.width-5, errlab->requisition.height);
    gtk_box_pack_start (GTK_BOX(hbox1), errlab, FALSE, TRUE, 0);
    gtk_widget_show (errlab);
    
    
    gtk_widget_show(layout);
    
    active_plot = new_layer(canvas);

    /* Create and initialize the option menu */
    
    menu = gtk_menu_new ();
    gtk_widget_show (menu);

    /* Build initial functions */
    for (i = 0; i != START_FUNC; ++i)
    {
	new_function ();
    }
    
    
    /* Append menu trailer */

    menu_item = gtk_menu_item_new ();
    /*gtk_widget_set_name (separator3, "separator3");
      gtk_object_set_data (GTK_OBJECT (frmMain), "separator3", separator3);*/
    gtk_widget_show (menu_item);
    gtk_menu_append (GTK_MENU(menu), menu_item);
    
    menu_item = gtk_menu_item_new_with_label (_("New function"));
    gtk_widget_show (menu_item);
    gtk_menu_append (GTK_MENU(menu), menu_item);
    gtk_signal_connect (GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(new_function_menu), NULL);
    
    menu_item = gtk_menu_item_new_with_label (_("Delete function"));
    gtk_widget_show (menu_item);
    gtk_menu_append (GTK_MENU(menu), menu_item);
    gtk_signal_connect (GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(del_function), NULL);
    
    menu_item = gtk_menu_item_new_with_label (_("Change function name..."));
    gtk_widget_show (menu_item);
    gtk_menu_append (GTK_MENU(menu), menu_item);
    gtk_signal_connect (GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(chname_function), NULL);
    
    
    opmenu = gtk_option_menu_new ();
    gtk_option_menu_set_menu (GTK_OPTION_MENU(opmenu), menu);
    gtk_option_menu_set_history (GTK_OPTION_MENU(opmenu), 0);
    gtk_widget_show (opmenu);
    gtk_box_pack_start (GTK_BOX(main_hbox), opmenu, FALSE, FALSE, 0);
    
    edit = gtk_entry_new_with_max_length(512);
    gtk_box_pack_start (GTK_BOX(main_hbox), edit, TRUE, TRUE, 0);
    gtk_widget_show (edit);
    
    /* Set up entry and then Graph button */
    
    button = gtk_button_new_with_label (_("Graph"));
    gtk_box_pack_start (GTK_BOX(main_hbox), button, FALSE, FALSE, 5);
    gtk_widget_show (button);
    gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (callback_button), NULL);
    
    
    button = gtk_button_new_with_label (_("Set Range..."));
    gtk_box_pack_end (GTK_BOX(main_hbox), button, FALSE, FALSE, 0);
    gtk_widget_show (button);
    gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC(callback_ctl_show), NULL);


    formn = funcs[0];
    currform = funcs[0];
    
    /* Initialize the defaults. Load in from a prefs file if prefs file if possible, otherwise use defaults from prefs.h */
    defaults();
    if (!prefs_read())
	prefs_save ();
    
    
    /* Set grid attributes. We do this in initialization of the program even if the user doesn't have grids enabled so they will be set up already if the user tuns them on. Make a dashed line for major and turn off minor.*/
    gtk_plot_major_vgrid_set_attributes (GTK_PLOT(active_plot), GTK_PLOT_LINE_DOTTED, 1, prf.gridcolor);
    gtk_plot_major_hgrid_set_attributes (GTK_PLOT(active_plot), GTK_PLOT_LINE_DOTTED, 1, prf.gridcolor);
    gtk_plot_minor_vgrid_set_attributes (GTK_PLOT(active_plot), GTK_PLOT_LINE_DOTTED, 1, prf.gridcolor);
    gtk_plot_minor_hgrid_set_attributes (GTK_PLOT(active_plot), GTK_PLOT_LINE_DOTTED, 1, prf.gridcolor);
    
    /* Set other stuff */
    
    gtk_plot_set_range (GTK_PLOT(active_plot), rangexmi, rangexma, rangeymi, rangeyma);
    gtk_plot_legends_move (GTK_PLOT(active_plot), .06, .05);
    gtk_plot_hide_legends_border (GTK_PLOT(active_plot));
    gtk_plot_axis_hide_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_RIGHT);
    gtk_plot_axis_show_ticks (GTK_PLOT(active_plot), 3, 15, 15);
    gtk_plot_axis_set_ticks (GTK_PLOT(active_plot), GTK_ORIENTATION_HORIZONTAL, majorticks_h, minorticks_h);
    gtk_plot_axis_set_ticks (GTK_PLOT(active_plot), GTK_ORIENTATION_VERTICAL, majorticks_v, minorticks_v);
    
    
    
    
    /* This function handles all setting of a GtkPlot that are indicated by preferences.*/
    reset_flags();
    
    
    gtk_plot_canvas_add_plot(GTK_PLOT_CANVAS(canvas), GTK_PLOT(active_plot), .125, .125);
    gtk_widget_show(active_plot);
    
    
    gtk_plot_axis_set_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_BOTTOM, _("X Title"));
    gtk_plot_axis_move_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_BOTTOM, 0, 0.5, GTK_PLOT(active_plot)->bottom.title.y);
    
    
    gtk_plot_axis_set_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_LEFT, _("Y Title"));
    gtk_plot_axis_move_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_LEFT, 0, GTK_PLOT(active_plot)->left.title.x, 0.5);
    
    
    gtk_plot_axis_set_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_TOP, _("Plot Title"));
    gtk_plot_axis_move_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_TOP, 0, 0.5,0.03);
    
    gtk_widget_show (window1);
    
    data_new();
    
    gtk_main();
    
    return(0);
}


