/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation
 * Authors : Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef __GTRANS_CONN_LIST_H__ 
#define __GTRANS_CONN_LIST_H__ 


#include <gtk/gtk.h>
#include <gtrans_ifase/gtrans_ifase.h>


typedef struct __GTransConnListItem GTransConnListItem;
struct __GTransConnListItem {
	
	/* The connection */
	GTransIFaseConn     *conn;
	
	/* The Plugin */
	GTransIFasePlugin   *plugin;

	/* The Editor, if open */
	GtkWidget           *gde;
};




/**
 * gtrans_conn_list_remove_selected:
 * cl : The connection list
 *
 * Remove the selected item from the connection list.
 */
void
gtrans_conn_list_remove_selected(GtkWidget *cl);



/**
 * gtrans_conn_list_selected:
 * @cl : The connection list
 *
 * Return the GTransConnListItem from the selected row.
 */
GTransConnListItem *
gtrans_conn_list_selected(GtkWidget *cl);


/**
 * gtrans_conn_list_append:
 * @cl     : The connection list
 * @conn   : The open connection
 * @plugin : The plugin manging the connection
 *
 * Append the connection to the open connection's list.
 * Create a GTransConnListItem with the data passed attach it
 * as the rows data.
 */
void
gtrans_conn_list_append(GtkWidget           *cl,
			GTransIFaseConn     *conn,
			GTransIFasePlugin   *plugin);


/**
 * gtrans_conn_list_new:
 *
 * Return a new connection list.
 */
GtkWidget *
gtrans_conn_list_new();


#endif /* __GTRANS_CONN_LIST_H__ */

