/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation
 * Authors : Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GTRANS_TABLE_DESIGNER_H__
#define __GTRANS_TABLE_DESIGNER_H__


#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtrans_ifase/gtrans_ifase.h>



#define GTRANS_TABLE_DESIGNER(obj)          GTK_CHECK_CAST(obj,\
                                            gtrans_table_designer_get_type(),\
                                            GTransTableDesigner)

#define GTRANS_TABLE_DESIGNER_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass,\
                                            gtrans_table_designer_get_type(),\
                                            GTransTableDesignerClass)

#define GTRANS_IS_TABLE_DESIGNER(obj)       GTK_CHECK_TYPE(obj,\
                                            gtrans_table_designer_get_type())


typedef struct _GTransTableDesigner        GTransTableDesigner;
typedef struct _GTransTableDesignerClass   GTransTableDesignerClass;
typedef struct _GTransTableDesignerField   GTransTableDesignerField;



struct _GTransTableDesigner {
	
	/* The parent window */
	GtkWindow        window;
	
	/* The owner, aka "the parent table designer" */
	GtkWidget       *owner;

	
	/* A GtkEntry for the name of the table */
	GtkWidget       *name_e;
	
	
	/* A GtkSheet for the fields name and type */
	GtkWidget       *matrix;
	
	/* The GtkEntry and GtkCombo for the GtkSheet */
	GtkWidget       *entry;
	GtkWidget       *combo;
	
	
	/* A GtkFrame for the fields attribute entries */
	GtkWidget       *frame;
	
	/* The last col and row we selected in the matrix */
	gint             active_col;
	gint             active_row;
	
	
	/* A linked list of allowed field types */
	GList           *field_types;

	/* The number of field attributes */ 
	gint             nattrs;

	/* A linked list of names of attributes available for the
	 * field types */
	GList           *attr_names;

	/* A linked list of masks, that filter which field type
	 * has which attributes */  
	GList           *type_masks;

	/* A linked list of linked lists (values) that each attribute 
	 * can asume */
	GList           *attr_vals;
	
	/* A linked list that point to the entrys of each attribute */
	GList           *attr_entrys;
	
	/* A linked list of arry strings for the data entered in
	 * the attribute entries, one link of the list for each
	 * row in the designer */
	GList           *attr_data;
	
	
	/* The connection to a database backend */
	GTransIFaseConn *conn;
};


struct _GTransTableDesignerClass {
	
	GtkWindowClass parent_class;
	void (* ok)    (GTransTableDesigner *gtd);
	void (* close) (GTransTableDesigner *gtd);

};



guint
gtrans_table_designer_get_type(void);



GtkWidget *
gtrans_table_designer_new(GTransIFaseConn *conn,
			  GtkWidget       *owner);



/*
 * gtrans_table_designer_get_table_name
 */
gchar *
gtrans_table_designer_get_table_name(GTransTableDesigner *gtd);



/**
 * gtrans_table_designer_get_table_def
 */
GList *
gtrans_table_designer_get_table_def(GTransTableDesigner *gtd);


#endif /* __GTRANS_TABLE_DESIGNER_H__ */







