/*
 * Copyright (C) 2018-2020 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#include "opencl/source/dll/linux/devices/device_ids.h"

// clang-format off
#ifdef SUPPORT_GEN12LP
#ifdef SUPPORT_TGLLP
DEVICE( DEV_ID_FF20, TGLLP_1x6x16, GTTYPE_GT2 )
DEVICE( DEV_ID_9A49, TGLLP_1x6x16, GTTYPE_GT2 )
DEVICE( DEV_ID_9A40, TGLLP_1x6x16, GTTYPE_GT2 )
DEVICE( DEV_ID_9A59, TGLLP_1x6x16, GTTYPE_GT2 )
DEVICE( DEV_ID_9A60, TGLLP_1x2x16, GTTYPE_GT2 )
DEVICE( DEV_ID_9A68, TGLLP_1x2x16, GTTYPE_GT2 )
DEVICE( DEV_ID_9A70, TGLLP_1x2x16, GTTYPE_GT2 )
DEVICE( DEV_ID_9A78, TGLLP_1x2x16, GTTYPE_GT2 )
#endif
#ifdef SUPPORT_DG1
DEVICE( 0x4905, DG1_CONFIG, GTTYPE_GT2 )
DEVICE( 0x4906, DG1_CONFIG, GTTYPE_GT2 )
DEVICE( 0x4907, DG1_CONFIG, GTTYPE_GT2 )
DEVICE( 0x4908, DG1_CONFIG, GTTYPE_GT2 )
#endif
#ifdef SUPPORT_RKL
DEVICE( DEVICE_ID_4C80, RKL_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEVICE_ID_4C8A, RKL_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEVICE_ID_4C8B, RKL_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEVICE_ID_4C8C, RKL_HW_CONFIG, GTTYPE_GT0_5 )
DEVICE( DEVICE_ID_4C90, RKL_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEVICE_ID_4C9A, RKL_HW_CONFIG, GTTYPE_GT1 )
#endif
#ifdef SUPPORT_ADLS
DEVICE( DEVICE_ID_4680, ADLS_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEVICE_ID_46FF, ADLS_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEVICE_ID_4600, ADLS_HW_CONFIG, GTTYPE_GT1 )
#endif
#endif

#ifdef SUPPORT_GEN11
#ifdef SUPPORT_ICLLP
// GT1
DEVICE( IICL_LP_GT1_MOB_DEVICE_F0_ID,             ICLLP_1x4x8, GTTYPE_GT1 )
DEVICE( IICL_LP_1x4x8_LOW_MEDIA_ULT_DEVICE_F0_ID, ICLLP_1x4x8, GTTYPE_GT1 )
DEVICE( IICL_LP_1x4x8_LOW_MEDIA_ULX_DEVICE_F0_ID, ICLLP_1x4x8, GTTYPE_GT1 )
DEVICE( IICL_LP_1x6x8_ULX_DEVICE_F0_ID,           ICLLP_1x6x8, GTTYPE_GT1 )
DEVICE( IICL_LP_1x6x8_ULT_DEVICE_F0_ID,           ICLLP_1x6x8, GTTYPE_GT1 )
// GT2
DEVICE( IICL_LP_1x8x8_SUPERSKU_DEVICE_F0_ID,      ICLLP_1x8x8, GTTYPE_GT2 )
DEVICE( IICL_LP_1x8x8_ULT_DEVICE_F0_ID,           ICLLP_1x8x8, GTTYPE_GT2 )
DEVICE( IICL_LP_1x8x8_ULX_DEVICE_F0_ID,           ICLLP_1x8x8, GTTYPE_GT2 )

#endif

#ifdef SUPPORT_LKF
DEVICE( ILKF_1x8x8_DESK_DEVICE_F0_ID,        LKF_1x8x8, GTTYPE_GT1 )
#endif

#ifdef SUPPORT_EHL
DEVICE( DEV_ID_4500, EHL_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEV_ID_4541, EHL_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEV_ID_4551, EHL_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEV_ID_4571, EHL_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEV_ID_4555, EHL_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEV_ID_4E51, EHL_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEV_ID_4E61, EHL_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEV_ID_4E71, EHL_HW_CONFIG, GTTYPE_GT1 )
DEVICE( DEV_ID_4E55, EHL_HW_CONFIG, GTTYPE_GT1 )

#endif
#endif

#ifdef SUPPORT_GEN9
#ifdef SUPPORT_SKL
// GT1
DEVICE( ISKL_GT1_DESK_DEVICE_F0_ID,         SKL_1x2x6,  GTTYPE_GT1 )
DEVICE( ISKL_GT1_DT_DEVICE_F0_ID,           SKL_1x2x6,  GTTYPE_GT1 )
DEVICE( ISKL_GT1_HALO_MOBL_DEVICE_F0_ID,    SKL_1x2x6,  GTTYPE_GT1 )
DEVICE( ISKL_GT1_SERV_DEVICE_F0_ID,         SKL_1x2x6,  GTTYPE_GT1 )
DEVICE( ISKL_GT1_ULT_DEVICE_F0_ID,          SKL_1x2x6,  GTTYPE_GT1 )
DEVICE( ISKL_GT1_ULX_DEVICE_F0_ID,          SKL_1x2x6,  GTTYPE_GT1 )
// GT1_5
DEVICE( ISKL_GT1_5_DT_DEVICE_F0_ID,         SKL_1x3x6,  GTTYPE_GT1_5 )
DEVICE( ISKL_GT1_5_ULT_DEVICE_F0_ID,        SKL_1x3x6,  GTTYPE_GT1_5 )
DEVICE( ISKL_GT1_5_ULX_DEVICE_F0_ID,        SKL_1x3x6,  GTTYPE_GT1_5 )
// GT2
DEVICE( ISKL_GT2_DESK_DEVICE_F0_ID,         SKL_1x3x8,  GTTYPE_GT2 )
DEVICE( ISKL_GT2_DT_DEVICE_F0_ID,           SKL_1x3x8,  GTTYPE_GT2 )
DEVICE( ISKL_GT2_HALO_MOBL_DEVICE_F0_ID,    SKL_1x3x8,  GTTYPE_GT2 )
DEVICE( ISKL_GT2_SERV_DEVICE_F0_ID,         SKL_1x3x8,  GTTYPE_GT2 )
DEVICE( ISKL_GT2_ULT_DEVICE_F0_ID,          SKL_1x3x8,  GTTYPE_GT2 )
DEVICE( ISKL_GT2_ULX_DEVICE_F0_ID,          SKL_1x3x8,  GTTYPE_GT2 )
DEVICE( ISKL_GT2_WRK_DEVICE_F0_ID,          SKL_1x3x8,  GTTYPE_GT2 )
DEVICE( ISKL_GT2F_ULT_DEVICE_F0_ID,         SKL_1x3x8,  GTTYPE_GT2 )
DEVICE( ISKL_LP_DEVICE_F0_ID,               SKL_1x3x8,  GTTYPE_GT2 )
// GT3
DEVICE( ISKL_GT3_DESK_DEVICE_F0_ID,         SKL_2x3x8,  GTTYPE_GT3 )
DEVICE( ISKL_GT3_HALO_MOBL_DEVICE_F0_ID,    SKL_2x3x8,  GTTYPE_GT3 )
DEVICE( ISKL_GT3_MEDIA_SERV_DEVICE_F0_ID,   SKL_2x3x8,  GTTYPE_GT3 )
DEVICE( ISKL_GT3_SERV_DEVICE_F0_ID,         SKL_2x3x8,  GTTYPE_GT3 )
DEVICE( ISKL_GT3_ULT_DEVICE_F0_ID,          SKL_2x3x8,  GTTYPE_GT3 )
DEVICE( ISKL_GT3e_ULT_DEVICE_F0_ID_540,     SKL_2x3x8,  GTTYPE_GT3 )
DEVICE( ISKL_GT3e_ULT_DEVICE_F0_ID_550,     SKL_2x3x8,  GTTYPE_GT3 )
// GT4
DEVICE( ISKL_GT4_DESK_DEVICE_F0_ID,         SKL_3x3x8,  GTTYPE_GT4 )
DEVICE( ISKL_GT4_DT_DEVICE_F0_ID,           SKL_3x3x8,  GTTYPE_GT4 )
DEVICE( ISKL_GT4_HALO_MOBL_DEVICE_F0_ID,    SKL_3x3x8,  GTTYPE_GT4 )
DEVICE( ISKL_GT4_SERV_DEVICE_F0_ID,         SKL_3x3x8,  GTTYPE_GT4 )
DEVICE( ISKL_GT4_WRK_DEVICE_F0_ID,          SKL_3x3x8,  GTTYPE_GT4 )
#endif

#ifdef SUPPORT_KBL
// GT1
DEVICE( IKBL_GT1_DT_DEVICE_F0_ID,            KBL_1x2x6,  GTTYPE_GT1 )
DEVICE( IKBL_GT1_HALO_DEVICE_F0_ID,          KBL_1x2x6,  GTTYPE_GT1 )
DEVICE( IKBL_GT1_SERV_DEVICE_F0_ID,          KBL_1x2x6,  GTTYPE_GT1 )
DEVICE( IKBL_GT1_ULT_DEVICE_F0_ID,           KBL_1x2x6,  GTTYPE_GT1 )
DEVICE( IKBL_GT1_ULX_DEVICE_F0_ID,           KBL_1x3x6,  GTTYPE_GT1 )
DEVICE( IKBL_GT1F_HALO_DEVICE_F0_ID,         KBL_1x2x6,  GTTYPE_GT1 )
// GT1_5
DEVICE( IKBL_GT1_5_ULT_DEVICE_F0_ID,         KBL_1x3x6,  GTTYPE_GT1_5 )
DEVICE( IKBL_GT1_5_ULX_DEVICE_F0_ID,         KBL_1x2x6,  GTTYPE_GT1_5 )
// GT2
DEVICE( IKBL_GT2_DT_DEVICE_F0_ID,            KBL_1x3x8,  GTTYPE_GT2 )
DEVICE( IKBL_GT2_HALO_DEVICE_F0_ID,          KBL_1x3x8,  GTTYPE_GT2 )
DEVICE( IKBL_GT2_R_ULT_DEVICE_F0_ID,         KBL_1x3x8,  GTTYPE_GT2 )
DEVICE( IKBL_GT2_SERV_DEVICE_F0_ID,          KBL_1x3x8,  GTTYPE_GT2 )
DEVICE( IKBL_GT2_ULT_DEVICE_F0_ID,           KBL_1x3x8,  GTTYPE_GT2 )
DEVICE( IKBL_GT2_ULX_DEVICE_F0_ID,           KBL_1x3x8,  GTTYPE_GT2 )
DEVICE( IKBL_GT2_WRK_DEVICE_F0_ID,           KBL_1x3x8,  GTTYPE_GT2 )
DEVICE( IKBL_GT2_R_ULX_DEVICE_F0_ID,         KBL_1x3x8,  GTTYPE_GT2 )
DEVICE( IKBL_GT2F_ULT_DEVICE_F0_ID,          KBL_1x3x8,  GTTYPE_GT2 )
// GT3
DEVICE( IKBL_GT3_15W_ULT_DEVICE_F0_ID,       KBL_2x3x8,  GTTYPE_GT3 )
DEVICE( IKBL_GT3_28W_ULT_DEVICE_F0_ID,       KBL_2x3x8,  GTTYPE_GT3 )
DEVICE( IKBL_GT3_HALO_DEVICE_F0_ID,          KBL_2x3x8,  GTTYPE_GT3 )
DEVICE( IKBL_GT3_SERV_DEVICE_F0_ID,          KBL_2x3x8,  GTTYPE_GT3 )
DEVICE( IKBL_GT3_ULT_DEVICE_F0_ID,           KBL_2x3x8,  GTTYPE_GT3 )
// GT4
DEVICE( IKBL_GT4_DT_DEVICE_F0_ID,            KBL_3x3x8,  GTTYPE_GT4 )
DEVICE( IKBL_GT4_HALO_DEVICE_F0_ID,          KBL_3x3x8,  GTTYPE_GT4 )
DEVICE( IKBL_GT4_SERV_DEVICE_F0_ID,          KBL_3x3x8,  GTTYPE_GT4 )
DEVICE( IKBL_GT4_WRK_DEVICE_F0_ID,           KBL_3x3x8,  GTTYPE_GT4 )
#endif

#ifdef SUPPORT_CFL
// GT1
DEVICE( ICFL_GT1_DT_DEVICE_F0_ID,               CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_S41_DT_DEVICE_F0_ID,           CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_S61_DT_DEVICE_F0_ID,           CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_41F_2F1F_ULT_DEVICE_F0_ID,     CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_S6_S4_S2_F1F_DT_DEVICE_F0_ID,  CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_U41F_U2F1F_ULT_DEVICE_F0_ID,   CFL_1x2x6,  GTTYPE_GT1 )
// GT2
DEVICE( ICFL_GT2_DT_DEVICE_F0_ID,               CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_HALO_DEVICE_F0_ID,             CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_HALO_WS_DEVICE_F0_ID,          CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_S42_DT_DEVICE_F0_ID,           CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_S62_DT_DEVICE_F0_ID,           CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_SERV_DEVICE_F0_ID,             CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_S82_S6F2_DT_DEVICE_F0_ID,      CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_U42F_U2F1F_ULT_DEVICE_F0_ID,   CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_U42F_U2F2F_ULT_DEVICE_F0_ID,   CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_U42F_U2F2_ULT_DEVICE_F0_ID,    CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_S8_S2_DT_DEVICE_F0_ID,         CFL_1x3x8,  GTTYPE_GT2 )
// GT3
DEVICE( ICFL_HALO_DEVICE_F0_ID,                 CFL_2x3x8,  GTTYPE_GT3 )
DEVICE( ICFL_GT3_ULT_15W_DEVICE_F0_ID,          CFL_2x3x8,  GTTYPE_GT3 )
DEVICE( ICFL_GT3_ULT_15W_42EU_DEVICE_F0_ID,     CFL_2x3x8,  GTTYPE_GT3 )
DEVICE( ICFL_GT3_ULT_28W_DEVICE_F0_ID,          CFL_2x3x8,  GTTYPE_GT3 )
DEVICE( ICFL_GT3_ULT_DEVICE_F0_ID,              CFL_2x3x8,  GTTYPE_GT3 )
DEVICE( ICFL_GT3_U43_ULT_DEVICE_F0_ID,          CFL_2x3x8,  GTTYPE_GT3 )

// CML GT1
DEVICE( ICFL_GT1_ULT_DEVICE_V0_ID,     CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_ULT_DEVICE_A0_ID,     CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_ULT_DEVICE_S0_ID,     CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_ULT_DEVICE_K0_ID,     CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_ULX_DEVICE_S0_ID,     CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_DT_DEVICE_P0_ID,      CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_DT_DEVICE_G0_ID,      CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_HALO_DEVICE_16_ID,    CFL_1x2x6,  GTTYPE_GT1 )
DEVICE( ICFL_GT1_HALO_DEVICE_18_ID,    CFL_1x2x6,  GTTYPE_GT1 )
// CML GT2
DEVICE( ICFL_GT2_ULT_DEVICE_V0_ID,     CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_ULT_DEVICE_A0_ID,     CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_ULT_DEVICE_S0_ID,     CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_ULT_DEVICE_K0_ID,     CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_ULX_DEVICE_S0_ID,     CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_DT_DEVICE_P0_ID,      CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_DT_DEVICE_G0_ID,      CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_HALO_DEVICE_15_ID,    CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_HALO_DEVICE_17_ID,    CFL_1x3x8,  GTTYPE_GT2 )
// CML WORKSTATION
DEVICE( ICFL_GT2_WKS_DEVICE_P0_ID,    CFL_1x3x8,  GTTYPE_GT2 )
DEVICE( ICFL_GT2_WKS_DEVICE_G0_ID,    CFL_1x3x8,  GTTYPE_GT2 )
#endif

#ifdef SUPPORT_GLK
DEVICE( IGLK_GT2_ULT_18EU_DEVICE_F0_ID,      GLK_1x3x6, GTTYPE_GTA )
DEVICE( IGLK_GT2_ULT_12EU_DEVICE_F0_ID,      GLK_1x2x6, GTTYPE_GTA )
#endif

#ifdef SUPPORT_BXT
DEVICE(IBXT_A_DEVICE_F0_ID,                 BXT_1x3x6,  GTTYPE_GTA)
DEVICE(IBXT_C_DEVICE_F0_ID,                 BXT_1x3x6,  GTTYPE_GTA)
DEVICE(IBXT_GT_3x6_DEVICE_ID,               BXT_1x3x6,  GTTYPE_GTA)
DEVICE(IBXT_P_3x6_DEVICE_ID,                BXT_1x3x6,  GTTYPE_GTA)   //18EU APL
DEVICE(IBXT_P_12EU_3x6_DEVICE_ID,           BXT_1x2x6,  GTTYPE_GTA)   //12EU APL
DEVICE(IBXT_PRO_12EU_3x6_DEVICE_ID,         BXT_1x2x6,  GTTYPE_GTA)   //12EU APL
DEVICE(IBXT_PRO_3x6_DEVICE_ID,              BXT_1x3x6,  GTTYPE_GTA)
DEVICE(IBXT_X_DEVICE_F0_ID,                 BXT_1x3x6,  GTTYPE_GTA)
#endif
#endif

#ifdef SUPPORT_GEN8
// GT1
DEVICE( IBDW_GT1_DESK_DEVICE_F0_ID,         BDW_1x2x6,  GTTYPE_GT1 )
DEVICE( IBDW_GT1_HALO_MOBL_DEVICE_F0_ID,    BDW_1x2x6,  GTTYPE_GT1 )
DEVICE( IBDW_GT1_SERV_DEVICE_F0_ID,         BDW_1x2x6,  GTTYPE_GT1 )
DEVICE( IBDW_GT1_ULT_MOBL_DEVICE_F0_ID,     BDW_1x2x6,  GTTYPE_GT1 )
DEVICE( IBDW_GT1_ULX_DEVICE_F0_ID,          BDW_1x2x6,  GTTYPE_GT1 )
DEVICE( IBDW_GT1_WRK_DEVICE_F0_ID,          BDW_1x2x6,  GTTYPE_GT1 )
// GT2
DEVICE( IBDW_GT2_DESK_DEVICE_F0_ID,         BDW_1x3x8,  GTTYPE_GT2 )
DEVICE( IBDW_GT2_HALO_MOBL_DEVICE_F0_ID,    BDW_1x3x8,  GTTYPE_GT2 )
DEVICE( IBDW_GT2_SERV_DEVICE_F0_ID,         BDW_1x3x8,  GTTYPE_GT2 )
DEVICE( IBDW_GT2_ULT_MOBL_DEVICE_F0_ID,     BDW_1x3x8,  GTTYPE_GT2 )
DEVICE( IBDW_GT2_ULX_DEVICE_F0_ID,          BDW_1x3x8,  GTTYPE_GT2 )
DEVICE( IBDW_GT2_WRK_DEVICE_F0_ID,          BDW_1x3x8,  GTTYPE_GT2 )
// GT3
DEVICE( IBDW_GT3_DESK_DEVICE_F0_ID,         BDW_2x3x8,  GTTYPE_GT3 )
DEVICE( IBDW_GT3_HALO_MOBL_DEVICE_F0_ID,    BDW_2x3x8,  GTTYPE_GT3 )
DEVICE( IBDW_GT3_SERV_DEVICE_F0_ID,         BDW_2x3x8,  GTTYPE_GT3 )
DEVICE( IBDW_GT3_ULT_MOBL_DEVICE_F0_ID,     BDW_2x3x8,  GTTYPE_GT3 )
DEVICE( IBDW_GT3_ULT25W_MOBL_DEVICE_F0_ID,  BDW_2x3x8,  GTTYPE_GT3 )
DEVICE( IBDW_GT3_ULX_DEVICE_F0_ID,          BDW_2x3x8,  GTTYPE_GT3 )
DEVICE( IBDW_GT3_WRK_DEVICE_F0_ID,          BDW_2x3x8,  GTTYPE_GT3 )
#endif
// clang-format on
