#!/bin/bash

##
## Edit the following three lines to change where ROTJ is installed to:
##

# programs
export BIN=/usr/local/bin

# data files
export DATA=/usr/local/share/games/ire/reign-of-the-just

# documentation
export DOCS=/usr/local/share/doc/reign-of-the-just


##
## Now say what's going to happen
##

echo
echo Reign of the Just installer
echo ---------------------------
echo
echo Reign of the Just will be installed in the following directories:
echo
echo Program: $BIN/
echo Datafiles: $DATA/
echo Documenatation: $DOCS/
echo
echo ..if you want to change this, edit the 'install.sh' file.
echo 
echo You may need to log in as root or SU root to do all this.
echo
echo Press ENTER to continue, or Control-C to quit.
echo
read

echo ---------------------------
echo

##
## Now do the installation
##

echo
echo Installing..


rm -f $BIN/reign >& /dev/null
echo "ire -game $DATA" > $BIN/reign

if ! test -f $BIN/reign
then
	echo "Couldn't create file $BIN/reign"
	echo
	echo "You may need to be root for this to work"
	exit 1
fi

chmod +x $BIN/reign &> /dev/null
mkdir -p $DATA
mkdir -p $DOCS

if ! install -m655 ./ire $BIN/
then
	echo "Couldn't install $BIN/ire"
	echo
	echo "You may need to be root for this to work"
	exit
fi

if ! cp -af ./data/* $DATA/
then
	echo "Couldn't copy datafiles"
	echo
	echo "You may need to be root for this to work"
	exit
fi

if ! install -m644 ./docs/* $DOCS/
then
	echo "Couldn't copy documentation"
	echo
	echo "You may need to be root for this to work"
	exit
fi

##
## Copy the audio library into place and register it with the system
##

if ! install -m655 ./libfmod* /usr/local/lib/
then
	echo "Couldn't install FMOD library"
	echo
	echo "You may need to be root for this to work"
	exit
fi

if ! ldconfig
then
	echo "Couldn't run ldconfig to set up the library."
	echo
	echo "You must be root to do this bit."
	exit
fi

##
## Make an uninstaller
##

export GOAWAY=$BIN/reign-uninstall

echo echo This will remove Reign Of The Just > $GOAWAY
echo echo >> $GOAWAY
echo echo Press ENTER to continue, or Control-C to quit.>> $GOAWAY
echo echo >> $GOAWAY
echo read >> $GOAWAY
echo rm -f $BIN/reign >> $GOAWAY
echo rm -rf $DATA >> $GOAWAY
echo rm -rf $DOCS >> $GOAWAY
echo rm -f $BIN/reign-uninstall >> $GOAWAY
echo echo >> $GOAWAY
echo echo Done. >> $GOAWAY
chmod +x $GOAWAY

echo
echo
echo ---------------------------
echo
echo Done
echo
echo You can start the game by typing \'reign\'
echo
echo You can remove the game by typing \'reign-uninstall\'
echo

