# $Id: away.pl,v 1.1.1.1 2002/02/13 06:24:50 root Exp $

use Irssi 20020121.2020 ();
$VERSION = "0.20";
%IRSSI = (
	  authors     => 'Jean-Yves "decadix" Lefort',
	  contact     => 'jylefort\@brutele.be, decadix on IRCNet',
	  name        => 'away',
	  description => 'Adds away_reason and autounaway_level settings',
	  license     => 'BSD',
	  changed     => '$Date: 2002/02/13 06:24:50 $ ',
);

# /set's:
#
#	away_reason		if you are not away and type /AWAY without
#				arguments, this string will be used as
#				your away reason
#
#	autounaway_level	if you are away and you type a message
#				belonging to one of these levels, you'll be
#				automatically unmarked away
#
#				levels considered:
#
#				DCC		a dcc chat connection has
#						been established
#				PUBLICS		a public message from you
#				MSGS		a private message from you
#				ACTIONS		an action from you
#				NOTICES		a notice from you
#
# todo:
#
#	* rewrite the away command to support -one and -all switches
#	* implement an auto_away feature

use strict;
use Irssi::Irc;			# for DCC object

sub away {
  my ($args, $server, $item) = @_;
  
  if ($server && ! $server->{usermode_away} && ! $args) {
    $server->command("/AWAY " . Irssi::settings_get_str("away_reason"));
    Irssi::signal_stop();
  }
}

sub cond_unaway {
  my ($server, $level) = @_;
  $server->command("/AWAY")
    if ($server->{usermode_away} &&
	Irssi::level2bits(Irssi::settings_get_str("autounaway_level")) &
	$level);
}

sub dcc_connected {
  my ($dcc) = @_;
  cond_unaway($dcc->{server}, MSGLEVEL_DCC) if ($dcc->{type} eq "CHAT");
}

sub message_own_public {
  my ($server, $msg, $target) = @_;
  cond_unaway($server, MSGLEVEL_PUBLIC);
}

sub message_own_private {
  my ($server, $msg, $target, $orig_target) = @_;
  cond_unaway($server, MSGLEVEL_MSGS);
}

sub message_irc_own_action {
  my ($server, $msg, $target) = @_;
  cond_unaway($server, MSGLEVEL_ACTIONS);
}

sub message_irc_own_notice {
  my ($server, $msg, $target) = @_;
  cond_unaway($server, MSGLEVEL_NOTICES);
}

Irssi::settings_add_str("misc", "away_reason", "not here");
Irssi::settings_add_str("misc", "autounaway_level", "PUBLIC MSGS ACTIONS DCC");

Irssi::signal_add("dcc connected", "dcc_connected");
Irssi::signal_add("message own_public", "message_own_public");
Irssi::signal_add("message own_private", "message_own_private");
Irssi::signal_add("message irc own_action", "message_irc_own_action");
Irssi::signal_add("message irc own_notice", "message_irc_own_notice");

Irssi::command_bind("away", "away");
