# adds a statusbar item which replaces the [Act: ...] item with channelnames
# for irssi 0.8.2 by bd@bc-bd.org
#
# inspired by chanlist.pl by 'cumol@hammerhart.de'
#
#########
# USAGE
###
# 
# copy the script to ~/.irssi/scripts/
#
# In irssi:
#
#		/script load chanact
#		/statusbar window add chanact -after act
#
# If you want the item to appear on another position read the help
# for /statusbar.
# To remove the [Act: 1,2,3] item type:
#
#		/statusbar window remove act
#
#########
# OPTIONS
#########
#
# /set channel_color_all <ON|OFF>
#		* ON  : color the window number and the channel name
#		* OFF : color only the window number
#
# /set channel_show_all <ON|OFF>
#		* ON  : show all windows
#		* OFF : show only those with activity
#
# /set channel_show_mode <ON|OFF>
#		* ON  : show your channel mode (e.g.: @,+,%)
#		* OFF : don't show your mode
#
#########
# HINTS
#########
#
# If you have trouble with wrong colored entries your 'default.theme' might be too old.
# Try on a shell:
#
# 	$ mv ~/.irssi/default.theme /tmp/
#
# And in irssi:
#	/reload
#	/save
#
###
################
###
# Changelog
#
# 0.3
#	- merge with chanlist.pl
#		+ added setting 'chanact_show_mode'
#		+ added setting 'chanact_show_all'
#
# 0.2
#	- added 'Act' to the item
#  - added setting 'chanact_color_all'
#  - finally found format for statusbar hilight
#
# 0.1
#	- Initial Release
#
###
################


use Irssi 20020101.0001 ();
use strict;
use Irssi::TextUI;

use vars qw($VERSION %IRSSI);

$VERSION = "0.3";
%IRSSI = (
    authors     => 'BC-bd',
    contact     => 'bd@bc-bd.org',
    name        => 'chanact',
    description => 'adds a statusbar item which replaces the [Act: ...] item with channelnames',
    license     => 'GNU GPLv2 or later',
	 url         => 'http://bc-bd.org/software.php3#irssi'
);

my ($actString,$needRemake);

# method will get called every time the statusbar item will be displayed
# but we dont need to recreate the item every time so we first
# check if something has changed and only then we recreate the string
# this might just save some cycles
sub chanact {
	my ($item, $get_size_only) = @_;

	if ($needRemake) {
		remake();
	}

	$item->default_handler($get_size_only, $actString, undef, 1);
}

# this is the real creation method
sub remake() {
	my ($afternumber,$finish,$hilight,$mode);

	# get the color setting
	# i know this is ugly, mail me a better way if you can think of one
	if (Irssi::settings_get_bool('chanact_color_all') == 1) {
		$afternumber = "";
		$finish = "}{sb_background}";
	} else {
		$afternumber = "}{sb_background}";
		$finish = "";
	}

	$actString = "";
	foreach (sort { $a->{refnum} <=> $b->{refnum} } Irssi::windows) {
		my $name = $_->get_active_name;

		# (status) is an awfull long name, so make it short to 'S'
		if ($name eq "(status)") {
			$name = "S";
		}
	
		# check if we should show the mode
		if ($_->{active}->{type} eq "CHANNEL" && Irssi::settings_get_bool('chanact_show_mode') eq 1) {
     		my $server = $_->{active_server};
     		my $channel = $server->channel_find($name);
     		my $nick = $channel->nick_find($server->{nick});
			
			if ($nick->{op}) {
				$mode = "@";
			} elsif ($nick->{voice}) {
				$mode = "+";
			} elsif ($nick->{halfop}) {
				$mode = "%";
			} else {
				$mode = "";
			}
		} else {
			$mode = "";
		}

		# find the right color
		if ($_->{data_level} == 1) {
			$hilight = "{sb_act_text ";
		} elsif ($_->{data_level} == 2) {
			$hilight = "{sb_act_msg ";
		} elsif ($_->{data_level} == 3) {
			$hilight = "{sb_act_hilight ";
		} else {
			if (Irssi::settings_get_bool('chanact_show_all') == 1) {
				$hilight = "{%n ";
			} else {
				next;
			}
		}

		# comose the string
		$actString .= $hilight.$_->{refnum}.$afternumber.":".$mode.$name.$finish." ";
	}

	# assemble the final string
	if ($actString ne "") {
		if (Irssi::settings_get_bool('chanact_show_all') == 1) {
			$actString = "{sb ".$actString."}";
		} else {
			$actString = "{sb Act: ".$actString."}";
		}
	}

	# no remake needed any longer
	$needRemake = 0;
}

# method called because of some events. here we dont remake the item but just
# remember that we have to remake it the next time we are called
sub chanactHasChanged()
{
	$needRemake = 1;

	Irssi::statusbar_items_redraw('chanact');
}

$needRemake = 1;

# our config item
Irssi::settings_add_bool('misc', 'chanact_color_all', 1);
Irssi::settings_add_bool('misc', 'chanact_show_mode', 0);
Irssi::settings_add_bool('misc', 'chanact_show_all', 0);

# register the statusbar item
Irssi::statusbar_item_register('chanact', '$0', 'chanact');
Irssi::statusbars_recreate_items();

# register all that nifty callbacks on special events
Irssi::signal_add_last('setup changed', 'chanactHasChanged');
Irssi::signal_add_last('window changed', 'chanactHasChanged');
Irssi::signal_add_last('window item changed', 'chanactHasChanged');
Irssi::signal_add_last('window hilight', 'chanactHasChanged');
Irssi::signal_add_last('window item hilight', 'chanactHasChanged');
Irssi::signal_add("window created", "chanactHasChanged");
Irssi::signal_add("window destroyed", "chanactHasChanged");
Irssi::signal_add("window name changed", "chanactHasChanged");
Irssi::signal_add("window activity", "chanactHasChanged");
Irssi::signal_add("print text", "chanactHasChanged");
Irssi::signal_add('nick mode changed', 'chanactHasChanged');

