#ifndef _REPL_GLUE_H
#define _REPL_GLUE_H

#include "KayaAPI.h"
#include "VMState.h"

extern "C" {
    // Load a program, living in a shared object
//    void interp_load(const char* pathname);

    // Initialise the interpreter (i.e. set up garbage collection)
    void interp_init();

    // Push a value onto the stack for the return value of a function
    void interp_prepare_call();

    // Clear the stack
    void interp_clear();

    // Push values
    void interp_push_int(kint v);
    void interp_push_float(double v);
    void interp_push_string(char* v);

    // Call a function in the given vm, in the loaded program.
    kint interp_call(void* handle, const char* function);

    // Make an array
    void interp_array(kint size);

    // Run operators
    void interp_op(kint opid);
    void interp_floatopfn(kint opid);
    void interp_unop(kint opid);
    void interp_floatunop(kint opid);
    void interp_append();

    // Coercions
    void interp_str2int();
    void interp_int2str();
    void interp_str2real();
    void interp_real2str();
    void interp_str2chr();
    void interp_chr2str();
    void interp_int2real();
    void interp_real2int();
    void interp_bool2str();
}

#endif
