/*
 * Initial Authot: 	Sheer El-Showk
 * Date:			08/27/99
 *
 * This is where all the initialization for knetfilter should be done
 * (initialize() is run early in main()).  Any checks or program preconditions
 * should be done here.
 *
 */
/*

  knetfilter v 3.3.1

  Copyright (C) 2004 Luigi Genoni
                     venom@sns.it
*/

#include <stdlib.h>
#include "knat.h"

/*
 * Its ok to declare this here since its not really going to
 * be used elsewhere.
 */
struct procfile 
{
	/* initialize fl to NULL */
	FILE* fl;
	char* filename;
	char* perms;
	/* a string to write to the file or NULL if nothing to write */
	char* to_write;
	/* an error message to display on failure -- should not be NULL */
	char* error;
	/* is failure to open/write fatal? */
	int fatal;
};


/* 
 * A list of files in /proc that need to be written to
 * to make sure all the networking features of the kernel are running
 */

#define NUM_PROC_FILES	19	

procfile pf[NUM_PROC_FILES] = 
	{
	 {NULL, "/proc/net/ip_conntrack", "r", NULL, 
		"You don't have ip_conntrack and ipt_conntrack modules\n"
	        "loaded in your kernel. You won't be able to use \n"
	        "all knetfilter features. Please load them or \n" 
		"recompile the kernel and netfilter tools.\n", 0},
	 {NULL, "/proc/sys/net/ipv4/ip_forward", "r+", "1", 
		"Could not write to /proc/sys/net/ipv4/ip_forward.\n", 1},
	 {NULL, "/proc/sys/net/ipv4/ip_dynaddr", "r+", "1",
		"Could not write to /proc/sys/net/ipv4/ip_dynaddr.\n", 1},
	 {NULL, "/proc/sys/net/ipv4/icmp_echo_ignore_broadcasts", "r+", "1",
		"Could not write to /proc/sys/net/ipv4/icmp_echo_ignore_broadcasts.\n", 1},
	 {NULL, "/proc/sys/net/ipv4/icmp_ignore_bogus_error_responses", "r+", "1",
		"Could not write to /proc/sys/net/ipv4/icmp_ignore_bogus_error_responses.\n", 1},
	 {NULL, "/proc/sys/net/ipv4/conf/all/secure_redirects", "r+", "1",
		"Could not write to /proc/sys/net/ipv4/conf/all/secure_redirects.\n", 1},	 
	 {NULL, "/proc/sys/net/ipv4/conf/all/send_redirects", "r+", "1",
		"Could not write to /proc/sys/net/ipv4/conf/all/send_redirects\n", 1},
// NEED TO MAKE THIS 1 for tcp_syncookies
	 {NULL, "/proc/sys/net/ipv4/tcp_syncookies", "r+", "1", 
		"Could not write to /proc/sys/net/ipv4/tcp_syncookies.\n", 0},
	 {NULL, "/proc/sys/net/ipv4/conf/all/accept_source_route","r+", "1", 
		"Could not write to /proc/sys/net/ipv4/conf/all/accept_source_route.\n", 1},
	 {NULL, "/proc/sys/net/ipv4/conf/all/forwarding", "r+", "1",
		"Could not write to /proc/sys/net/ipv4/conf/all/forwarding.\n", 1},
	 {NULL, "/proc/sys/net/ipv4/conf/all/log_martians", "r+", "0",
		"Could not write to /proc/sys/net/ipv4/conf/all/log_martians.\n", 1},
	 {NULL, "/proc/sys/net/ipv4/conf/all/rp_filter", "r+", "1",
		"Could not write to /proc/sys/net/ipv4/conf/all/rp_filter.\n", 1},
	 {NULL, "/proc/sys/net/ipv4/route/max_size", "r+", "65536",
		"Could not write to /proc/sys/net/ipv4/route/max_size.\n", 1},
// LET'S TRY TO OPTIMIZE BUFFER SIZES
	 {NULL, "/proc/sys/net/core/optmem_max", "r+", "262144",
		"Could not write to /proc/sys/net/core/optmem_max.\n", 1},
	 {NULL, "/proc/sys/net/core/rmem_default", "r+", "262144",
		"Could not write to /proc/sys/net/core/rmem_default.\n", 1},
	 {NULL, "/proc/sys/net/core/rmem_max", "r+", "262144",
		"Could not write to /proc/sys/net/core/rmem_max.\n", 1},
	 {NULL, "/proc/sys/net/core/wmem_default", "r+", "262144",
		"Could not write to /proc/sys/net/core/wmem_default.\n", 1},
	 {NULL, "/proc/sys/net/core/wmem_max", "r+", "262144",
		"Could not write to /proc/sys/net/core/wmem_max.\n", 1},
	 {NULL, "/proc/sys/net/core/netdev_max_backlog", "r+", "500",
		"Could not write to /proc/sys/net/core/netdev_max_backlog.\n", 1}
	};




int initialize()
{

	int uid;
	uid = getuid();
	FILE *sbin;
	FILE *sbin2;
	FILE *sbin3;
	FILE *sbin4;
	FILE *sbin5;
	FILE *sbin6;

	sbin = fopen("/usr/bin/iptables", "r");
	sbin2 = fopen("/usr/local/bin/iptables", "r");
	sbin3 = fopen("/sbin/iptables", "r");
	sbin4 = fopen("/usr/sbin/iptables", "r");
	sbin5 = fopen("/usr/local/sbin/iptables", "r");
	sbin6 = fopen("/bin/iptables", "r");

	/*
	 * check if user is root.
 	 */
	if(uid>0)
	{
		QMessageBox::critical(0, "Error",
			"You are not running knetfilter as root.\n");
		exit(0);
	} 
	/*
	 * check if we have iptables.
 	 */
	else if(sbin==NULL && sbin2==NULL && sbin3==NULL && sbin4==NULL && sbin5==NULL && sbin6==NULL) 
	{
		QMessageBox::critical(0, "Error",
			"Couldn't locate iptables. Please install\n"
			"iptables, or confront the help file.\n");
		fclose(sbin);
		fclose(sbin2);
		fclose(sbin3);
		fclose(sbin4);
		fclose(sbin5);
		fclose(sbin6);
		exit(0);
	}


	/*
	 * Check all our /proc files
	 */
	for (int x = 0; x < NUM_PROC_FILES; x++)
	{
		pf[x].fl = fopen(pf[x].filename, pf[x].perms);
		if (pf[x].fl != NULL) /* on success */
		{
			/* if we have something to write, write it */			
			if(pf[x].to_write != NULL)
				fwrite(pf[x].to_write, 1, strlen(pf[x].to_write), pf[x].fl);
			fclose(pf[x].fl);
		}
		else /* on failure */
		{
			/* Is this a fatal condition? */
			if (pf[x].fatal) 
			{
				QMessageBox::critical(0, "Error", pf[x].error);
				exit(0);
			}
			else
			{
				QMessageBox::warning(0, "Warning", pf[x].error);
			}
		}
	}	

}


