/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2009, 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * \defgroup memory Memory interface
 * @{
 */
#ifndef SA_MEMORY_H_
#define SA_MEMORY_H_

/** \struct sa_memory memory.h
 * This structure gathers the details about the memory usage. Each value is measured in bytes.
 */
SA_EXPORT struct sa_memory {
#ifdef SA_MEMORY_TOTAL
	uint64_t total; //!< Total amount of RAM available in the system.
#endif
#ifdef SA_MEMORY_FREE
	uint64_t free; //!< Unused amount of memory.
#endif
#ifdef SA_MEMORY_ACTIVE
	uint64_t active; //!< Amount of memory in use or recently used.
#endif
#ifdef SA_MEMORY_INACTIVE
	uint64_t inactive; //!< Amount of memory that has not been recently used.
#endif
#ifdef SA_MEMORY_BUFFERS
	uint64_t buffers; //!< Memory used for cached files. Useless for metrics nowadays.
#endif
#ifdef SA_MEMORY_SWAP_TOTAL
	uint64_t swap_total; //!< Total amount of swap present in the system.
#endif
#ifdef SA_MEMORY_SWAP_FREE
	uint64_t swap_free; //!< Free amount of swap available.
#endif
#ifdef SA_MEMORY_SWAP_CACHED
	uint64_t swap_cached; //!< Amount of swap that is cached.
#endif
#ifdef SA_MEMORY_WIRED
	uint64_t wired; //!< Memory not placed on any queue.
#endif
#ifdef SA_MEMORY_CACHED
	uint64_t cached; //!< Amount of cached memory.
#endif
#ifdef SA_MEMORY_DIRTY
	uint64_t dirty; //!< Amount of memory waiting for been written to the disk.
#endif
#ifdef SA_MEMORY_EXECUTABLE
	uint64_t executable; //!< Memory used to hold executable data
#endif
#ifdef SA_MEMORY_FILES
	uint64_t files; //!< Memory used by cached file data
#endif
#ifdef SA_MEMORY_LOCKED
	uint64_t locked; //!< Memory that can not be moved to swap
#endif
};

#ifdef SA_OPEN_MEMORY
/**
 * Prepares the resources needed for retrieving memory statistics. This function exists (and is needed) only when SA_OPEN_MEMORY is defined.
 * @return If successful 0 is returned, otherwise an error code is returned.  If the operating system is not supported the return value will be ENOTSUP.
 * @see sa_close_memory()
 */
int sa_open_memory(void) SA_EXPORT;
#endif

#ifdef SA_CLOSE_MEMORY
/**
 * This function closes the resources used for retrieving memory statistics. You should call it even when there was a previous error in another function of this API. This function exists (and is needed) only when SA_CLOSE_MEMORY is defined.
 * @return If successful 0 is returned, otherwise an error code is returned.
 * @see sa_open_memory()
 */
int sa_close_memory(void) SA_EXPORT;
#endif

/**
 * Retrieves statistics about the usage of the memory.
 * @param dst Where the statistics will be stored.
 * @return If successful 0 is returned, otherwise an error code is returned.
 */
int sa_get_memory(struct sa_memory* dst) SA_EXPORT SA_NONNULL;

/*@}*/
#endif /* SA_MEMORY_H_ */
