/* C code produced by gperf version 2.7 */
/* Command-line: gperf -tCD hash.g  */
#include "parser.h"
struct tags { char *name; int value; };

#define TOTAL_KEYWORDS 25
#define MIN_WORD_LENGTH 4
#define MAX_WORD_LENGTH 14
#define MIN_HASH_VALUE 9
#define MAX_HASH_VALUE 61
/* maximum key range = 53, duplicates = 1 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
hash (str, len)
     register const char *str;
     register unsigned int len;
{
  static const unsigned char asso_values[] =
    {
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 15, 62,  0, 15, 10,
      10, 62, 62, 10, 62, 62, 62,  0, 62, 62,
       5, 62, 20, 25, 62, 62, 10, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 30, 62, 62, 62,  0, 62, 62,  0,  5,
       0, 62, 62, 62,  5,  0, 62, 62, 62, 62,
      62, 10, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
      62, 62, 62, 62, 62, 62
    };
  return len + asso_values[(unsigned char)str[len - 1]] + asso_values[(unsigned char)str[0]];
}

#ifdef __GNUC__
__inline
#endif
const struct tags *
in_word_set (str, len)
     register const char *str;
     register unsigned int len;
{
  static const struct tags wordlist[] =
    {
      {"Conflicts",		T_CONFLICTS},
      {"Conffiles",		T_CONFFILES},
      {"MD5sum",			T_MD5SUM},
      {"Provides",		T_PROVIDES},
      {"Config-Version",	T_CONFIG_VERSION},
      {"Maintainer",		T_MAINTAINER},
      {"Pre-Depends",	T_PREDEPENDS,},
      {"Version",		T_VERSION},
      {"Essential",		T_ESSENTIAL,},
      {"Depends",		T_DEPENDS},
      {"Priority",		T_PRIORITY},
      {"Description",	T_DESCRIPTION},
      {"Replaces",		T_REPLACES,},
      {"Recommends",		T_RECOMMENDS},
      {"Status",			T_STATUS},
      {"Section",		T_SECTION},
      {"Suggests",		T_SUGGESTS},
      {"source",			T_SOURCE},
      {"Package",		T_PACKAGE},
      {"installed-size",	T_INSTALLED_SIZE},
      {"Filename",		T_FILENAME},
      {"Installed-Size",	T_INSTALLED_SIZE},
      {"Architecture",	T_ARCHITECTURE},
      {"Size",			T_SIZE},
      {"Source",			T_SOURCE}
    };

  static const short lookup[] =
    {
       -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -46,
       -1,   2,  -1,   3,   4,   5,   6,   7,  -1,   8,
      -25,  -2,   9,  10,  -1,  -1,  11,  -1,  12,  -1,
       13,  14,  15,  16,  -1,  -1,  17,  -1,  -1,  -1,
       -1,  -1,  18,  -1,  19,  -1,  -1,  -1,  20,  -1,
       -1,  -1,  -1,  -1,  21,  -1,  -1,  22,  -1,  23,
       -1,  24
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register int index = lookup[key];

          if (index >= 0)
            {
              register const char *s = wordlist[index].name;

              if (*str == *s && !strcmp (str + 1, s + 1))
                return &wordlist[index];
            }
          else if (index < -TOTAL_KEYWORDS)
            {
              register int offset = - 1 - TOTAL_KEYWORDS - index;
              register const struct tags *wordptr = &wordlist[TOTAL_KEYWORDS + lookup[offset]];
              register const struct tags *wordendptr = wordptr + -lookup[offset + 1];

              while (wordptr < wordendptr)
                {
                  register const char *s = wordptr->name;

                  if (*str == *s && !strcmp (str + 1, s + 1))
                    return wordptr;
                  wordptr++;
                }
            }
        }
    }
  return 0;
}
