/*
rdns.c - MessageWall reverse DNS definitions
Copyright (C) 2002 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <firestring.h>
#include <firedns.h>
#include "messagewall.h"
#include "rdns.h"

static const char tagstring[] = "$Id: rdns.c,v 1.8 2002/07/11 03:10:38 ian Exp $";

int rdns_send_query(int client) {
	clients[client].resent_rdns = 0;

	clients[client].rdns_fd = firedns_getname4(&clients[client].ip);

	return 0;
}

int rdns_resend_query(int client) {
	if (clients[client].rdns_fd < 0)
		return 0;

	firedns_getresult(clients[client].rdns_fd);
	clients[client].rdns_fd = firedns_getname4(&clients[client].ip);

	return 0;
}

int rdns_response(int client) {
	char *ret;

	ret = firedns_getresult(clients[client].rdns_fd);
	if (ret == NULL)
		clients[client].rdns_fd = -2;
	else
		clients[client].rdns_fd = -1;

	return 0;
}

int rdns_check_profile(int client) {
	if (clients[client].profile->rdns_required == 1) {
		if (clients[client].rdns_fd == -2)
			return 1;
		if (clients[client].rdns_fd >= 0)
			return -1;
	}

	return 0;
}
