<?php
// Copyright 2004 Sung Kim (hunkim@cs.ucsc.edu)
// This is part of MoniWiki and it is 
// distributable under GPL see COPYING
//
// $Id: virtual.php,v 1.124 2003/12/19 13:48:17 wkpark Exp $
//


/**
 * Function - Find virtual sitename if available
 *
 * @param String virtual host name ( example: wiki.*.kldp.org)
 * @param String virtual sitename (Sitename for %2)
 * @return String virtual sitename or null 
 */
function virtual_find_sitename($virtual_host, $virtual_sitename) {
    // It's basically same with virtual find text dir
    // Since virtual_sitename should "Sitename for %2"
    return virtual_find_dir($virtual_host, $virtual_sitename);
}

/**
 * Function - General Find virtual directory if available
 *
 * @param String virtual host name ( example: wiki.*.kldp.org)
 * @param String virtual directory (/var/%2/dir)
 * @return String virtual dirrectory or null 
 */
function virtual_find_dir($virtual_host, $virtual_dir) {
    // No sutable arguments
    if (!$virtual_host || !$virtual_dir) {
      return;
    }

    // Check if is my host
    $host = $_SERVER['SERVER_NAME'];
    if (!virtual_is_my_host($virtual_host, $host)) {
        return;
    }

    // Let's make a translate table
    $host_arr = split('\.', $host);
    for ($i=0; $i<count($host_arr); $i++) {
        $tr_table['%'.$i] = $host_arr[$i];
    }

    // Replace %1, %2, %3 to real name
    $dir = strtr($virtual_dir, $tr_table);
    return $dir;
}

/**
 * Function - Create virtual directory if available
 *
 * @param String text directory
 * @param String Only create if referer is the virtual_ref
 * @param 0 or 1 Weather copy seed or not
 * @param String Wiki Seed directory
 * @return void
 */
function virtual_create_dir($text_dir, $virtual_ref, 
                                 $is_text_dir=0, $auto_seed=0, $seed_dir="wikiseed") {
    
    // Nothing to do
    if (is_dir($text_dir)) {
        return;
    }

    if ($virtual_ref) {
        // Check referer
        $referer = $_SERVER['HTTP_REFERER'];
        if (!fnmatch($virtual_ref, $referer)) {
            return;
        }
    }

    //#FIXME: Handle Any errors?
    mkdir($text_dir);

    if ($is_text_dir) {
        // RCS directory to keep RCS files
        mkdir($text_dir."/RCS");

        // touch edit log
        touch(virtual_edit_log($text_dir));
    }

    // Not auto seed so all set
    if (!$auto_seed) {
        return;
    }
    // No seed directory
    if (!is_dir($seed_dir)) {
        return;
    }

    // Auto seed copy
    $handle= opendir($seed_dir);
    while ($file = readdir($handle)) {
        // We don't copy directories
        if (is_dir($seed_dir.'/'.$file)) {
            continue;
        }
        
        //#FIXME: Handle errors?
        copy($seed_dir.'/'.$file, $text_dir.'/'.$file);
    }
    closedir($handle);
}


/**
 * Function - Return edit log for virtual text dire
 *
 * @param String virtual text_dir
 * @return String edit log
 */
function virtual_edit_log($text_dir) {
    return dirname($text_dir).'/'. basename($text_dir).".editlog";
}


/** 
 * Function - Check if it is my virtual host
 *
 * @param String virtual host
 * @param String hostname
 * @return true if it is my host. Otherwise false.
 */
function virtual_is_my_host($virtual_host, $host) {
    // Tokenize and put the into array
    $virtual_host_arr = split ('\.', $virtual_host);
    $host_arr = split("\.", $host);

    // Diffrent number of array
    //# FIXME: www.kldp.net.. and www.kld.net have diffrent counter.
    // split(?, $host)
    /*
    if (count($virtual_host_arr) != count($host_arr)) {
        echo "Count??";
        return false;
    }
    */
    
    for($i=0; $i< count($host_arr); $i++) {
        $virtual_one_name = $virtual_host_arr[$i];
        // We expecting * or real name
        if ($virtual_one_name == "*") { // Assume match
            continue;
        }

        $host_one_name = $host_arr[$i];

        // Compare each mane
        if ($host_one_name && strcasecmp($virtual_one_name, $host_one_name)) {
            return false;
        }
    }

    // Passed all match tests
    return true;
}

// vim:et:sts=4:sw=4
?>
