/*
 * Decompiled with CFR 0.152.
 */
package org.petzall.daapapplet;

import org.cdavies.itunes.Track;
import org.petzall.daapapplet.DAAPControls;
import org.petzall.daapapplet.Player;
import org.petzall.daapapplet.gui.GUI;

public class PlayerThread
extends Thread {
    private GUI _gui;
    private Track _t;
    private Player _p;
    private DAAPControls _controls;

    public PlayerThread(GUI gUI, DAAPControls dAAPControls) {
        this._gui = gUI;
        this._controls = dAAPControls;
    }

    public void run() {
        do {
            try {
                while (!this._controls.continuePlaying()) {
                    PlayerThread.sleep(150L);
                }
                this._t = this._controls.getNextTrack();
                this._controls.playingTrack(this._t);
                int n = 0;
                while (n < 3) {
                    try {
                        this._p = new Player(this._t.getFormat(), this._t.getInputStream());
                        n = 100;
                    }
                    catch (Exception exception) {
                        ++n;
                    }
                }
                this._p.play();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this._gui.addLogEntry("Stream error: " + exception.getMessage());
            }
        } while (!this._controls.closeDownMode());
        this._controls.stopped();
    }

    public int getPosition() {
        if (this._p == null) {
            return -1;
        }
        return this._p.getPosition();
    }

    public int getLength() {
        return this._t.getLength();
    }

    public void stopTrack() {
        this._p.close();
        this._controls.stopped();
    }

    public Track getTrack() {
        return this._t;
    }
}

