/*
**  MimeBodyPart.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Pantomime/MimeBodyPart.h>

#import <Pantomime/Constants.h>
#import <Pantomime/Message.h>
#import <Pantomime/MimeUtility.h>
#import <Pantomime/NSStringExtensions.h>
#import <Pantomime/NSDataExtensions.h>
#import <Pantomime/Parser.h>

@implementation MimeBodyPart

//
//
//
- (id) init
{
  self = [super init];

  return self;
}

//
//
//
- (id) initWithData: (NSData *) theData
{
  NSData *aLine, *headerData, *bodyData;
  NSArray *headerLines;
  int i;

  NSRange aRange;
  
  if (! theData )
    {
      NSLog(@"MimeBodyPart: -initWithData passed nil to the method.");
      AUTORELEASE(self);
      return nil;
    }

  self = [self init];
  
  aRange = [theData rangeOfCString: "\n\n"];

  if (aRange.length == 0)
    {
      NSLog(@"MimeBodyPart: -initWithData failed to initialize the body part from data.");
      AUTORELEASE(self);
      return nil;
    }

  // We verify if we have an empty body part content like:
  // X-UID: 5dc5aa4b82240000
  //
  // This is a MIME Message
  //
  // ------=_NextPart_000_007F_01BDF6C7.FABAC1B0
  //
  //
  // ------=_NextPart_000_007F_01BDF6C7.FABAC1B0
  // Content-Type: text/html; name="7english.co.kr.htm"
  if ( [theData length] == 2 )
    {
      [self setContent: [NSString stringWithString: @""]];
      
      return self;
    }
  
 
  headerData = [theData subdataToIndex: aRange.location];
  bodyData = [theData subdataWithRange: NSMakeRange(aRange.location + 2,
						    [theData length] - aRange.location - 2)];
  
  
  headerLines = [[MimeUtility unfoldLinesFromData: headerData] componentsSeparatedByCString: "\n"];
  
  for (i = 0; i < [headerLines count]; i++)
    {
      aLine = [headerLines objectAtIndex: i];
      
      // Now, let's parse them.
      if ( [aLine hasCaseInsensitiveCPrefix: "Content-Description"] )
	{
	  [Parser parseContentDescription: aLine
		  inPart: self];
	}
      else if ( [aLine hasCaseInsensitiveCPrefix: "Content-Disposition"] )
	{
	  [Parser parseContentDisposition: aLine
		  inPart: self];
	}
      else if ( [aLine hasCaseInsensitiveCPrefix: "Content-ID"] )
	{
	  [Parser parseContentID: aLine
		  inPart: self];
	}
      else if ( [aLine hasCaseInsensitiveCPrefix: "Content-Length"] )
	{
	  // We just igore that
	}
      else if ( [aLine hasCaseInsensitiveCPrefix: "Content-Transfer-Encoding"] )
	{
	  [Parser parseContentTransferEncoding: aLine
		  inPart: self];
	}
      else if ( [aLine hasCaseInsensitiveCPrefix: "Content-Type"] )
	{
	  [Parser parseContentType: aLine
		  inPart: self];
	}
    }
  
  [MimeUtility setContentFromRawSource: bodyData
	       inPart: self];
  
  return self;
}


//
//
//
- (void) dealloc
{
  [super dealloc];
}


//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  [super encodeWithCoder: theCoder];
}

- (id) initWithCoder: (NSCoder *) theCoder
{
  self = [super init];

  [super initWithCoder: theCoder];

  return self;
}

@end

