// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AVTBASEVARMETADATA_H
#define AVTBASEVARMETADATA_H
#include <dbatts_exports.h>
#include <string>
#include <AttributeSubject.h>

#include <vector>

// ****************************************************************************
// Class: avtBaseVarMetaData
//
// Purpose:
//    Contains metadata attributes associated with all mesh variables
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class DBATTS_API avtBaseVarMetaData : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    avtBaseVarMetaData();
    avtBaseVarMetaData(const avtBaseVarMetaData &obj);
protected:
    // These constructors are for objects derived from this class
    avtBaseVarMetaData(private_tmfs_t tmfs);
    avtBaseVarMetaData(const avtBaseVarMetaData &obj, private_tmfs_t tmfs);
public:
    virtual ~avtBaseVarMetaData();

    virtual avtBaseVarMetaData& operator = (const avtBaseVarMetaData &obj);
    virtual bool operator == (const avtBaseVarMetaData &obj) const;
    virtual bool operator != (const avtBaseVarMetaData &obj) const;
private:
    void Init();
    void Copy(const avtBaseVarMetaData &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    avtBaseVarMetaData(private_tmfs_t, std::string, std::string);
    void Print(ostream &, int = 0) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_name = 0,
        ID_originalName,
        ID_meshName,
        ID_validVariable,
        ID_hideFromGUI,
        ID__LAST
    };

public:
    std::string name;
    std::string originalName;
    std::string meshName;
    bool        validVariable;
    bool        hideFromGUI;

private:
    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AVTBASEVARMETADATA_TMFS "sssbb"

#endif
