/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK+ 1.2, Imlib, GtkImreg                                      *
 * Modul:     ginsert.c                                                      *
 *            Callback function to insert operating image into activ image   *
 * Author:    Andreas Tille                                                  *
 * Date:      27.11.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <ctype.h>
#include <unistd.h>
#include <sys/param.h>
#include <gdk/gdkkeysyms.h>
#include <gtkimreg.h>
#include "paul.h"
#include "callback.h"
#include "names.h"

/**********************************************************************************
 * Global variables                                                               *
 **********************************************************************************/

const char INVALID_FLAG[] = ">>Internal<<: Invalid information about what filename to set.";

static void InsertCallbackEnd(GtkWidget *widget, GtkImReg *imreg)
/* Needed to enable the operation image field
 * --- Parameter: ---
 * GtkWidget *widget : OK or Cancel-button inside GtkImReg widget
 *                     GList containing image to cut as user_data
 * GtkImReg *imreg   : GtkImReg widget, PAUL *p set as user_data
 */
{
  PAUL    *p;

  g_return_if_fail ( GTK_IS_IMREG(imreg) ) ;
  g_return_if_fail ( (p = gtk_object_get_user_data(GTK_OBJECT(imreg)) ) ) ;
  g_return_if_fail ( IS_PAUL(p) ) ;

  if ( p->opi && GTK_IS_WINDOW(p->opi) ) {
    GtkWidget *list = gtk_object_get_user_data(GTK_OBJECT(p->opi));
    if ( GTK_IS_LIST(list) ) gtk_widget_set_sensitive(list, TRUE);
  }
}


static void HtmlToggle(GtkWidget *checkbutton, GtkWidget *vbox)
{
  PAUL *p;
  
  g_return_if_fail ( vbox );
  g_return_if_fail ( GTK_IS_VBOX(vbox) );
  g_return_if_fail ( (p = gtk_object_get_user_data(GTK_OBJECT(vbox))) );
  g_return_if_fail ( IS_PAUL(p) );
  
  gtk_widget_set_sensitive(vbox, GTK_TOGGLE_BUTTON(checkbutton)->active);
  if ( GTK_TOGGLE_BUTTON(checkbutton)->active ) p->opt->f |= HTMLOUTPUT;
  else                                          p->opt->f &= ~HTMLOUTPUT;
}

static void GetFilenameWidget(GtkWidget *frame, PAUL *p, char *ptr)
/* Input filename or browse
 * --- Parameter: ---
 * GtkWidget *frame : frame to put the line in
 * PAUL      *p     : PAUL structure used as argument for the callbacks
 * char      *ptr   : pointer to check, whether HTML file or link should be edited
 */
{
  char      *desc;
  GtkWidget *hbox;
   
  if      ( ptr == p->opt->html ) desc = _("HTML file:");
  else if ( ptr == p->opt->link ) desc = _("Link to URL:");
  else {
    g_warning(INVALID_FLAG);
    return;
  }
  hbox = FileEntryOrBrowse(desc, ptr);
  gtk_box_pack_start(GTK_BOX(frame), hbox, TRUE, TRUE, 0);
}

static void InsertCallbackOK(GtkWidget *widget, GtkImReg *imreg)
/*
 * --- Parameter: ---
 * GtkWidget        *widget : OK-button inside GtkFileSelection widget
 *                            GList containing image to cut as user_data
 * GtkFileSelection *fs     : fileselection widget, PAUL *p set as user_data
 */
{
  PAUL      *p;
  PICTURE   *bild;
  GList     *pl;

  g_return_if_fail ( GTK_IS_IMREG(imreg) ) ;
  g_return_if_fail ( (p = gtk_object_get_user_data(GTK_OBJECT(imreg)) ) ) ;
  g_return_if_fail ( IS_PAUL(p) ) ;
  g_return_if_fail ( GTK_IS_BUTTON(widget) ) ;
  g_return_if_fail ( (pl = gtk_object_get_user_data(GTK_OBJECT(widget)) ) ) ;
  g_return_if_fail ( (bild = BILD(pl)) );
  g_return_if_fail ( bild->im == imreg->im ) ;

  p->opt->xi = gtk_imreg_get_left(imreg);
  p->opt->yi = gtk_imreg_get_top(imreg);
  gtk_widget_destroy(GTK_WIDGET(imreg));

  g_return_if_fail ( !InsertSingleImage(bild, p) );

  RefreshImage(GTK_CLIST(p->filelist), pl);
  p->activ = pl;
  SelectAndUpdateInfo(p);

  if ( !HtmlOutput(p->opt->f) ) {
    FREE(p->opt->html);
    FREE(p->opt->link);
  }
}

void ThisInsertCallback(PAUL *p)
{
  static     GtkWidget *window = NULL;
  PICTURE   *bild;
  gchar     *buf;
  GtkWidget *html, *check, *hbox, *vbox;
   
  g_return_if_fail ( IS_PAUL(p) ) ;
  if ( !(p->piclist) ) return ;
  g_return_if_fail ( CheckPicList(p->piclist) ) ;
  if ( !CheckOperating(p) ) return;

  g_return_if_fail ( (bild = BILD(p->activ)) );
  if ( window ) {
    gtk_widget_destroy(window);
    window = NULL;
    return;
  }

  html = gtk_frame_new(_("HTML Output"));
  gtk_container_set_border_width(GTK_CONTAINER (html), 4);
  gtk_frame_set_shadow_type(GTK_FRAME (html), GTK_SHADOW_ETCHED_IN);
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(html), hbox);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_object_set_user_data(GTK_OBJECT(vbox), p);

  check = gtk_check_button_new();
  gtk_box_pack_start(GTK_BOX(hbox), check, FALSE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(HtmlToggle), vbox);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), FALSE);

  gtk_widget_set_sensitive(vbox, FALSE);
  p->opt->f &= ~HTMLOUTPUT;
  gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, TRUE, 0);

  p->opt->html = g_malloc0(MAXPATHLEN);
  sprintf(p->opt->html, "%s.html", BILD(p->activ)->file);
  GetFilenameWidget(vbox, p, p->opt->html);

  p->opt->link = g_malloc0(MAXPATHLEN);
  sprintf(p->opt->link, "%s.html", (p->op)->file);
  GetFilenameWidget(vbox, p, p->opt->link);

  gtk_widget_show_all(html);

  buf = g_strdup_printf(_("Insert %s in %s"), p->op->file, bild->file);
  window = gtk_imreg_new(buf, BILD(p->activ)->im, p->op->W, p->op->H, html);
  FREE(buf);
  if ( !window ) {
    gtk_widget_destroy(html);
    return;
  }
  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);
  gtk_object_set_user_data(GTK_OBJECT(window), p);

  gtk_signal_connect(GTK_OBJECT(GTK_IMREG(window)->ok_button), "clicked", 
                     GTK_SIGNAL_FUNC(InsertCallbackOK), window);
  gtk_object_set_user_data(GTK_OBJECT(GTK_IMREG(window)->ok_button), p->activ);
  gtk_signal_connect_object(GTK_OBJECT(GTK_IMREG(window)->cancel_button), "clicked", 
                            GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(InsertCallbackEnd), window);
  
  if ( p->opi && GTK_IS_WINDOW(p->opi) ) {
    check = gtk_object_get_user_data(GTK_OBJECT(p->opi));
    if ( GTK_IS_LIST(check) ) gtk_widget_set_sensitive(check, FALSE);
  }
  gtk_widget_show(window);
}

