/* $Id: petscsles.h,v 1.37 2001/03/22 20:30:52 bsmith Exp $ */
/*
   Defines PETSc interface to the linear solvers. The details of Krylov methods
  and preconditioners are handled in the petscksp.h and petscpc.h files
*/
#if !defined(__PETSCSLES_H)
#define __PETSCSLES_H
#include "petscpc.h"
#include "petscksp.h"

/* Logging support */
extern int SLES_COOKIE;
extern int SLES_SetUp, SLES_Solve;

/*S
     SLES - Abstract PETSc object that manages all linear solvers. Essentially contains a 
         PC, preconditioner and a KSP, Krylov solver.

   Level: beginner

  Concepts: linear solvers

.seealso:  SLESCreate(), SLESGetKSP(), SLESGetPC(), TS, SNES, KSP, PC
S*/
typedef struct _p_SLES* SLES;

EXTERN int SLESInitializePackage(char *);

EXTERN int SLESCreate(MPI_Comm,SLES*);
EXTERN int SLESDestroy(SLES);

EXTERN int SLESGetPC(SLES,PC*);
EXTERN int SLESGetKSP(SLES,KSP*);
EXTERN int SLESSetOperators(SLES,Mat,Mat,MatStructure);
EXTERN int SLESSolve(SLES,Vec,Vec,int*);
EXTERN int SLESSolveTranspose(SLES,Vec,Vec,int*);
EXTERN int SLESSetFromOptions(SLES);
EXTERN int SLESSetTypesFromOptions(SLES);
EXTERN int SLESView(SLES,PetscViewer);
EXTERN int SLESSetUp(SLES,Vec,Vec);
EXTERN int SLESSetUpOnBlocks(SLES);
EXTERN int SLESSetDiagonalScale(SLES,PetscTruth);
EXTERN int SLESGetDiagonalScale(SLES,PetscTruth*);
EXTERN int SLESSetDiagonalScaleFix(SLES);

EXTERN int SLESSetOptionsPrefix(SLES,char*);
EXTERN int SLESAppendOptionsPrefix(SLES,char*);
EXTERN int SLESGetOptionsPrefix(SLES,char**);

EXTERN int PCBJacobiGetSubSLES(PC,int*,int*,SLES**);
EXTERN int PCASMGetSubSLES(PC,int*,int*,SLES**);
EXTERN int PCSLESGetSLES(PC,SLES *);

#endif
