/* meshQuery.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscfix.h"
#include "mesh.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetdimension_ PMESHSETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetdimension_ pmeshsetdimension
#else
#define meshsetdimension_ pmeshsetdimension_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetdimension_ MESHSETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetdimension_ meshsetdimension
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetdimension_ PMESHGETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetdimension_ pmeshgetdimension
#else
#define meshgetdimension_ pmeshgetdimension_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetdimension_ MESHGETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetdimension_ meshgetdimension
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetinfo_ PMESHGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetinfo_ pmeshgetinfo
#else
#define meshgetinfo_ pmeshgetinfo_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetinfo_ MESHGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetinfo_ meshgetinfo
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetnumcorners_ PMESHSETNUMCORNERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetnumcorners_ pmeshsetnumcorners
#else
#define meshsetnumcorners_ pmeshsetnumcorners_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetnumcorners_ MESHSETNUMCORNERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetnumcorners_ meshsetnumcorners
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnumcorners_ PMESHGETNUMCORNERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnumcorners_ pmeshgetnumcorners
#else
#define meshgetnumcorners_ pmeshgetnumcorners_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnumcorners_ MESHGETNUMCORNERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnumcorners_ meshgetnumcorners
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetboundingbox_ PMESHSETBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetboundingbox_ pmeshsetboundingbox
#else
#define meshsetboundingbox_ pmeshsetboundingbox_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetboundingbox_ MESHSETBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetboundingbox_ meshsetboundingbox
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetboundingbox_ PMESHGETBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetboundingbox_ pmeshgetboundingbox
#else
#define meshgetboundingbox_ pmeshgetboundingbox_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetboundingbox_ MESHGETBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetboundingbox_ meshgetboundingbox
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetlocalboundingbox_ PMESHSETLOCALBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetlocalboundingbox_ pmeshsetlocalboundingbox
#else
#define meshsetlocalboundingbox_ pmeshsetlocalboundingbox_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetlocalboundingbox_ MESHSETLOCALBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetlocalboundingbox_ meshsetlocalboundingbox
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetlocalboundingbox_ PMESHGETLOCALBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetlocalboundingbox_ pmeshgetlocalboundingbox
#else
#define meshgetlocalboundingbox_ pmeshgetlocalboundingbox_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetlocalboundingbox_ MESHGETLOCALBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetlocalboundingbox_ meshgetlocalboundingbox
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshupdateboundingbox_ PMESHUPDATEBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshupdateboundingbox_ pmeshupdateboundingbox
#else
#define meshupdateboundingbox_ pmeshupdateboundingbox_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshupdateboundingbox_ MESHUPDATEBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshupdateboundingbox_ meshupdateboundingbox
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetpartition_ PMESHGETPARTITION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetpartition_ pmeshgetpartition
#else
#define meshgetpartition_ pmeshgetpartition_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetpartition_ MESHGETPARTITION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetpartition_ meshgetpartition
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetmovement_ PMESHSETMOVEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetmovement_ pmeshsetmovement
#else
#define meshsetmovement_ pmeshsetmovement_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetmovement_ MESHSETMOVEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetmovement_ meshsetmovement
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetmovement_ PMESHGETMOVEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetmovement_ pmeshgetmovement
#else
#define meshgetmovement_ pmeshgetmovement_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetmovement_ MESHGETMOVEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetmovement_ meshgetmovement
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetmaxdegree_ PMESHGETMAXDEGREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetmaxdegree_ pmeshgetmaxdegree
#else
#define meshgetmaxdegree_ pmeshgetmaxdegree_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetmaxdegree_ MESHGETMAXDEGREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetmaxdegree_ meshgetmaxdegree
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnumboundaries_ PMESHGETNUMBOUNDARIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnumboundaries_ pmeshgetnumboundaries
#else
#define meshgetnumboundaries_ pmeshgetnumboundaries_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnumboundaries_ MESHGETNUMBOUNDARIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnumboundaries_ meshgetnumboundaries
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetboundarysize_ PMESHGETBOUNDARYSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetboundarysize_ pmeshgetboundarysize
#else
#define meshgetboundarysize_ pmeshgetboundarysize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetboundarysize_ MESHGETBOUNDARYSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetboundarysize_ meshgetboundarysize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetboundaryindex_ PMESHGETBOUNDARYINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetboundaryindex_ pmeshgetboundaryindex
#else
#define meshgetboundaryindex_ pmeshgetboundaryindex_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetboundaryindex_ MESHGETBOUNDARYINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetboundaryindex_ meshgetboundaryindex
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetboundarystart_ PMESHGETBOUNDARYSTART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetboundarystart_ pmeshgetboundarystart
#else
#define meshgetboundarystart_ pmeshgetboundarystart_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetboundarystart_ MESHGETBOUNDARYSTART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetboundarystart_ meshgetboundarystart
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetboundarynext_ PMESHGETBOUNDARYNEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetboundarynext_ pmeshgetboundarynext
#else
#define meshgetboundarynext_ pmeshgetboundarynext_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetboundarynext_ MESHGETBOUNDARYNEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetboundarynext_ meshgetboundarynext
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetactiveboundary_ PMESHGETACTIVEBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetactiveboundary_ pmeshgetactiveboundary
#else
#define meshgetactiveboundary_ pmeshgetactiveboundary_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetactiveboundary_ MESHGETACTIVEBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetactiveboundary_ meshgetactiveboundary
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodeboundary_ PMESHGETNODEBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodeboundary_ pmeshgetnodeboundary
#else
#define meshgetnodeboundary_ pmeshgetnodeboundary_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodeboundary_ MESHGETNODEBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodeboundary_ meshgetnodeboundary
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshnodeisvertex_ PMESHNODEISVERTEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshnodeisvertex_ pmeshnodeisvertex
#else
#define meshnodeisvertex_ pmeshnodeisvertex_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshnodeisvertex_ MESHNODEISVERTEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshnodeisvertex_ meshnodeisvertex
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodecoords_ PMESHGETNODECOORDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodecoords_ pmeshgetnodecoords
#else
#define meshgetnodecoords_ pmeshgetnodecoords_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodecoords_ MESHGETNODECOORDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodecoords_ meshgetnodecoords
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetnodecoords_ PMESHSETNODECOORDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetnodecoords_ pmeshsetnodecoords
#else
#define meshsetnodecoords_ pmeshsetnodecoords_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetnodecoords_ MESHSETNODECOORDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetnodecoords_ meshsetnodecoords
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodecoordssaved_ PMESHGETNODECOORDSSAVED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodecoordssaved_ pmeshgetnodecoordssaved
#else
#define meshgetnodecoordssaved_ pmeshgetnodecoordssaved_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodecoordssaved_ MESHGETNODECOORDSSAVED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodecoordssaved_ meshgetnodecoordssaved
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnearestnode_ PMESHGETNEARESTNODE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnearestnode_ pmeshgetnearestnode
#else
#define meshgetnearestnode_ pmeshgetnearestnode_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnearestnode_ MESHGETNEARESTNODE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnearestnode_ meshgetnearestnode
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnearestbdnode_ PMESHGETNEARESTBDNODE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnearestbdnode_ pmeshgetnearestbdnode
#else
#define meshgetnearestbdnode_ pmeshgetnearestbdnode_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnearestbdnode_ MESHGETNEARESTBDNODE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnearestbdnode_ meshgetnearestbdnode
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodesupport_ PMESHGETNODESUPPORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodesupport_ pmeshgetnodesupport
#else
#define meshgetnodesupport_ pmeshgetnodesupport_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodesupport_ MESHGETNODESUPPORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodesupport_ meshgetnodesupport
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshrestorenodesupport_ PMESHRESTORENODESUPPORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshrestorenodesupport_ pmeshrestorenodesupport
#else
#define meshrestorenodesupport_ pmeshrestorenodesupport_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshrestorenodesupport_ MESHRESTORENODESUPPORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshrestorenodesupport_ meshrestorenodesupport
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodeordering_ PMESHGETNODEORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodeordering_ pmeshgetnodeordering
#else
#define meshgetnodeordering_ pmeshgetnodeordering_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodeordering_ MESHGETNODEORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodeordering_ meshgetnodeordering
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetelementneighbor_ PMESHGETELEMENTNEIGHBOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetelementneighbor_ pmeshgetelementneighbor
#else
#define meshgetelementneighbor_ pmeshgetelementneighbor_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetelementneighbor_ MESHGETELEMENTNEIGHBOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetelementneighbor_ meshgetelementneighbor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshlocatepoint_ PMESHLOCATEPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshlocatepoint_ pmeshlocatepoint
#else
#define meshlocatepoint_ pmeshlocatepoint_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshlocatepoint_ MESHLOCATEPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshlocatepoint_ meshlocatepoint
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetholecoords_ PMESHSETHOLECOORDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetholecoords_ pmeshsetholecoords
#else
#define meshsetholecoords_ pmeshsetholecoords_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetholecoords_ MESHSETHOLECOORDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetholecoords_ meshsetholecoords
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetelementfromnode_ PMESHGETELEMENTFROMNODE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetelementfromnode_ pmeshgetelementfromnode
#else
#define meshgetelementfromnode_ pmeshgetelementfromnode_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetelementfromnode_ MESHGETELEMENTFROMNODE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetelementfromnode_ meshgetelementfromnode
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetbdelementfromedge_ PMESHGETBDELEMENTFROMEDGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetbdelementfromedge_ pmeshgetbdelementfromedge
#else
#define meshgetbdelementfromedge_ pmeshgetbdelementfromedge_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetbdelementfromedge_ MESHGETBDELEMENTFROMEDGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetbdelementfromedge_ meshgetbdelementfromedge
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodefromelement_ PMESHGETNODEFROMELEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodefromelement_ pmeshgetnodefromelement
#else
#define meshgetnodefromelement_ pmeshgetnodefromelement_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodefromelement_ MESHGETNODEFROMELEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodefromelement_ meshgetnodefromelement
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodefromedge_ PMESHGETNODEFROMEDGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodefromedge_ pmeshgetnodefromedge
#else
#define meshgetnodefromedge_ pmeshgetnodefromedge_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetnodefromedge_ MESHGETNODEFROMEDGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetnodefromedge_ meshgetnodefromedge
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetmidnodefromedge_ PMESHGETMIDNODEFROMEDGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetmidnodefromedge_ pmeshgetmidnodefromedge
#else
#define meshgetmidnodefromedge_ pmeshgetmidnodefromedge_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetmidnodefromedge_ MESHGETMIDNODEFROMEDGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetmidnodefromedge_ meshgetmidnodefromedge
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL meshsetdimension_(Mesh mesh,int *dim, int *ierr ){
*ierr = MeshSetDimension(
	(Mesh)PetscToPointer( (mesh) ),*dim);
}
void PETSC_STDCALL meshgetdimension_(Mesh mesh,int *dim, int *ierr ){
*ierr = MeshGetDimension(
	(Mesh)PetscToPointer( (mesh) ),dim);
}
void PETSC_STDCALL meshgetinfo_(Mesh mesh,int *vertices,int *nodes,int *edges,int *elements, int *ierr ){
*ierr = MeshGetInfo(
	(Mesh)PetscToPointer( (mesh) ),vertices,nodes,edges,elements);
}
void PETSC_STDCALL meshsetnumcorners_(Mesh mesh,int *numCorners, int *ierr ){
*ierr = MeshSetNumCorners(
	(Mesh)PetscToPointer( (mesh) ),*numCorners);
}
void PETSC_STDCALL meshgetnumcorners_(Mesh mesh,int *numCorners, int *ierr ){
*ierr = MeshGetNumCorners(
	(Mesh)PetscToPointer( (mesh) ),numCorners);
}
void PETSC_STDCALL meshsetboundingbox_(Mesh mesh,PetscReal *startX,PetscReal *startY,PetscReal *startZ,PetscReal *endX,PetscReal *endY,PetscReal *endZ, int *ierr ){
*ierr = MeshSetBoundingBox(
	(Mesh)PetscToPointer( (mesh) ),*startX,*startY,*startZ,*endX,*endY,*endZ);
}
void PETSC_STDCALL meshgetboundingbox_(Mesh mesh,PetscReal *startX,PetscReal *startY,PetscReal *startZ,PetscReal *endX,PetscReal *endY,PetscReal *endZ, int *ierr ){
*ierr = MeshGetBoundingBox(
	(Mesh)PetscToPointer( (mesh) ),startX,startY,startZ,endX,endY,endZ);
}
void PETSC_STDCALL meshsetlocalboundingbox_(Mesh mesh,PetscReal *startX,PetscReal *startY,PetscReal *startZ,PetscReal *endX,PetscReal *endY,PetscReal *endZ, int *ierr ){
*ierr = MeshSetLocalBoundingBox(
	(Mesh)PetscToPointer( (mesh) ),*startX,*startY,*startZ,*endX,*endY,*endZ);
}
void PETSC_STDCALL meshgetlocalboundingbox_(Mesh mesh,PetscReal *startX,PetscReal *startY,PetscReal *startZ,PetscReal *endX,PetscReal *endY,PetscReal *endZ, int *ierr ){
*ierr = MeshGetLocalBoundingBox(
	(Mesh)PetscToPointer( (mesh) ),startX,startY,startZ,endX,endY,endZ);
}
void PETSC_STDCALL meshupdateboundingbox_(Mesh mesh, int *ierr ){
*ierr = MeshUpdateBoundingBox(
	(Mesh)PetscToPointer( (mesh) ));
}
void PETSC_STDCALL meshgetpartition_(Mesh mesh,Partition *part, int *ierr ){
*ierr = MeshGetPartition(
	(Mesh)PetscToPointer( (mesh) ),part);
}
void PETSC_STDCALL meshsetmovement_(Mesh mesh,PetscTruth *isMoving, int *ierr ){
*ierr = MeshSetMovement(
	(Mesh)PetscToPointer( (mesh) ),*isMoving);
}
void PETSC_STDCALL meshgetmovement_(Mesh mesh,PetscTruth *isMoving, int *ierr ){
*ierr = MeshGetMovement(
	(Mesh)PetscToPointer( (mesh) ),isMoving);
}
void PETSC_STDCALL meshgetmaxdegree_(Mesh mesh,int *maxDegree, int *ierr ){
*ierr = MeshGetMaxDegree(
	(Mesh)PetscToPointer( (mesh) ),maxDegree);
}
void PETSC_STDCALL meshgetnumboundaries_(Mesh mesh,int *numBd, int *ierr ){
*ierr = MeshGetNumBoundaries(
	(Mesh)PetscToPointer( (mesh) ),numBd);
}
void PETSC_STDCALL meshgetboundarysize_(Mesh mesh,int *boundary,int *size, int *ierr ){
*ierr = MeshGetBoundarySize(
	(Mesh)PetscToPointer( (mesh) ),*boundary,size);
}
void PETSC_STDCALL meshgetboundaryindex_(Mesh mesh,int *boundary,int *index, int *ierr ){
*ierr = MeshGetBoundaryIndex(
	(Mesh)PetscToPointer( (mesh) ),*boundary,index);
}
void PETSC_STDCALL meshgetboundarystart_(Mesh mesh,int *boundary,PetscTruth *ghost,int *node, int *ierr ){
*ierr = MeshGetBoundaryStart(
	(Mesh)PetscToPointer( (mesh) ),*boundary,*ghost,node);
}
void PETSC_STDCALL meshgetboundarynext_(Mesh mesh,int *boundary,PetscTruth *ghost,int *node, int *ierr ){
*ierr = MeshGetBoundaryNext(
	(Mesh)PetscToPointer( (mesh) ),*boundary,*ghost,node);
}
void PETSC_STDCALL meshgetactiveboundary_(Mesh mesh,int *boundary, int *ierr ){
*ierr = MeshGetActiveBoundary(
	(Mesh)PetscToPointer( (mesh) ),boundary);
}
void PETSC_STDCALL meshgetnodeboundary_(Mesh mesh,int *node,int *bd, int *ierr ){
*ierr = MeshGetNodeBoundary(
	(Mesh)PetscToPointer( (mesh) ),*node,bd);
}
void PETSC_STDCALL meshnodeisvertex_(Mesh mesh,int *node,PetscTruth *isVertex, int *ierr ){
*ierr = MeshNodeIsVertex(
	(Mesh)PetscToPointer( (mesh) ),*node,isVertex);
}
void PETSC_STDCALL meshgetnodecoords_(Mesh mesh,int *node,double *x,double *y,double *z, int *ierr ){
*ierr = MeshGetNodeCoords(
	(Mesh)PetscToPointer( (mesh) ),*node,x,y,z);
}
void PETSC_STDCALL meshsetnodecoords_(Mesh mesh,int *node,double *x,double *y,double *z, int *ierr ){
*ierr = MeshSetNodeCoords(
	(Mesh)PetscToPointer( (mesh) ),*node,*x,*y,*z);
}
void PETSC_STDCALL meshgetnodecoordssaved_(Mesh mesh,int *node,double *x,double *y,double *z, int *ierr ){
*ierr = MeshGetNodeCoordsSaved(
	(Mesh)PetscToPointer( (mesh) ),*node,x,y,z);
}
void PETSC_STDCALL meshgetnearestnode_(Mesh mesh,double *x,double *y,double *z,PetscTruth *outside,int *node, int *ierr ){
*ierr = MeshGetNearestNode(
	(Mesh)PetscToPointer( (mesh) ),*x,*y,*z,*outside,node);
}
void PETSC_STDCALL meshgetnearestbdnode_(Mesh mesh,double *x,double *y,double *z,int *node, int *ierr ){
*ierr = MeshGetNearestBdNode(
	(Mesh)PetscToPointer( (mesh) ),*x,*y,*z,node);
}
void PETSC_STDCALL meshgetnodesupport_(Mesh mesh,int *node,int *elem,int *degree,int **support, int *ierr ){
*ierr = MeshGetNodeSupport(
	(Mesh)PetscToPointer( (mesh) ),*node,*elem,degree,support);
}
void PETSC_STDCALL meshrestorenodesupport_(Mesh mesh,int *node,int *elem,int *degree,int **support, int *ierr ){
*ierr = MeshRestoreNodeSupport(
	(Mesh)PetscToPointer( (mesh) ),*node,*elem,degree,support);
}
void PETSC_STDCALL meshgetnodeordering_(Mesh mesh,AO *order, int *ierr ){
*ierr = MeshGetNodeOrdering(
	(Mesh)PetscToPointer( (mesh) ),order);
}
void PETSC_STDCALL meshgetelementneighbor_(Mesh mesh,int *elem,int *corner,int *neighbor, int *ierr ){
*ierr = MeshGetElementNeighbor(
	(Mesh)PetscToPointer( (mesh) ),*elem,*corner,neighbor);
}
void PETSC_STDCALL meshlocatepoint_(Mesh mesh,double *x,double *y,double *z,int *containingElem, int *ierr ){
*ierr = MeshLocatePoint(
	(Mesh)PetscToPointer( (mesh) ),*x,*y,*z,containingElem);
}
void PETSC_STDCALL meshsetholecoords_(Mesh mesh,int *num,Vec coords, int *ierr ){
*ierr = MeshSetHoleCoords(
	(Mesh)PetscToPointer( (mesh) ),*num,
	(Vec)PetscToPointer( (coords) ));
}
void PETSC_STDCALL meshgetelementfromnode_(Mesh mesh,int *node,int *elem, int *ierr ){
*ierr = MeshGetElementFromNode(
	(Mesh)PetscToPointer( (mesh) ),*node,elem);
}
void PETSC_STDCALL meshgetbdelementfromedge_(Mesh mesh,int *edge,int *elem, int *ierr ){
*ierr = MeshGetBdElementFromEdge(
	(Mesh)PetscToPointer( (mesh) ),*edge,elem);
}
void PETSC_STDCALL meshgetnodefromelement_(Mesh mesh,int *elem,int *corner,int *node, int *ierr ){
*ierr = MeshGetNodeFromElement(
	(Mesh)PetscToPointer( (mesh) ),*elem,*corner,node);
}
void PETSC_STDCALL meshgetnodefromedge_(Mesh mesh,int *edge,int *corner,int *node, int *ierr ){
*ierr = MeshGetNodeFromEdge(
	(Mesh)PetscToPointer( (mesh) ),*edge,*corner,node);
}
void PETSC_STDCALL meshgetmidnodefromedge_(Mesh mesh,int *edge,int *midnode, int *ierr ){
*ierr = MeshGetMidnodeFromEdge(
	(Mesh)PetscToPointer( (mesh) ),*edge,midnode);
}
#if defined(__cplusplus)
}
#endif
