/* $Id: gridBC.h,v 1.1 1999/12/30 18:49:00 knepley Exp $ */

/*
    Routines for working with boundary conditions
*/

extern int GridDuplicateBC(Grid, Grid);
extern int GridFinalizeBC(Grid grid);

extern int GridSetBC(Grid, int, int, PointFunction, PetscTruth);
extern int GridAddBC(Grid, int, int, PointFunction, PetscTruth);
extern int GridSetPointBC(Grid, double, double, double, int, PointFunction, PetscTruth);
extern int GridAddPointBC(Grid, double, double, double, int, PointFunction, PetscTruth);
extern int GridSetBCMultiplier(Grid, PetscScalar);
extern int GridGetBCMultiplier(Grid, PetscScalar *);
extern int GridSetBCContext(Grid, void *);
extern int GridGetBCContext(Grid, void **);
extern int GridSetBCValuesType(Grid, BCValuesType);

extern int GridCalcPointBCNodes(Grid);
extern int GridCalcBCValues(Grid, PetscTruth, void *);
extern int GridCalcBCValuesDifference(Grid);

extern int GridSetReduceSystem(Grid, PetscTruth);
extern int GridGetReduceSystem(Grid, PetscTruth *);
extern int GridSetReduceElement(Grid, PetscTruth);
extern int GridGetReduceElement(Grid, PetscTruth *);
