/* $Id: 1dimpl.h,v 1.3 1999/11/17 16:23:07 knepley Exp $ */
/* 
   This private file should not be included in users' code.
*/

#ifndef __1DIMPL_H
#define __1DIMPL_H
#include "src/mesh/impls/triangular/triimpl.h"
#include "src/mesh/impls/triangular/1d/tri1dView.h"

typedef struct  {
  /* Partitioning order */
  PetscTruth isNodePartitioned;    /*      The flag indicating that the nodes have been partitioned */
  /* Node partition structures */
  AO         nodeOrdering;         /*      The renumbering of the nodes */
  int        numLocNodes;          /*  N:  The number of local nodes */
  int        numNodes;             /*      The global number of nodes */
  int        numOverlapNodes;      /* N+G: The number of local nodes + ghost nodes */
  int       *firstNode;            /* [P]: The first node in each domain */
  int       *ghostNodes;           /* [G]: The global node number of each ghost node */
  int       *ghostNodeProcs;       /* [G]: The domain of each ghost node */
  /* Boundary node partition structures */
  int        numLocBdNodes;        /*      The number of local boundary nodes */
  int        numBdNodes;           /*      The global number of boundary nodes */
  int        numOverlapBdNodes;    /*      The number of local + ghost boundary nodes */
  int       *firstBdNode;          /*      The first boundary node in each domain */
  int       *ghostBdNodes;         /*      The index into ghostNodes of each ghost boundary node */
} Partition_Triangular_1D;

#endif /* __1DIMPL_H */
