//-----------------------------------------------------------------------------
//
//	PIC device definitions and initialization data
//
//
//	name field must be all upper case
//	array of initialization data does not include checksum -- checksum is pasted
//		onto the end by DoInitPIC()
//
//-----------------------------------------------------------------------------
//
//	Copyright (C) 1999 Cosmodog, Ltd.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//-----------------------------------------------------------------------------
//
//	TO DO:
//		need to add code protect and watchdog masks to definition structures
//			for most parts
//
//-----------------------------------------------------------------------------

#include "includes.h"

//-----------------------------------------------------------------------------
//
// PIC12C508/PIC12C508A/PIC12CE518
//

const static UINT8 def_PIC12C508[] =		// DEBUG don't know what all this means yet, but it is device-specific
{
	0x01, 0xff,								// size of program space
	0x0f, 0xff,								// width of address word
	0x0f, 0xff,								// width of data word
	0x00, 0x0f, 0x00, 0x0f,
	0x00, 0x1f, 0x00, 0x1f,
	0x00, 0x00, 0x00, 0x00,
	0x0f, 0xff, 0x0f, 0xff,
	0x00, 0x00, 0x00, 0x01,
	0x02, 0x00, 0x04,
	0x0f, 0xff,								// address of configuration bits
	0x01,
	0x00, 0x00,								// address of data space?
	0x00, 0x00,								// size of data space
	0x01, 0xff,								// address of internal clock calibration value
	0x00, 0x01,								// size of clock calibration space
	0x0b, 0x08, 0x0a, 0x16,
};

const static UINT8 defx_PIC12C508[] =
{
	0x00, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC12C508 =
{
	"12C508",
	def_PIC12C508,
	defx_PIC12C508,
	0x008,									// config word: code protect bit mask
	0x004,									// config word: watchdog bit mask
};

const static PIC_DEFINITION PIC12C508A =
{
	"12C508A",
	def_PIC12C508,
	defx_PIC12C508,
	0x008,									// config word: code protect bit mask
	0x004,									// config word: watchdog bit mask
};

const static PIC_DEFINITION PIC12CE518 =
{
	"12CE518",
	def_PIC12C508,
	defx_PIC12C508,
	0x008,									// config word: code protect bit mask
	0x004,									// config word: watchdog bit mask
};


//-----------------------------------------------------------------------------
//
// PIC12C509/PIC12C509A/PIC12CE519
//

const static UINT8 def_PIC12C509[] =
{
	0x03, 0xff,						// size of program space
	0x0f, 0xff,
	0x0f, 0xff,
	0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x1f,
	0x00, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x01, 0x04, 0x00,
	0x04,
	0x0f, 0xff,						// address of configuration bits
	0x01,
	0x00, 0x00,
	0x00, 0x00,						// size of data space
	0x03, 0xff,						// address of internal clock calibration value
	0x00, 0x01,						// size of clock calibration space
	0x0b, 0x08, 0x0a, 0x16,
};

const static PIC_DEFINITION PIC12C509 =
{
	"12C509",
	def_PIC12C509,
	defx_PIC12C508,
	0x008,									// config word: code protect bit mask
	0x004,									// config word: watchdog bit mask
};

const static PIC_DEFINITION PIC12C509A =
{
	"12C509A",
	def_PIC12C509,
	defx_PIC12C508,
	0x008,									// config word: code protect bit mask
	0x004,									// config word: watchdog bit mask
};

const static PIC_DEFINITION PIC12CE519 =
{
	"12CE519",
	def_PIC12C509,
	defx_PIC12C508,
	0x008,									// config word: code protect bit mask
	0x004,									// config word: watchdog bit mask
};


//-----------------------------------------------------------------------------
//
// PIC12C671/PIC12CE673
//

const static UINT8 def_PIC12C671[] =
{
	0x03, 0xff,						// size of program space
	0x3f, 0xff,
	0x3f, 0xff,
	0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04,
	0x20, 0x07,						// address of configuration bits
	0x01,
	0x00, 0x00,
	0x00, 0x00,						// size of data space
	0x03, 0xff,						// address of internal clock calibration value
	0x00, 0x01,						// size of clock calibration space
	0x03, 0x19, 0x09, 0x16,
};

const static UINT8 defx_PIC12C671[] =
{
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};


const static PIC_DEFINITION PIC12C671 =
{
	"12C671",
	def_PIC12C671,
	defx_PIC12C671,
	0,
	0,
};

const static PIC_DEFINITION PIC12CE673 =
{
	"12CE673",
	def_PIC12C671,
	defx_PIC12C671,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
// PIC12C672/PIC12CE674
//

const static UINT8 def_PIC12C672[] =
{
	0x07, 0xff,						// size of program space
	0x3f, 0xff,
	0x3f, 0xff,

	0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04,
	0x20, 0x07,						// address of configuration bits
	0x01,
	0x00, 0x00,
	0x00, 0x00,						// size of data space
	0x07, 0xff,						// address of internal clock calibration value
	0x00, 0x01,						// size of clock calibration space
	0x03, 0x19, 0x09, 0x16,
};

const static PIC_DEFINITION PIC12C672 =
{
	"12C672",
	def_PIC12C672,
	defx_PIC12C671,
	0,
	0,
};

const static PIC_DEFINITION PIC12CE674 =
{
	"12CE674",
	def_PIC12C672,
	defx_PIC12C671,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
// PIC14000
//
// config bits:
//	b7:		calibration space code protection (1 = not protected, 0 = protected)
//	b5-4:	program space code protection (1 = not protected, 0 = protected)
//	b3:		power-up timer enable (1 = disabled)
//	b2:		watchdog enable (1 = enabled)
//	b0:		oscillator selection (1 = internal oscillator, 0 = HS oscillator)

const static UINT8 def_PIC14000[] =
{
	0x0f, 0xc0,		// size of program memory (in words)

	0x3f, 0xff,
	0x3f, 0xff,

	0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0xbd, 0x3f, 0xbd, 0x00, 0x00,
	0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00, 0x04,

	0x20, 0x07,							// address of configuration bits

	0x01,
	0x00, 0x00,
	0x00, 0x00,							// size of data space
	0x0f, 0xc0,							// address of calibration space
	0x00, 0x40,							// size of clock calibration space
	0x03, 0x19, 0x01, 0x16,
};


const static UINT8 defx_PIC14000[] =
{
	0x3f, 0xbd, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x3f, 0xbd, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};


const static PIC_DEFINITION PIC14000 =
{
	"14000",
	def_PIC14000,
	defx_PIC14000,
	0,
	0,
};



//-----------------------------------------------------------------------------
//
// PIC16C505
//
// config bits:
//	b13-3:	code protection (1 = not protected, zeroes = protected)
//	b2:		watchdog enable (1 = enabled)
//	b2-0:	FOSC1-0 (111 = ext. RC oscillator, 10 = HS oscillator, 01 = XT oscillator, 00 = LP oscillator)

const static UINT8 def_PIC16C505[] =
{
	0x03, 0xff,		// size of program memory
	0x0f, 0xff,
	0x0f, 0xff,
	
	0x00, 0x0f,	0x00, 0x0f,
	0x0f, 0xff,	0x0f, 0xff,	0x00, 0x00,	0x00, 0x00,
	0x0f, 0xff,	0x0f, 0xff,	0x00, 0x00,	0x00, 0x01,
	0x04, 0x00,	0x04,
	0x0f, 0xff,		// address of configuration bits
	0x01,
	0x00, 0x00,
	0x00, 0x00,		// size of data space (none)
	0x03, 0xff,		// address of internal clock calibration value
	0x00, 0x01,		// size of clock calibration space
	0x0b, 0x08, 0x0a, 0x16,
};


const static UINT8 defx_PIC16C505[] =
{
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};


const static PIC_DEFINITION PIC16C505 =
{
	"16C505",
	def_PIC16C505,
	defx_PIC16C505,
	0x0fd0,						// set of code protection bits
	0x0008,						// watchdog enable (1 = enabled)
};


//-----------------------------------------------------------------------------
//
// PIC16C52
// (osc RC, code protect off)
//

const static UINT8 def_PIC16C52[] =
{
	0x01, 0x80,				// size of program memory
	0x0f, 0xff,
	0x0f, 0xff,
	
	0x00, 0x0f,
	0x00, 0x0f,
	0x00, 0x0b,
	0x00, 0x0b,
	0x00, 0x00,
	0x00, 0x00,
	0x00, 0x00,
	0x00, 0x00,
	0x00, 0x00,
	0x00, 0x01,
	0x02, 0x00,
	0x00,
	0x0f, 0xff,				// address of configuration bits
	0x01,
	0x00, 0x00,
	0x00, 0x00,				// size of data space (none)
	0x00, 0x00,				// address of internal clock calibration value
	0x00, 0x00,				// size of clock calibration space
	0x0b, 0x08,0x05, 0x04,
};


const static UINT8 defx_PIC16C52[] =
{
	0x00, 0x0b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x0b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};


const static PIC_DEFINITION PIC16C52 =
{
	"16C52",
	def_PIC16C52,
	defx_PIC16C52,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
// PIC16C54/PIC16C54A
// (osc RC, wd on, code protect off)
//

const static UINT8 def_PIC16C54[] =
{
	0x02, 0x00,
	0x0f, 0xff,
	0x0f, 0xff,
	
	0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x02, 0x00,
	0x04, 0x0f, 0xff, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0b, 0x08, 0x05, 0x06,
};


const static UINT8 defx_PIC16C54[] =
{
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};


const static PIC_DEFINITION PIC16C54 =
{
	"16C54",
	def_PIC16C54,
	defx_PIC16C54,
	0,
	0,
};

const static PIC_DEFINITION PIC16C54A =
{
	"16C54A",
	def_PIC16C54,
	defx_PIC16C54,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C54B/PIC16C54C:
//

const static UINT8 def_PIC16C54B[] =
{
	0x02, 0x00,					// size of program space
	0x0f, 0xff,
	0x0f, 0xff,
	
	0x00, 0x0f,	0x00, 0x0f,
	0x0f, 0xff,	0x0f, 0xff,
	0x00, 0x00,	0x00, 0x00,
	0x00, 0x00,	0x00, 0x00,
	0x00, 0x00,	0x00, 0x01,
	0x02, 0x00,	0x04,
	0x0f, 0xff,					// address of configuration bits
	0x01,
	0x00, 0x00,
	0x00, 0x00,					// size of data space (none)
	0x00, 0x00,					// address of internal clock calibration value
	0x00, 0x00,					// size of clock calibration space
	0x0b, 0x08, 0x05, 0x06,
};

const static UINT8 defx_PIC16C54B[] =
{
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};


const static PIC_DEFINITION PIC16C54B =
{
	"16C54B",
	def_PIC16C54B,
	defx_PIC16C54B,
	0,
	0,
};

const static PIC_DEFINITION PIC16C54C =
{
	"16C54C",
	def_PIC16C54B,
	defx_PIC16C54B,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16HV540:
//

const static UINT8 def_PIC16HV540[] =
{
	0x02, 0x00,
	0x0f, 0xff,
	0x0f, 0xff,
	
	0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x02, 0x00,
	0x04, 0x0f, 0xff, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0b, 0x08, 0x05, 0x06,
};

const static UINT8 defx_PIC16HV540[] =
{
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};


const static PIC_DEFINITION PIC16HV540 =
{
	"16HV540",
	def_PIC16HV540,
	defx_PIC16HV540,
	0,
	0,
};



//-----------------------------------------------------------------------------
//
//  PIC16C55:
//

const static UINT8 def_PIC16C55[] =
{
	0x02, 0x00,
	0x0f, 0xff,
	0x0f, 0xff,
	0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x02, 0x00,
	0x04, 0x0f, 0xff, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0b, 0x08, 0x06, 0x06,
};

const static UINT8 defx_PIC16C55[] =
{
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};


const static PIC_DEFINITION PIC16C55 =
{
	"16C55",
	def_PIC16C55,
	defx_PIC16C55,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C55A:
//

const static UINT8 def_PIC16C55A[] =
{
	0x02, 0x00, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x0f,
	0x00, 0x0f, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x02, 0x00,
	0x04, 0x0f, 0xff, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0b, 0x08, 0x06, 0x06,

};

const static UINT8 defx_PIC16C55A[] =
{
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};


const static PIC_DEFINITION PIC16C55A =
{
	"16C55A",
	def_PIC16C55A,
	defx_PIC16C55A,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C554/PIC16C554A:
//

const static UINT8 def_PIC16C554[] =
{
	0x02, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x3f,
	0x3f, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,			// no clock calibration space
	0x03, 0x19, 0x02, 0x06,
};

const static UINT8 defx_PIC16C554[] =
{
	0x3f, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x3f, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};


const static PIC_DEFINITION PIC16C554 =
{
	"16C554",
	def_PIC16C554,
	defx_PIC16C554,
	0,
	0,
};

/* deleted from MPLAB
const static PIC_DEFINITION PIC16C554A =
{
	"16C554A",
	def_PIC16C554,
	defx_PIC16C554,
	0,
	0,
};
*/

//-----------------------------------------------------------------------------
//
//  PIC16C556/PIC16C556A:
//
/* deleted from MPLAB

const static UINT8 def_PIC16C556[] =
{
	0x04, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x3f,
	0x3f, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x02, 0x06,
};

const static PIC_DEFINITION PIC16C556 =
{
	"16C556",
	def_PIC16C556,
	sizeof(def_PIC16C556),
	0,
	0,
};

const static PIC_DEFINITION PIC16C556A =
{
	"16C556A",
	def_PIC16C556,
	sizeof(def_PIC16C556),
	0,
	0,
};

*/

//-----------------------------------------------------------------------------
//
//  PIC16C558/PIC16C558A:
//

const static UINT8 def_PIC16C558[] =
{
	0x08, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x3f,
	0x3f, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x02, 0x06,
};

const static UINT8 defx_PIC16C558[] =
{
	0x3f, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x3f, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C558 =
{
	"16C558",
	def_PIC16C558,
	defx_PIC16C558,
	0,
	0,
};


/* deleted from MPLAB
const static PIC_DEFINITION PIC16C558A =
{
	"16C558A",
	def_PIC16C558,
	sizeof(def_PIC16C558),
	0,
	0,
};
*/


//-----------------------------------------------------------------------------
//
//  PIC16C56:
//

const static UINT8 def_PIC16C56[] =
{
	0x04, 0x00, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x04, 0x00,
	0x04, 0x0f, 0xff, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0b, 0x08, 0x05, 0x06,
};

const static UINT8 defx_PIC16C56[] =
{
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C56 =
{
	"16C56",
	def_PIC16C56,
	defx_PIC16C56,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C56A:
//

const static UINT8 def_PIC16C56A[] =
{
	0x04, 0x00, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x0f,
	0x00, 0x0f, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x04, 0x00,
	0x04, 0x0f, 0xff, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0b, 0x08, 0x05, 0x06,
};

const static UINT8 defx_PIC16C56A[] =
{
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C56A =
{
	"16C56A",
	def_PIC16C56A,
	defx_PIC16C56A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C57:
//

const static UINT8 def_PIC16C57[] =
{
	0x08, 0x00, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x08, 0x00,
	0x04, 0x0f, 0xff, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0b, 0x08, 0x06, 0x06,
};

const static UINT8 defx_PIC16C57[] =
{
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C57 =
{
	"16C57",
	def_PIC16C57,
	defx_PIC16C57,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C57C:
//

const static UINT8 def_PIC16C57C[] =
{
	0x08, 0x00, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x0f,
	0x00, 0x0f, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x08, 0x00,
	0x04, 0x0f, 0xff, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0b, 0x08, 0x06, 0x06,
};

const static UINT8 defx_PIC16C57C[] =
{
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C57C =
{
	"16C57C",
	def_PIC16C57C,
	defx_PIC16C57C,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C58A:
//

const static UINT8 def_PIC16C58A[] =
{
	0x08, 0x00, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x0f,
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x08, 0x00,
	0x04, 0x0f, 0xff, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0b, 0x08, 0x05, 0x06,
};

const static UINT8 defx_PIC16C58A[] =
{
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C58A =
{
	"16C58A",
	def_PIC16C58A,
	defx_PIC16C58A,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C58B:
//

const static UINT8 def_PIC16C58B[] =
{
	0x08, 0x00, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x0f,
	0x00, 0x0f, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x08, 0x00,
	0x04, 0x0f, 0xff, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0b, 0x08, 0x05, 0x06,
};

const static UINT8 defx_PIC16C58B[] =
{
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C58B =
{
	"16C58B",
	def_PIC16C58B,
	defx_PIC16C58B,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C61:
//

const static UINT8 def_PIC16C61[] =
{
	0x04, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x00, 0x1f,
	0x00, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x02, 0x06,
};

const static UINT8 defx_PIC16C61[] =
{
	0x00, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C61 =
{
	"16C61",
	def_PIC16C61,
	defx_PIC16C61,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C62:
//

const static UINT8 def_PIC16C62[] =
{
	0x08, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x00, 0x3f,
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x03, 0x06,
};

const static UINT8 defx_PIC16C62[] =
{
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C62 =
{
	"16C62",
	def_PIC16C62,
	defx_PIC16C62,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C62A/PIC16C62B:
//

const static UINT8 def_PIC16C62A[] =
{
	0x08, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x03, 0x06,
};

const static UINT8 defx_PIC16C62A[] =
{
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C62A =
{
	"16C62A",
	def_PIC16C62A,
	defx_PIC16C62A,
	0,
	0,
};

const static PIC_DEFINITION PIC16C62B =
{
	"16C62B",
	def_PIC16C62A,
	defx_PIC16C62A,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C620/PIC16C620A/PIC16CE623:
//

const static UINT8 def_PIC16C620[] =
{
	0x02, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x02, 0x06,
};

const static PIC_DEFINITION PIC16C620 =
{
	"16C620",
	def_PIC16C620,
	defx_PIC16C62A,
	0,
	0,
};


const static PIC_DEFINITION PIC16C620A =
{
	"16C620A",
	def_PIC16C620,
	defx_PIC16C62A,
	0,
	0,
};


const static PIC_DEFINITION PIC16CE623 =
{
	"16CE623",
	def_PIC16C620,
	defx_PIC16C62A,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C621/PIC16C621A/PIC16CE624:
//

const static UINT8 def_PIC16C621[] =
{
	0x04, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x02, 0x06,
};

const static PIC_DEFINITION PIC16C621 =
{
	"16C621",
	def_PIC16C621,
	defx_PIC16C62A,
	0,
	0,
};

const static PIC_DEFINITION PIC16C621A =
{
	"16C621A",
	def_PIC16C621,
	defx_PIC16C62A,
	0,
	0,
};

const static PIC_DEFINITION PIC16CE624 =
{
	"16CE624",
	def_PIC16C621,
	defx_PIC16C62A,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C622/PIC16C622A/PIC16CE625:
//

const static UINT8 def_PIC16C622[] =
{
	0x08, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x02, 0x06,
};

const static PIC_DEFINITION PIC16C622 =
{
	"16C622",
	def_PIC16C622,
	defx_PIC16C62A,
	0,
	0,
};

const static PIC_DEFINITION PIC16C622A =
{
	"16C622A",
	def_PIC16C622,
	defx_PIC16C62A,
	0,
	0,
};

const static PIC_DEFINITION PIC16CE625 =
{
	"16CE625",
	def_PIC16C622,
	defx_PIC16C62A,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C63
//

const static UINT8 def_PIC16C63[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x03, 0x06,
};

const static PIC_DEFINITION PIC16C63 =
{
	"16C63",
	def_PIC16C63,
	defx_PIC16C62A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C63A:
//

const static UINT8 def_PIC16C63A[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x03, 0x06,
};

const static PIC_DEFINITION PIC16C63A =
{
	"16C63A",
	def_PIC16C63A,
	defx_PIC16C62A,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C64:
//

const static UINT8 def_PIC16C64[] =
{
	0x08, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x00, 0x3f,
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x04, 0x06,
};

const static UINT8 defx_PIC16C64[] =
{
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C64 =
{
	"16C64",
	def_PIC16C64,
	defx_PIC16C64,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C64A:
//

const static UINT8 def_PIC16C64A[] =
{
	0x08, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x04, 0x06,
};

const static PIC_DEFINITION PIC16C64A =
{
	"16C64A",
	def_PIC16C64A,
	defx_PIC16C62A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C642:
//

const static UINT8 def_PIC16C642[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x03, 0x26,
};

const static UINT8 defx_PIC16C642[] =
{
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C642 =
{
	"16C642",
	def_PIC16C642,
	defx_PIC16C642,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C65:
//

const static UINT8 def_PIC16C65[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x00, 0x3f,
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x04, 0x06,
};

const static UINT8 defx_PIC16C65[] =
{
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C65 =
{
	"16C65",
	def_PIC16C65,
	defx_PIC16C65,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C65A/PIC16C65B:
//

const static UINT8 def_PIC16C65A[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x04, 0x06,
};

const static PIC_DEFINITION PIC16C65A =
{
	"16C65A",
	def_PIC16C65A,
	defx_PIC16C62A,
	0,
	0,
};

const static PIC_DEFINITION PIC16C65B =
{
	"16C65B",
	def_PIC16C65A,
	defx_PIC16C62A,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//  PIC16C66:
//

const static UINT8 def_PIC16C66[] =
{
	0x20, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x03, 0x06,
};

const static PIC_DEFINITION PIC16C66 =
{
	"16C66",
	def_PIC16C66,
	defx_PIC16C62A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C662:
//

const static UINT8 def_PIC16C662[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x04, 0x26,
};

const static PIC_DEFINITION PIC16C662 =
{
	"16C662",
	def_PIC16C662,
	defx_PIC16C642,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C67:
//

const static UINT8 def_PIC16C67[] =
{
	0x20, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x04, 0x06,
};

const static PIC_DEFINITION PIC16C67 =
{
	"16C67",
	def_PIC16C67,
	defx_PIC16C62A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C71:
//

const static UINT8 def_PIC16C71[] =
{
	0x04, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x00, 0x1f,
	0x00, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x02, 0x06,
};

const static UINT8 defx_PIC16C71[] =
{
	0x00, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C71 =
{
	"16C71",
	def_PIC16C71,
	defx_PIC16C71,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C710:
//

const static UINT8 def_PIC16C710[] =
{
	0x02, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x02, 0x06,
};

const static PIC_DEFINITION PIC16C710 =
{
	"16C710",
	def_PIC16C710,
	defx_PIC16C642,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C711:
//

const static UINT8 def_PIC16C711[] =
{
	0x04, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x02, 0x06,
};

const static PIC_DEFINITION PIC16C711 =
{
	"16C711",
	def_PIC16C711,
	defx_PIC16C642,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C712:
//

const static UINT8 def_PIC16C712[] =
{
	0x04, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x02, 0x06,
};

const static PIC_DEFINITION PIC16C712 =
{
	"16C711",
	def_PIC16C712,
	defx_PIC16C62A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C715:
//

const static UINT8 def_PIC16C715[] =
{
	0x08, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x02, 0x26,
};

const static PIC_DEFINITION PIC16C715 =
{
	"16C715",
	def_PIC16C715,
	defx_PIC16C642,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C716:
//

const static UINT8 def_PIC16C716[] =
{
	0x08, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x02, 0x06,
};

const static PIC_DEFINITION PIC16C716 =
{
	"16C716",
	def_PIC16C716,
	defx_PIC16C62A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C72/PIC16C72A:
//

const static UINT8 def_PIC16C72[] =
{
	0x08, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x03, 0x06,
};

const static PIC_DEFINITION PIC16C72 =
{
	"16C72",
	def_PIC16C72,
	defx_PIC16C62A,
	0,
	0,
};

const static PIC_DEFINITION PIC16C72A =
{
	"16C72A",
	def_PIC16C72,
	defx_PIC16C62A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C73:
//

const static UINT8 def_PIC16C73[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x00, 0x3f,
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x03, 0x06,
};

const static UINT8 defx_PIC16C73[] =
{
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C73 =
{
	"16C73",
	def_PIC16C73,
	defx_PIC16C73,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C73A/PIC16C73B:
//

const static UINT8 def_PIC16C73A[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x03, 0x06,
};

const static PIC_DEFINITION PIC16C73A =
{
	"16C73A",
	def_PIC16C73A,
	defx_PIC16C62A,
	0,
	0,
};

const static PIC_DEFINITION PIC16C73B =
{
	"16C73B",
	def_PIC16C73A,
	defx_PIC16C62A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C74:
//

const static UINT8 def_PIC16C74[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x00, 0x3f,
	0x00, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x04, 0x06,
};

const static PIC_DEFINITION PIC16C74 =
{
	"16C74",
	def_PIC16C74,
	defx_PIC16C73,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C74A/PIC16C74B:
//

const static UINT8 def_PIC16C74A[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x04, 0x06,
};

const static PIC_DEFINITION PIC16C74A =
{
	"16C74A",
	def_PIC16C74A,
	defx_PIC16C62A,
	0,
	0,
};

const static PIC_DEFINITION PIC16C74B =
{
	"16C74B",
	def_PIC16C74A,
	defx_PIC16C62A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C76:
//

const static UINT8 def_PIC16C76[] =
{
	0x20, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x03, 0x06,
};

const static PIC_DEFINITION PIC16C76 =
{
	"16C76",
	def_PIC16C76,
	defx_PIC16C62A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C77:
//

const static UINT8 def_PIC16C77[] =
{
	0x20, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x04, 0x06,
};

const static PIC_DEFINITION PIC16C77 =
{
	"16C77",
	def_PIC16C77,
	defx_PIC16C62A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C773:
//

const static UINT8 def_PIC16C773[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x7f,
	0x3f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x04, 0x06,
};

const static PIC_DEFINITION PIC16C773 =
{
	"16C773",
	def_PIC16C773,
	defx_PIC16C62A,
	0,
	0,
};

const static PIC_DEFINITION PIC16C774 =
{
	"16C774",
	def_PIC16C773,
	defx_PIC16C62A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16F83:
//

const static UINT8 def_PIC16F83[] =
{
	0x02, 0x00,					// size of program space
	0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04,
	0x20, 0x07,					// address of config bits
	0x01,
	0x00, 0x00,					// start of data space?
	0x00, 0x40,					// size of data space
	0x00, 0x00,					// address of calibration space
	0x00, 0x00,					// size of calibration space
	0x03, 0x01, 0x02, 0x0f,
};

const static PIC_DEFINITION PIC16F83 =
{
	"16F83",
	def_PIC16F83,
	defx_PIC16C642,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//  PIC16C84:
//

const static UINT8 def_PIC16C84[] =
{
	0x04, 0x00,					// size of program space
	0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x00, 0x1f,
	0x00, 0x1f, 0x00, 0xff,
	0x00, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04,
	0x20, 0x07,					// address of config bits
	0x01,
	0x00, 0x00,					// start of data space?
	0x00, 0x40,					// size of data space
	0x00, 0x00,					// address of calibration space
	0x00, 0x00,					// size of calibration space
	0x03, 0x01, 0x02, 0x0f,
};

const static UINT8 defx_PIC16C84[] =
{
	0x00, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C84 =
{
	"16C84",
	def_PIC16C84,
	defx_PIC16C84,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
// PIC16F84
// (osc RC, wd on, power up timer off, code protect off)
//

const static UINT8 def_PIC16F84[] =
{
	0x04, 0x00,										// size of program memory (in words)
	0x3f, 0xff, 0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00, 0x04,
	0x20, 0x07,										// address of the configuration bits
	0x01,
	0x00, 0x00,
	0x00, 0x40,										// size of EEPROM data space
	0x00, 0x00,										// no clock calibration space
	0x00, 0x00,										// (address and size = 0)
	0x03, 0x01, 0x02, 0x0f
};


const static PIC_DEFINITION PIC16F84 =
{
	"16F84",
	def_PIC16F84,
	defx_PIC16C642,
	0x3ff0,						// code protection bits
	0x0004,						// watchdog enable (1 = enabled)
};

//-----------------------------------------------------------------------------
//
// PIC16F84A
// (osc RC, wd on, power up timer off, code protect off)
//

const static UINT8 def_PIC16F84A[] =
{
	0x04, 0x00,										// size of program memory (in words)

	0x3f, 0xff, 0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00, 0x04,
	0x20, 0x07,										// address of configuration bits
	0x01,
	0x00, 0x00,
	0x00, 0x40,										// size of EEPROM data space
	0x00, 0x00,										// no clock calibration space
	0x00, 0x00,										// (address and size = 0)
	0x00, 0x01, 0x02, 0x0f
};


const static PIC_DEFINITION PIC16F84A =
{
	"16F84A",
	def_PIC16F84A,
	defx_PIC16C642,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
// PIC16F872
//
//

const static UINT8 def_PIC16F872[] =
{
	0x08, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3b, 0xff,
	0x3b, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x40,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x04, 0x0f,
};

const static UINT8 defx_PIC16F872[] =
{
	0x3b, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x3b, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16F872 =
{
	"16F872",
	def_PIC16F872,
	defx_PIC16F872,
	0,						// code protection bits
	0,						// watchdog enable (1 = enabled)
};

//-----------------------------------------------------------------------------
//
// PIC16F873/PIC16F874
//
//

const static UINT8 def_PIC16F873[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3b, 0xff,
	0x3b, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x80,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x04, 0x0f,
};

const static PIC_DEFINITION PIC16F873 =
{
	"16F873",
	def_PIC16F873,
	defx_PIC16F872,
	0,						// code protection bits
	0,						// watchdog enable (1 = enabled)
};

const static PIC_DEFINITION PIC16F874 =
{
	"16F874",
	def_PIC16F873,
	defx_PIC16F872,
	0,						// code protection bits
	0,						// watchdog enable (1 = enabled)
};

//-----------------------------------------------------------------------------
//
// PIC16F876
//
//

const static UINT8 def_PIC16F876[] =
{
	0x20, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3b, 0xff,
	0x3b, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04, 0x20, 0x07, 0x01,
	0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x04, 0x0f,
};

const static PIC_DEFINITION PIC16F876 =
{
	"16F876",
	def_PIC16F876,
	defx_PIC16F872,
	0,						// code protection bits
	0,						// watchdog enable (1 = enabled)
};

//-----------------------------------------------------------------------------
//
// PIC16F877
// (osc RC, wd on, power up timer off, brown out detect on,
//   low volt prog enabled, data EE prot off, flash prog write en,
//   bgnd debug disabled, code protect off)
//

const static UINT8 def_PIC16F877[] =
{
	0x20, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3b, 0xff,
	0x3b, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04,
	0x20, 0x07,
	0x01,
	0x00, 0x00,
	0x01, 0x00,										// size of EEPROM data space
	0x00, 0x00,										// no clock calibration space
	0x00, 0x00,										// (address and size = 0)
	0x00, 0x01, 0x04, 0x0f,
};


const static PIC_DEFINITION PIC16F877 =
{
	"16F877",
	def_PIC16F877,
	defx_PIC16F872,
	0,						// code protection bits
	0,						// watchdog enable (1 = enabled)
};

//-----------------------------------------------------------------------------
//
//	PIC16C923:
//
const static UINT8 def_PIC16C923[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x3f,
	0x3f, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04,
	0x20, 0x07,
	0x01,
	0x00, 0x00,
	0x00, 0x00,										// size of EEPROM data space
	0x00, 0x00,										// no clock calibration space
	0x00, 0x00,										// (address and size = 0)
	0x03, 0x19, 0x04, 0x06,
};

const static UINT8 defx_PIC16C923[] =
{
	0x3f, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x3f, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC16C923 =
{
	"16C923",
	def_PIC16C923,
	defx_PIC16C923,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//	PIC16C924:
//
const static UINT8 def_PIC16C924[] =
{
	0x10, 0x00, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x7f,
	0x00, 0x7f, 0x3f, 0x3f,
	0x3f, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x20, 0x00,
	0x04,
	0x20, 0x07,
	0x01,
	0x00, 0x00,
	0x00, 0x00,										// size of EEPROM data space
	0x00, 0x00,										// no clock calibration space
	0x00, 0x00,										// (address and size = 0)
	0x03, 0x19, 0x04, 0x06,
};

const static PIC_DEFINITION PIC16C924 =
{
	"16C924",
	def_PIC16C924,
	defx_PIC16C923,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//	PIC17C42:
//
const static UINT8 def_PIC17C42[] =
{
	0x08, 0x00, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x5f,
	0x00, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00,
	0x00, 0xfe, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x07, 0x04,
};

const static UINT8 defx_PIC17C42[] =
{
	0x00, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC17C42 =
{
	"17C42",
	def_PIC17C42,
	defx_PIC17C42,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//	PIC17C42A:
//
const static UINT8 def_PIC17C42A[] =
{
	0x08, 0x00, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x80, 0x5f,
	0x80, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00,
	0x00, 0xfe, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x07, 0x04,
};

const static UINT8 defx_PIC17C42A[] =
{
	0x80, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x80, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC17C42A =
{
	"17C42A",
	def_PIC17C42A,
	defx_PIC17C42A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//	PIC17C43:
//
const static UINT8 def_PIC17C43[] =
{
	0x10, 0x00, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x80, 0x5f,
	0x80, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00,
	0x00, 0xfe, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x07, 0x04,
};

const static PIC_DEFINITION PIC17C43 =
{
	"17C43",
	def_PIC17C43,
	defx_PIC17C42A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//	PIC17C44:
//
const static UINT8 def_PIC17C44[] =
{
	0x20, 0x00, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x80, 0x5f,
	0x80, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00,
	0x00, 0xfe, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x07, 0x04,
};

const static PIC_DEFINITION PIC17C44 =
{
	"17C44",
	def_PIC17C44,
	defx_PIC17C42A,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//	PIC17C752/PIC17C762:
//
const static UINT8 def_PIC17C752[] =
{
	0x20, 0x00, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0xc0, 0x5f,
	0xc0, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00,
	0x00, 0xfe, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x03, 0x19, 0x07, 0x04,
};

const static UINT8 defx_PIC17C52[] =
{
	0xc0, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0xc0, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

const static PIC_DEFINITION PIC17C752 =
{
	"17C752",
	def_PIC17C752,
	defx_PIC17C52,
	0,
	0,
};

const static PIC_DEFINITION PIC17C762 =
{
	"17C762",
	def_PIC17C752,
	defx_PIC17C52,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//	PIC17C756/PIC17C756A/PIC17C766:
//
const static UINT8 def_PIC17C756[] =
{
	0x40, 0x00,					// size of program space
	0xff, 0xff,	0xff, 0xff,
	0x00, 0x00,
	0x00, 0x00,
	0xc0, 0x5f,
	0xc0, 0x5f,
	0x00, 0x00,	0x00, 0x00,
	0x00, 0x00,	0x00, 0x00,
	0x00, 0x00,	0x00, 0x01,
	0x00, 0x00,	0x00,
	0xfe, 0x00,					// address of configuration bits
	0x01,
	0x00, 0x00,					// address of data space?
	0x00, 0x00,					// size of data space
	0x00, 0x00,					// address of internal clock calibration value
	0x00, 0x00,					// size of clock calibration space
	0x03, 0x19, 0x07, 0x04,
};

const static PIC_DEFINITION PIC17C756 =
{
	"17C756",
	def_PIC17C756,
	defx_PIC17C52,
	0,
	0,
};

const static PIC_DEFINITION PIC17C756A =
{
	"17C756A",
	def_PIC17C756,
	defx_PIC17C52,
	0,
	0,
};

const static PIC_DEFINITION PIC17C766 =
{
	"17C766",
	def_PIC17C756,
	defx_PIC17C52,
	0,
	0,
};


//-----------------------------------------------------------------------------
//
//	PIC18C242
//
const static UINT8 def_PIC18C242[] =
{
	0x20, 0x00,					// size of program space
	0xff, 0xff,	0xff, 0xff,
	0x0f, 0x0f,
	0x0f, 0x0f,
	0x27, 0xff,
	0x27, 0xff,
	0x00, 0x00,	0x00, 0x00,
	0x00, 0x00,	0x00, 0x00,
	0x00, 0x00,	0x00, 0x01,
	0x00, 0x00,	0x04,
	0x00, 0x00,					// address of configuration bits
	0x04,
	0x00, 0x00,					// address of data space?
	0x00, 0x00,					// size of data space
	0x00, 0x00,					// address of internal clock calibration value
	0x00, 0x00,					// size of clock calibration space
	0x03, 0x19, 0x0b, 0x06,
};

const static UINT8 defx_PIC18C242[] =
{
	0x27, 0xff, 0x0f, 0x0f,
	0x01, 0x00, 0x00, 0x01,
	0x27, 0xff, 0x0f, 0x0f,
	0x01, 0x00, 0x00, 0x01,
};

const static PIC_DEFINITION PIC18C242 =
{
	"18C242",
	def_PIC18C242,
	defx_PIC18C242,
	0,
	0,
};

const static PIC_DEFINITION PIC18C442 =
{
	"18C442",
	def_PIC18C242,
	defx_PIC18C242,
	0,
	0,
};

//-----------------------------------------------------------------------------
//
//	PIC18C252
//

const static UINT8 def_PIC18C252[] =
{
	0x40, 0x00,					// size of program space
	0xff, 0xff,	0xff, 0xff,
	0x0f, 0x0f,
	0x0f, 0x0f,
	0x27, 0xff,
	0x27, 0xff,
	0x00, 0x00,	0x00, 0x00,
	0x00, 0x00,	0x00, 0x00,
	0x00, 0x00,	0x00, 0x01,
	0x00, 0x00,	0x04,
	0x00, 0x00,					// address of configuration bits
	0x04,
	0x00, 0x00,					// address of data space?
	0x00, 0x00,					// size of data space
	0x00, 0x00,					// address of internal clock calibration value
	0x00, 0x00,					// size of clock calibration space
	0x03, 0x19, 0x0b, 0x06,
};

const static UINT8 defx_PIC18C252[] =
{
	0x27, 0xff, 0x0f, 0x0f,
	0x01, 0x00, 0x00, 0x01,
	0x27, 0xff, 0x0f, 0x0f,
	0x01, 0x00, 0x00, 0x01,
};

const static PIC_DEFINITION PIC18C252 =
{
	"18C252",
	def_PIC18C252,
	defx_PIC18C252,
	0,
	0,
};

const static PIC_DEFINITION PIC18C452 =
{
	"18C452",
	def_PIC18C252,
	defx_PIC18C252,
	0,
	0,
};

//-----------------------------------------------------------------------------
/*
  14 July, 2000:

added:
PIC16HV540
PIC16C55A
PIC16C57C
PIC16C712
PIC16C716
PIC16C773
PIC16C774
PIC16F872
PIC16F873
PIC16F874
PIC16F876
PIC18C242
PIC18C252

dropped:
PIC16C554A
PIC16C556
PIC16C556A
PIC16C558A

*/


//----------------------------------------
//
// external access through this array only
//
const PIC_DEFINITION *deviceList[] =
{
	&PIC12C508,
	&PIC12C508A,
	&PIC12C509,
	&PIC12C509A,
	&PIC12C671,
	&PIC12C672,
	&PIC12CE518,
	&PIC12CE519,
	&PIC12CE673,
	&PIC12CE674,
	&PIC14000,
	&PIC16C505,
	&PIC16C52,
	&PIC16C54,
	&PIC16C54A,
	&PIC16C54B,
	&PIC16C54C,
	&PIC16C55,
	&PIC16C554,
	&PIC16C558,
	&PIC16C55A,
	&PIC16C56,
	&PIC16C56A,
	&PIC16C57,
	&PIC16C57C,
	&PIC16C58A,
	&PIC16C58B,
	&PIC16C61,
	&PIC16C62,
	&PIC16C620,
	&PIC16C620A,
	&PIC16C621,
	&PIC16C621A,
	&PIC16C622,
	&PIC16C622A,
	&PIC16C62A,
	&PIC16C62B,
	&PIC16C63,
	&PIC16C63A,
	&PIC16C64,
	&PIC16C642,
	&PIC16C64A,
	&PIC16C65,
	&PIC16C65A,
	&PIC16C65B,
	&PIC16C66,
	&PIC16C662,
	&PIC16C67,
	&PIC16C71,
	&PIC16C710,
	&PIC16C711,
	&PIC16C712,
	&PIC16C715,
	&PIC16C716,
	&PIC16C72,
	&PIC16C72A,
	&PIC16C73,
	&PIC16C73A,
	&PIC16C73B,
	&PIC16C74,
	&PIC16C74A,
	&PIC16C74B,
	&PIC16C76,
	&PIC16C77,
	&PIC16C773,
	&PIC16C774,
	&PIC16C84,
	&PIC16C923,
	&PIC16C924,
	&PIC16CE623,
	&PIC16CE624,
	&PIC16CE625,
	&PIC16F83,
	&PIC16F84,
	&PIC16F84A,
	&PIC16F872,
	&PIC16F873,
	&PIC16F874,
	&PIC16F876,
	&PIC16F877,
	&PIC16HV540,
	&PIC17C42,
	&PIC17C42A,
	&PIC17C43,
	&PIC17C44,
	&PIC17C752,
	&PIC17C756,
	&PIC17C756A,
	&PIC17C762,
	&PIC17C766,
	&PIC18C242,
	&PIC18C252,
	&PIC18C442,
	&PIC18C452,
	0				// end of list
};

