/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file block_align_top.hpp
 * \brief A class representing a block_align_top.
 * \author Sebastien Angibaud
 */
#ifndef __BEAR_BLOCK_ALIGN_TOP_HPP__
#define __BEAR_BLOCK_ALIGN_TOP_HPP__

#include "engine/item_brick/basic_renderable_item.hpp"
#include "engine/item_brick/item_with_activable_sides.hpp"
#include "engine/item_brick/item_with_decoration.hpp"
#include "engine/item_brick/item_with_friction.hpp"
#include "engine/item_brick/item_with_restricted_z_collision.hpp"
#include "engine/item_brick/item_with_z_shift.hpp"

#include "generic_items/class_export.hpp"

#include "engine/export.hpp"

namespace bear
{
  /**
   * \brief A class representing an block_align_top.
   *
   * The custom fields of this class are:
   * - top_friction: real, the friction applied to the items in contact on the
   *
   * \author Sebastien Angibaud
   */
  class GENERIC_ITEMS_EXPORT block_align_top:
    public engine::item_with_friction
    < engine::item_with_restricted_z_collision
      < engine::item_with_z_shift
        < engine::item_with_decoration
          < engine::basic_renderable_item<engine::base_item> >
        >
      >
    >
  {
    DECLARE_BASE_ITEM(block_align_top, bear);

    typedef engine::item_with_friction
    < engine::item_with_restricted_z_collision
      < engine::item_with_z_shift
        < engine::item_with_decoration
          < engine::basic_renderable_item<engine::base_item> >
        >
      >
    > super;

  public:
    block_align_top();

    virtual bool set_real_field( const std::string& name, double value );

  protected:
    void collision_check_and_align
    ( engine::base_item& that, universe::collision_info& info );

  private:
    void collision
    ( engine::base_item& that, universe::collision_info& info );

  private:
    /* \brief The friction applied on the top. */
    double m_top_friction;

  }; // class block_align_top
} // namespace bear

#endif // __BEAR_BLOCK_ALIGN_TOP_HPP__
