/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file camera_shaker.cpp
 * \brief Implementation of the bear::camera_shaker class.
 * \author Sebastien Angibaud
 */
#include "generic_items/camera_shaker.hpp"

#include "generic_items/camera.hpp"
#include "engine/export.hpp"

BASE_ITEM_EXPORT( camera_shaker, bear )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
bear::camera_shaker::camera_shaker()
  : m_shaker_force(10)
{
  set_phantom(true);
  set_can_move_items(false);
  set_size(1,1);
} // camera_shaker::camera_shaker()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type <real>.
 * \param value The value of the field.
 */
bool bear::camera_shaker::set_real_field
( const std::string& name, double value )
{
  bool result = true;

  if ( name == "camera_shaker.shaker_force" )
    m_shaker_force = value;
  else
    result = super::set_real_field(name, value);

  return result;
} // camera_shaker::set_real_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Process a collision with an other item.
 * \param that The other item of the collision.
 * \param info Some informations about the collision.
 */
void bear::camera_shaker::collision
( engine::base_item& that, universe::collision_info& info )
{
  camera* c = dynamic_cast<camera*>(&that);

  if (c != NULL)
    c->set_shaker_force(m_shaker_force);
} // camera_shaker::collision()
