/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file speaker_item.hpp
 * \brief The class describing a speaker_item.hpp.
 * \author Sbastien Angibaud
 */
#ifndef __PTB_SPEAKER_ITEM_HPP__
#define __PTB_SPEAKER_ITEM_HPP__

#include <string>
#include <list>

#include "engine/level_globals.hpp"
#include "gui/frame.hpp"
#include "gui/static_text.hpp"
#include "universe/physical_item_state.hpp"

namespace ptb
{
  /**
   * \brief The class describing a speaker.
   * \author Sbastien Angibaud
   */
  class speaker_item
  {
    /*----------------------------------------------------------------------*/
    /**
     * \brief A balloon.
     * \author Sebastien Angibaud
     */
    class balloon
    {
    public:
      balloon(const std::list< std::string >& speeches);
      ~balloon();

      void progress( bear::universe::time_type elapsed_time );
      void render( std::list<bear::visual::scene_element>& e );
      void build(bear::engine::level_globals& glob);

      bool is_finished() const ;
      bear::gui::frame* get_frame();
      void set_position(const claw::math::coordinate_2d<unsigned int>& pos);
      void set_spike_top(bool top);
      void set_spike_right(bool right);
      bool get_spike_top() const;
      bool get_spike_right() const;

    private:
      bear::visual::sprite* create_spike
      (bear::engine::level_globals& glob) const;
      bear::visual::sprite* create_corner
      (bear::engine::level_globals& glob) const;
      bear::visual::sprite* create_horizontal_border
      (bear::engine::level_globals& glob) const;
      bear::visual::sprite* create_vertical_border
      (bear::engine::level_globals& glob) const;
      bear::visual::sprite* create_background
      (bear::engine::level_globals& glob) const;
      void increase();
      void decrease();
      void write_text();

    private:
      /** \brief The speech. */
      std::list< std::string > m_speeches;

      /** \brief The spike, going out of the mouth of the speaker. */
      bear::visual::sprite* m_spike;

      /** \brief The size of the frame. */
      claw::math::coordinate_2d<unsigned int> m_size_frame;

      /** \brief Indicates if the time is started. */
      bool m_has_started;

      /** \brief The component containing the text. */
      bear::gui::frame* m_frame;

      /** \brief The component in which we show the text. */
      bear::gui::static_text* m_text;

      /** \brief Indicates the time elapsed since the creation. */
      bear::universe::time_type m_time;

      /** \brief Indicates the time during the text is visible. */
      bear::universe::time_type m_play_time;

      /** \brief Indicates if the balloon is in the top of the item. */
      bool m_top;

      /** \brief Indicates if the balloon is in the right of the item. */
      bool m_right;
    }; // class balloon

  public:
    speaker_item();
    ~speaker_item();

    static void pre_cache( bear::engine::level_globals& glob );
    void build(bear::engine::level_globals& glob);

    bool has_finished_to_chat() const;

    void reset_speeches();
    void add_speech( const std::string& speech );
    bool speak(bear::engine::level_globals& glob);

    void create_balloon(bear::engine::level_globals& glob);
    void stop_to_speak();

    ptb::speaker_item::balloon* get_balloon() const;
    const bear::universe::physical_item_state* get_speaker() const;
    void set_speaker_item( const bear::universe::physical_item_state* speaker );

  private:
    /** \brief The speaker (himself). */
    const bear::universe::physical_item_state* m_speaker;

    /** \brief The balloon. */
    balloon* m_balloon;

    /** \brief Indicates if the item speaks. */
    bool m_speak_state;

    /** \brief The speech. */
    std::list<std::string> m_speeches;

  }; // class speaker_item
} // namespace ptb

#endif // __PTB_SPEAKER_ITEM_HPP__
