//
// Context.h
//
// $Id: //poco/1.3/NetSSL_OpenSSL/include/Poco/Net/Context.h#1 $
//
// Library: NetSSL_OpenSSL
// Package: SSLCore
// Module:  Context
//
// Definition of the Context class.
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef NetSSL_Context_INCLUDED
#define NetSSL_Context_INCLUDED


#include "Poco/Net/NetSSL.h"
#include <openssl/ssl.h>


namespace Poco {
namespace Net {


class NetSSL_API Context
	/// This class encapsulates an SSL Context.
{
public:
	enum VerificationMode 
	{
		VERIFY_NONE    = SSL_VERIFY_NONE, 
		VERIFY_RELAXED = SSL_VERIFY_PEER, 
		VERIFY_STRICT  = SSL_VERIFY_FAIL_IF_NO_PEER_CERT, 
		VERIFY_ONCE    = SSL_VERIFY_CLIENT_ONCE
	};

	Context(const std::string& privateKeyFile, 
		const std::string& caLocation, 
		bool isServerContext,
		VerificationMode verMode = VERIFY_STRICT,
		int verificationDepth = 9,
		bool loadCAFromDefaultPath = false,
		const std::string& cypherList = "ALL:!ADH:!LOW:!EXP:!MD5:@STRENGTH");
			/// Creates a context.
			/// privateKeyFile contains the key used for encryption, caLocation can either
			/// be a directory or a single file containing the certificates for certificate authorities.
			/// isServerContext defines if the context belongs to a server or client.
			/// verificationDepth sets the upper limit for verification chain sizes. If we encounter
			/// a chain larger than that limit, verification will fail.
			/// Cypherlist defines which protocols are allowed.
			/// Creates the Context.

	~Context();
		/// Destroys the Context.

	SSL_CTX* sslContext() const;

	Context::VerificationMode verificationMode() const;

	bool serverContext() const;

private:
	SSL_CTX*                  _pSSLContext;
	Context::VerificationMode _mode;
	bool                      _server;
};


//
// inlines
//
inline SSL_CTX* Context::sslContext() const
{
	return _pSSLContext;
}


inline Context::VerificationMode Context::verificationMode() const
{
	return _mode;
}


inline bool Context::serverContext() const
{
	return _server;
}


} } // namespace Poco::Net


#endif // NetSSL_Context_INCLUDED
