//
// TeeStream.h
//
// $Id: //poco/1.3/Foundation/include/Poco/TeeStream.h#1 $
//
// Library: Foundation
// Package: Streams
// Module:  TeeStream
//
// Definition of the TeeStream class.
//
// Copyright (c) 2005-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Foundation_TeeStream_INCLUDED
#define Foundation_TeeStream_INCLUDED


#include "Poco/Foundation.h"
#include "Poco/UnbufferedStreamBuf.h"
#include <vector>
#include <istream>
#include <ostream>


namespace Poco {


class Foundation_API TeeStreamBuf: public UnbufferedStreamBuf
	/// This stream buffer copies all data written to or
	/// read from it to one or multiple output streams.
{
public:
	TeeStreamBuf();
		/// Creates an unconnected CountingStreamBuf.
		/// Use addStream() to attach output streams.
	
	TeeStreamBuf(std::istream& istr);
		/// Creates the CountingStreamBuf and connects it
		/// to the given input stream.

	TeeStreamBuf(std::ostream& ostr);
		/// Creates the CountingStreamBuf and connects it
		/// to the given output stream.

	~TeeStreamBuf();
		/// Destroys the CountingStream.

	void addStream(std::ostream& ostr);
		/// Adds the given output stream.

protected:
	int readFromDevice();
	int writeToDevice(char c);

private:
	typedef std::vector<std::ostream*> StreamVec;
	
	std::istream* _pIstr;
	StreamVec     _streams;
};


class Foundation_API TeeIOS: public virtual std::ios
	/// The base class for TeeInputStream and TeeOutputStream.
	///
	/// This class is needed to ensure the correct initialization
	/// order of the stream buffer and base classes.
{
public:
	TeeIOS();
		/// Creates the basic stream and leaves it unconnected.

	TeeIOS(std::istream& istr);
		/// Creates the basic stream and connects it
		/// to the given input stream.

	TeeIOS(std::ostream& ostr);
		/// Creates the basic stream and connects it
		/// to the given output stream.

	~TeeIOS();
		/// Destroys the stream.

	void addStream(std::ostream& ostr);
		/// Adds the given output stream.

	TeeStreamBuf* rdbuf();
		/// Returns a pointer to the underlying streambuf.

protected:
	TeeStreamBuf _buf;
};


class Foundation_API TeeInputStream: public TeeIOS, public std::istream
	/// This stream copies all characters read through it
	/// to one or multiple output streams.
{
public:
	TeeInputStream(std::istream& istr);
		/// Creates the TeeInputStream and connects it
		/// to the given input stream.

	~TeeInputStream();
		/// Destroys the TeeInputStream.
};


class Foundation_API TeeOutputStream: public TeeIOS, public std::ostream
	/// This stream copies all characters written to it
	/// to one or multiple output streams.
{
public:
	TeeOutputStream();
		/// Creates an unconnected TeeOutputStream.
	
	TeeOutputStream(std::ostream& ostr);
		/// Creates the TeeOutputStream and connects it
		/// to the given input stream.

	~TeeOutputStream();
		/// Destroys the TeeOutputStream.
};


} // namespace Poco


#endif // Foundation_TeeStream_INCLUDED
