//
// Configurable.h
//
// $Id: //poco/1.3/Foundation/include/Poco/Configurable.h#1 $
//
// Library: Foundation
// Package: Logging
// Module:  Configurable
//
// Definition of the Configurable class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Foundation_Configurable_INCLUDED
#define Foundation_Configurable_INCLUDED


#include "Poco/Foundation.h"


namespace Poco {


class Foundation_API Configurable
	/// A simple interface that defines
	/// getProperty() and setProperty() methods.
	///
	/// This interface is implemented by Formatter and
	/// Channel and is used to configure arbitrary
	/// channels and formatters.
	///
	/// A property is basically a name-value pair. For
	/// simplicity, both names and values are strings.
	/// Every property controls a certain aspect of a
	/// Formatter or Channel. For example, the PatternFormatter's
	/// formatting pattern is set via a property.
	///
	/// NOTE: The following property names are use internally
	/// by the logging framework and must not be used by
	/// channels or formatters:
	///   - class
	///   - pattern (Channel)
	///   - formatter (Channel)
{
public:
	Configurable();
		/// Creates the Configurable.
		
	virtual ~Configurable();
		/// Destroys the Configurable.
		
	virtual void setProperty(const std::string& name, const std::string& value) = 0;
		/// Sets the property with the given name to the given value.
		/// If a property with the given name is not supported, a
		/// PropertyNotSupportedException is thrown.
		
	virtual std::string getProperty(const std::string& name) const = 0;
		/// Returns the value of the property with the given name.
		/// If a property with the given name is not supported, a
		/// PropertyNotSupportedException is thrown.
};


} // namespace Poco


#endif // Foundation_Configurable_INCLUDED
