# $Id: Config.pm,v 1.17 2001/06/08 01:50:26 muhri Exp $
# -*- perl -*-
package Pronto::Config;
use strict;
use SelfLoader;
use vars qw ( $ConfigOpened $ConfigWindow);
$ConfigOpened = 0;
$ConfigWindow=undef;
1;
__DATA__



sub init_send_config
{
    	my $notebook = shift;
	my $vbox = new Gtk::VBox(0,5);
	$vbox->set_border_width(5);

        my $hbox = new Gtk::HBox(0,5);
	my $label = new Gtk::Label(_("Fork Send process?"));
	$notebook->{'forksend'} = new Gtk::CheckButton();
	$notebook->{'forksend'}->set_active($main::prefs{'forksend'});
	$hbox->pack_start($notebook->{'forksend'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Send Messages Immediately?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'SendImmediately'} = new Gtk::CheckButton;
	$notebook->{'SendImmediately'}->set_active($main::prefs{'SendImmediately'} eq 'y');
	$notebook->{'SendImmediately'}->set_usize(16,17);
	$hbox->pack_start($notebook->{'SendImmediately'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Automatically put people I reply to in my addressbook?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'AddReplytoAB'} = new Gtk::CheckButton();
	$notebook->{'AddReplytoAB'}->set_active($main::prefs{'AddReplytoAB'} eq "y");
	$notebook->{'AddReplytoAB'}->set_usize(16,17);
	$hbox->pack_start($notebook->{'AddReplytoAB'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Forward Attachments?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'ForwardAttachments'} = new Gtk::CheckButton();
	$notebook->{'ForwardAttachments'}->set_active($main::prefs{'ForwardAttachments'} eq "y");
	$notebook->{'ForwardAttachments'}->set_usize(16,17);
	$hbox->pack_start($notebook->{'ForwardAttachments'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("When Forwarding, include a brief header?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'ForwardHeader'} = new Gtk::CheckButton();
	$notebook->{'ForwardHeader'}->set_active($main::prefs{'ForwardHeader'} eq "y");
	$notebook->{'ForwardHeader'}->set_usize(16,17);
	$hbox->pack_start($notebook->{'ForwardHeader'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Check Spelling on Send?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'autospell'} = new Gtk::CheckButton();
	$notebook->{'autospell'}->set_active($main::prefs{'autospell'} eq "y");
	$notebook->{'autospell'}->set_usize(16,17);
	$hbox->pack_start($notebook->{'autospell'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Wrap after how many columns"));
	$label->set_alignment(0.0,0.5);
       	$notebook->{'WrapAfter'} = new Gtk::Entry;
	$notebook->{'WrapAfter'}->set_text($main::prefs{'WrapAfter'});
	$notebook->{'WrapAfter'}->set_editable('1');
	$notebook->{'WrapAfter'}->set_usize(45,22);
	$hbox->pack_start($label,0,0,5);
	$hbox->pack_start($notebook->{'WrapAfter'},0,0,5);
	$vbox->pack_start($hbox,0,0,0);

	$label = new Gtk::Label(_("Put the following line in front of Quoted Messages:\n(%n and %d, %s and %t will be replaced with Name, Date, Subject and SentTo)"));
	$label->set_usize(400,40);
	$label->set_alignment(0.0,0.5);
	$label->set_line_wrap(1);
	$vbox->pack_start($label,0,0,0);
	$hbox = new Gtk::HBox(0,0);
	$notebook->{'QuoteHeader'} = new Gtk::Text(undef, undef);
	$notebook->{'QuoteHeader'}->set_usize(400,82);
	$notebook->{'QuoteHeader'}->set_editable(1);
	$notebook->{'QuoteHeader'}->set_word_wrap(1);
	(my $Header_Text = $main::prefs{'QuoteHeader'}) =~ s/\*n/\n/g;
	$notebook->{'QuoteHeader'}->insert(undef, undef, undef, $Header_Text);
	$hbox->pack_start($notebook->{'QuoteHeader'},0,0,0);
	my $vScrollbar = new Gtk::VScrollbar($notebook->{'QuoteHeader'}->vadj);
	$hbox->pack_start($vScrollbar,0,0,0);
	$vScrollbar->show();
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Quote Character?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'QuoteWith'} = new Gtk::Entry;
	$notebook->{'QuoteWith'}->set_text($main::prefs{'QuoteWith'});
	$notebook->{'QuoteWith'}->set_editable('1');
	$notebook->{'QuoteWith'}->set_usize(35,22);
	$hbox->pack_start($label,0,0,0);
	$hbox->pack_start($notebook->{'QuoteWith'},0,0,5);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Use this application to provide my signatures instead: "));
	$notebook->{'ExternalSig'} = new Gtk::CheckButton();
	$notebook->{'ExternalSig'}->set_usize(16,17);
	$notebook->{'SigCmd'} = new Gtk::Entry;
	$notebook->{'SigCmd'}->set_usize(150,22);
	$notebook->{'SigCmd'}->set_text($main::prefs{'SigCmd'}||'');
	$notebook->{'ExternalSig'}->set_active($main::prefs{'ExternalSig'});
	$notebook->{'SigCmd'}->set_sensitive($notebook->{'ExternalSig'}->active);
	$notebook->{'ExternalSig'}->signal_connect("toggled", sub { $notebook->{'SigCmd'}->set_sensitive($notebook->{'ExternalSig'}->active) });
	$hbox->pack_start($notebook->{'ExternalSig'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$hbox->pack_start($notebook->{'SigCmd'},0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	return $vbox;
}


sub init_receive_config
{
    	my $notebook = shift;
	my $vbox = new Gtk::VBox(0,5);
	$vbox->set_border_width(5);

        my $hbox = new Gtk::HBox(0,5);
	my $label = new Gtk::Label(_("Fork Get process?"));
	$notebook->{'forkget'} = new Gtk::CheckButton();
	$notebook->{'forkget'}->set_active($main::prefs{'forkget'});
	$hbox->pack_start($notebook->{'forkget'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Check Mail on Startup?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'CheckMailOnStartup'} = new Gtk::CheckButton();
	$notebook->{'CheckMailOnStartup'}->set_usize(16,17);
	$notebook->{'CheckMailOnStartup'}->set_active($main::prefs{'CheckMailOnStartup'} eq "y");
	$hbox->pack_start($notebook->{'CheckMailOnStartup'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label->set_alignment(0.0,0.5);
	$label = new Gtk::Label(_("Verbose Error Output on pop3 check?"));
	$notebook->{'POP3Verbose'} = new Gtk::CheckButton();
	$notebook->{'POP3Verbose'}->set_usize(16,17);
	$notebook->{'POP3Verbose'}->set_active(1) if $main::prefs{'POP3Verbose'};
	$hbox->pack_start($notebook->{'POP3Verbose'},0,0,0);
	$hbox->pack_start($label,0,0,0);		
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Check mail every"));
	$label->set_alignment(0.0,0.5);
	$hbox->pack_start($label,0,0,5);		
	$notebook->{'AutoCheckTime'} = new Gtk::Entry;
	$notebook->{'AutoCheckTime'}->set_text($main::prefs{'AutoCheckTime'});
	$notebook->{'AutoCheckTime'}->set_editable('1');
	$notebook->{'AutoCheckTime'}->set_usize(45,22);
	$hbox->pack_start($notebook->{'AutoCheckTime'},0,0,0);
	$label = new Gtk::Label(_("Minutes (0 to disable)"));
	$label->set_alignment(0.0,0.5);
	$hbox->pack_start($label,0,0,5);		
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Do NOT download if message is greater than"));
	$label->set_alignment(0.0,0.5);
	$hbox->pack_start($label,0,0,5);		
	$notebook->{'MaxFetchSize'} = new Gtk::Entry;
	$notebook->{'MaxFetchSize'}->set_text($main::prefs{'MaxFetchSize'});
	$notebook->{'MaxFetchSize'}->set_editable('1');
	$notebook->{'MaxFetchSize'}->set_usize(45,22);
	$hbox->pack_start($notebook->{'MaxFetchSize'},0,0,0);		
	$label = new Gtk::Label(_("Kbytes (0 to disable) - POP3 only"));
	$label->set_alignment(0.0,0.5);
	$hbox->pack_start($label,0,0,5);		
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Auto Check Reports Progress?"));
	$notebook->{'AutoCheckProgress'} = new Gtk::CheckButton;
	$notebook->{'AutoCheckProgress'}->set_usize(16,17);
	$notebook->{'AutoCheckProgress'}->set_active($main::prefs{'AutoCheckProgress'});
	$hbox->pack_start($notebook->{'AutoCheckProgress'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Return Receipt"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'RetRecAsk'} = new Gtk::RadioButton(_("Ask"));
	$notebook->{'RetRecAlways'} = new Gtk::RadioButton(_("Always"),$notebook->{'RetRecAsk'});
	$notebook->{'RetRecNever'} = new Gtk::RadioButton(_("Never"), $notebook->{'RetRecAlways'});
	if (defined $main::prefs{'SendReceipt'} && $main::prefs{'SendReceipt'} eq "never"){
		$notebook->{'RetRecNever'}->set_active(1);
	} elsif (defined $main::prefs{'SendReceipt'} && $main::prefs{'SendReceipt'} eq "all") {
		$notebook->{'RetRecAlways'}->set_active(1);
	} else {
		$notebook->{'RetRecAsk'}->set_active(1);
	}
	$hbox->pack_start($label,0,0,5);
	$hbox->pack_start($notebook->{'RetRecAsk'},0,0,0);
	$hbox->pack_start($notebook->{'RetRecAlways'},0,0,0);
	$hbox->pack_start($notebook->{'RetRecNever'},0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Mark messages as new if they were read on the server?"));
	$notebook->{'popalwaysnew'} = new Gtk::CheckButton;
	$notebook->{'popalwaysnew'}->set_usize(16,17);
	$notebook->{'popalwaysnew'}->set_active($main::prefs{'popalwaysnew'} eq "y");
	$hbox->pack_start($notebook->{'popalwaysnew'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Use Message Scoring System?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'Scoring'} = new Gtk::CheckButton();
	$notebook->{'Scoring'}->set_usize(16,17);
	$notebook->{'Scoring'}->set_active($main::prefs{'Scoring'} eq "y");
	$hbox->pack_start($notebook->{'Scoring'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("When importing mail, mark it as new?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'import'} = new Gtk::CheckButton();
	$notebook->{'import'}->set_usize(16,17);
	$notebook->{'import'}->set_active($main::prefs{'import'} eq "y");
	$hbox->pack_start($notebook->{'import'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Dupe check mails over all accounts?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'checkDupeOnAll'} = new Gtk::CheckButton();
	$notebook->{'checkDupeOnAll'}->set_usize(16,17);
	$notebook->{'checkDupeOnAll'}->set_active($main::prefs{'checkDupeOnAll'} eq "y");
	$hbox->pack_start($notebook->{'checkDupeOnAll'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Play sound if I have new mail?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'PlaySound'} = new Gtk::CheckButton();
	$notebook->{'PlaySound'}->set_usize(16,17);
	$notebook->{'PlaySound'}->set_active($main::prefs{'PlaySound'} eq "y");  
	$notebook->{'PlaySound'}->signal_connect("toggled", sub {
	    my $active = $notebook->{'PlaySound'}->active;
	    $notebook->{'SndCmd'}->set_sensitive($active);
	    $notebook->{'SndFl'}->set_sensitive($active);
	});
	$hbox->pack_start($notebook->{'PlaySound'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Sound Command:"));
	$label->set_usize(90,10);
	$label->set_alignment(0.0,0.5);
	$notebook->{'SndCmd'} = new Gtk::Entry;
	$notebook->{'SndCmd'}->set_usize(120,22);
	$notebook->{'SndCmd'}->set_text($main::prefs{'SndCmd'}||'');
	$notebook->{'SndCmd'}->set_sensitive($notebook->{'PlaySound'}->active);
	$hbox->pack_start($label,0,0,5);
	$hbox->pack_start($notebook->{'SndCmd'},0,0,5);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Sound File:"));
	$label->set_usize(90,10);
	$label->set_alignment(0.0,0.5);
	$notebook->{'SndFl'} = new Gtk::Entry;
	$notebook->{'SndFl'}->set_usize(200,22);
	$notebook->{'SndFl'}->set_text($main::prefs{'SndFl'}||'');
	$notebook->{'SndFl'}->set_sensitive($notebook->{'PlaySound'}->active);
	$hbox->pack_start($label,0,0,5);
	$hbox->pack_start($notebook->{'SndFl'},0,0,5);
	$vbox->pack_start($hbox,0,0,0);

	return $vbox;
}


sub init_view_config
{
    	my $notebook = shift;
	my $vbox = new Gtk::VBox(0,5);
	$vbox->set_border_width(5);

        my $hbox = new Gtk::HBox(0,5);
	my $label = new Gtk::Label(_("View"));
	$notebook->{'InlineImages'} = new Gtk::CheckButton();
	$notebook->{'InlineImages'}->set_active($main::prefs{'InlineImages'} eq "y");
	$notebook->{'InlineImages'}->set_usize(16,17);
	$label = new Gtk::Label(_("Display image attachments inline in the message view window?"));
	$label->set_alignment(0.0,0.5);
	$hbox->pack_start($notebook->{'InlineImages'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Display attachments inline in the message view window?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'InlineAttachments'} = new Gtk::CheckButton();
	$notebook->{'InlineAttachments'}->set_active($main::prefs{'InlineAttachments'} eq "y");
	$notebook->{'InlineAttachments'}->set_usize(16,17);
	$hbox->pack_start($notebook->{'InlineAttachments'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Display icons for attachments inline with the message view window?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'InlineIcons'} = new Gtk::CheckButton();
	$notebook->{'InlineIcons'}->set_active($main::prefs{'InlineIcons'} eq "y");
	$notebook->{'InlineIcons'}->set_usize(16,17);
	$hbox->pack_start($notebook->{'InlineIcons'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Deleting new messages marks them as read?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'DeleteMarksAsRead'} = new Gtk::CheckButton();
	$notebook->{'DeleteMarksAsRead'}->set_usize(16,17); 
	$notebook->{'DeleteMarksAsRead'}->set_active($main::prefs{'DeleteMarksAsRead'} eq "y");
	$hbox->pack_start($notebook->{'DeleteMarksAsRead'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Save window size on exit"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'saveSize'} = new Gtk::CheckButton();
	$notebook->{'saveSize'}->set_active($main::prefs{'saveSize'} eq "y");
	$notebook->{'saveSize'}->set_usize(16,17);
	$hbox->pack_start($notebook->{'saveSize'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Use Alternate Browser with GtkHTML/CscHTML"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'useAlternateViewer'} = new Gtk::CheckButton();
	$notebook->{'useAlternateViewer'}->set_active($main::prefs{'useAlternateViewer'} eq "y");
	$notebook->{'useAlternateViewer'}->set_usize(16,17);
	$hbox->pack_start($notebook->{'useAlternateViewer'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Left Click on Attachment opens Viewer instead of Save"));	
	$label->set_alignment(0.0,0.5);
	$notebook->{'attachLeftView'} = new Gtk::CheckButton();
	$notebook->{'attachLeftView'}->set_active($main::prefs{'attachLeftView'} eq "y");
	$notebook->{'attachLeftView'}->set_usize(16,17);
	$hbox->pack_start($notebook->{'attachLeftView'},0,0,0);
	$hbox->pack_start($label,0,0,0);         
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,0);
	$label = new Gtk::Label(_("Enable Tooltips?"));	
	$label->set_alignment(0.0,0.5);
	$notebook->{'ToolTips'} = new Gtk::CheckButton();
	$notebook->{'ToolTips'}->set_active($main::prefs{'ToolTips'} eq "y");
	$notebook->{'ToolTips'}->set_usize(16,17);
	$hbox->pack_start($notebook->{'ToolTips'},0,0,0);
	$hbox->pack_start($label,0,0,0);         
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Mark messages as read in viewpane after"));
	$label->set_alignment(0.0,0.5);
	$vbox->pack_start($label,0,0,5);
	$notebook->{'MarkAsReadDelay'} = new Gtk::Entry;
	$notebook->{'MarkAsReadDelay'}->set_editable('1');
	$notebook->{'MarkAsReadDelay'}->set_text($main::prefs{'MarkAsReadDelay'});
	$notebook->{'MarkAsReadDelay'}->set_usize(35,22);
	$label = new Gtk::Label(_("seconds."));
	$label->set_alignment(0.0,0.5);
	$hbox->pack_start($notebook->{'MarkAsReadDelay'},0,0,0);
	$hbox->pack_start($label,0,0,5);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Print Command"));
	$label->set_alignment(0.0,0.5);
	$label->set_usize(150,10);
	$notebook->{'PrintCommand'} = new Gtk::Entry;
	$notebook->{'PrintCommand'}->set_editable('1');
	$notebook->{'PrintCommand'}->set_text($main::prefs{'PrintCommand'});
	$notebook->{'PrintCommand'}->set_usize(170,20);
	$hbox->pack_start($label,0,0,0);
	$hbox->pack_start($notebook->{'PrintCommand'},0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Start in folder:"));
	$label->set_usize(150,10);
	$label->set_alignment(0.0,0.5);
	$notebook->{'startin'} = new Gtk::Combo;
	$notebook->{'startin'}->set_popdown_strings("None", keys(%main::foldernametoid));
	$notebook->{'startin'}->entry->set_text($main::prefs{'startin'});
	$hbox->pack_start($label,0,0,0);
	$hbox->pack_start($notebook->{'startin'},0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("On Folder Change, move to "));
	$label->set_alignment(0.0,0.5);
	$label->set_usize(150,10);
	$hbox->pack_start($label,0,0,0);
	$notebook->{'onfolderchange'} = new Gtk::Combo;
	$notebook->{'onfolderchange'}->set_popdown_strings("no","top","next unread");
	$notebook->{'onfolderchange'}->entry->set_text($main::prefs{'onfolderchange'});
	$label = new Gtk::Label(_(" message of folder"));
	$label->set_alignment(0.0,0.5);
	$hbox->pack_start($notebook->{'onfolderchange'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$label = new Gtk::Label(_("Date format: (%M = Month, %d = Day, %y = 2 digit Year, %Y = 4 digit year, %h = Hour, %m = Minute, %s = Second)"));
	$label->set_usize(400,38);
	$label->set_line_wrap(1);
	$label->set_alignment(0.0,0.5);
	$vbox->pack_start($label,0,0,0);
	$notebook->{'DateDisplayFormat'} =  new Gtk::Entry;
	$notebook->{'DateDisplayFormat'}->set_text($main::prefs{'DateDisplayFormat'});
	$notebook->{'DateDisplayFormat'}->set_editable('1');
	$notebook->{'DateDisplayFormat'}->set_usize(200,22);
	$vbox->pack_start($notebook->{'DateDisplayFormat'},0,0,0);

	return $vbox;
}

sub init_database_config
{
    	my $notebook = shift;
	my $vbox = new Gtk::VBox(0,5);
	$vbox->set_border_width(5);

        my $hbox = new Gtk::HBox(0,5);
	my $label = new Gtk::Label(_("Database Driver (CSV, Pg, mysql..)"));
	$label->set_usize(200,10);
	$label->set_alignment(0.0,0.5);
	$notebook->{'DatabaseDriver'} = new Gtk::Entry;
	$notebook->{'DatabaseDriver'}->set_editable('1');
	$notebook->{'DatabaseDriver'}->set_text($main::prefs{'DatabaseDriver'});
	$hbox->pack_start($label,0,0,5);
	$hbox->pack_start($notebook->{'DatabaseDriver'},0,0,5);
	$vbox->pack_start($hbox,0,0,0);
	my $mysql_driver = $main::prefs{'DatabaseDriver'} eq "mysql";
	my $pg_driver = $main::prefs{'DatabaseDriver'} eq "Pg";

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Database Username"));
	$label->set_usize(200,10);
	$label->set_alignment(0.0,0.5);
	$notebook->{'DatabaseUser'} = new Gtk::Entry;
	$notebook->{'DatabaseUser'}->set_editable('1');
	$notebook->{'DatabaseUser'}->set_text($main::prefs{'DatabaseUser'}||'');
	$hbox->pack_start($label,0,0,5);
	$hbox->pack_start($notebook->{'DatabaseUser'},0,0,5);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Database Username Password"));
	$label->set_usize(200,10);
	$label->set_alignment(0.0,0.5);
	$notebook->{'DatabasePassword'} = new Gtk::Entry;
	$notebook->{'DatabasePassword'}->set_editable('1');
	$notebook->{'DatabasePassword'}->set_visibility('0');
	$notebook->{'DatabasePassword'}->set_text($main::prefs{'DatabasePassword'}||'');
	$hbox->pack_start($label,0,0,5);
	$hbox->pack_start($notebook->{'DatabasePassword'},0,0,5);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Database Host"));
	$label->set_alignment(0.0,0.5);
	$label->set_usize(200,10);
	$notebook->{'DatabaseHost'} = new Gtk::Entry;
	$notebook->{'DatabaseHost'}->set_text($main::prefs{'DatabaseHost'}||'');
	$notebook->{'DatabaseHost'}->set_sensitive($mysql_driver);
	$hbox->pack_start($label,0,0,5);
	$hbox->pack_start($notebook->{'DatabaseHost'},0,0,5);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Database Port"));
	$label->set_alignment(0.0,0.5);
	$label->set_usize(200,10);
	$label->set_sensitive($mysql_driver);
	$notebook->{'MySQLPort'} = new Gtk::Entry;
	$notebook->{'MySQLPort'}->set_text($main::prefs{'MySQLPort'}||'') if $mysql_driver;
	$notebook->{'MySQLPort'}->set_text($main::prefs{'PgSQLPort'}||'') if $pg_driver;
	$notebook->{'MySQLPort'}->set_sensitive($mysql_driver||$pg_driver);
	$hbox->pack_start($label,0,0,5);
	$hbox->pack_start($notebook->{'MySQLPort'},0,0,5);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Store Messages in DB?"));
	$label->set_usize(200,10);
	$label->set_alignment(0.0,0.5);
	$label->set_sensitive($mysql_driver);
	$notebook->{'MsgInDB'} = new Gtk::CheckButton();
	$notebook->{'MsgInDB'}->set_active($main::prefs{'MsgInDB'} eq "y");
	$notebook->{'MsgInDB'}->set_sensitive($mysql_driver);
	$hbox->pack_start($notebook->{'MsgInDB'},0,0,5);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Empty the contents of Deleted Items on exit?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'empty_trash_on_exit'} = new Gtk::CheckButton();
	$notebook->{'empty_trash_on_exit'}->set_active($main::prefs{'empty_trash_on_exit'});
	$hbox->pack_start($notebook->{'empty_trash_on_exit'},0,0,5);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	if ($main::prefs{'DatabaseDriver'} eq "CSV") {
		$notebook->{'DatabaseHost'}->set_sensitive(0);
		$notebook->{'MsgInDB'}->set_sensitive(0);
		$notebook->{'MySQLPort'}->set_sensitive(0);
	}	
	
	return $vbox;
}
	
sub init_fonts_config
{
    	my $notebook = shift;
	my $vbox = new Gtk::VBox(0,5);
	$vbox->set_border_width(5);
	my $is_CscHTML = $main::HTMLWIDGET eq "CscHTML";

        my $hbox = new Gtk::HBox(0,5);
	my $label = new Gtk::Label(_("Change Message Font if it's new?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'BoldMsg'} = new Gtk::CheckButton();
	$notebook->{'BoldMsg'}->set_active($main::prefs{'BoldMsg'}); 
	$hbox->pack_start($notebook->{'BoldMsg'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Change folder font if it contains new mail?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'FolderNewBold'} = new Gtk::CheckButton();
	$notebook->{'FolderNewBold'}->set_active($main::prefs{'FolderNewBold'} eq "y");
	$notebook->{'FolderNewBold'}->set_usize(16,17);
	$hbox->pack_start($notebook->{'FolderNewBold'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$label = new Gtk::Label(_("Font used for new items:"));
	$label->set_alignment(0.0,0.5);
	$vbox->pack_start($label,0,0,5);
        $hbox = new Gtk::HBox(0,5);
	$notebook->{'FontMLBold'} = new Gtk::Entry;
	$notebook->{'FontMLBold'}->set_editable('0');
	$notebook->{'FontMLBold'}->set_text($main::prefs{'FontMLBold'});
	my $button = new Gtk::Button(_("Change"));
	$button->signal_connect("clicked" => \&init_font_dlg, $notebook->{'FontMLBold'});
	$button->set_usize(55,25);
	$hbox->pack_start($notebook->{'FontMLBold'},1,1,5);
	$hbox->pack_end($button,0,0,5);
	$vbox->pack_start($hbox,0,0,0);

	$label = new Gtk::Label(_("Font used for normal items:"));
	$label->set_alignment(0.0,0.5);
	$vbox->pack_start($label,0,0,5);
        $hbox = new Gtk::HBox(0,5);
	$notebook->{'FontMLNormal'} = new Gtk::Entry;
	$notebook->{'FontMLNormal'}->set_editable('0');
	$notebook->{'FontMLNormal'}->set_text($main::prefs{'FontMLNormal'});
	$button = new Gtk::Button(_("Change"));
	$button->signal_connect("clicked" => \&init_font_dlg, $notebook->{'FontMLNormal'});
	$button->set_usize(55,25);
	$hbox->pack_start($notebook->{'FontMLNormal'},1,1,5);
	$hbox->pack_end($button,0,0,5);
	$vbox->pack_start($hbox,0,0,0);

	$label = new Gtk::Label(_("Font used to display messages (CscHTML only):"));
	$label->set_alignment(0.0,0.5);
	$vbox->pack_start($label,0,0,5);
        $hbox = new Gtk::HBox(0,5);
	$notebook->{'FontMessages'} = new Gtk::Entry;
	$notebook->{'FontMessages'}->set_text($main::prefs{'FontMessages'});
	$notebook->{'FontMessages'}->set_editable('0');
	$notebook->{'FontMessages'}->set_sensitive($is_CscHTML);
	$button = new Gtk::Button(_("Change"));
	$button->signal_connect("clicked" => \&init_font_dlg, $notebook->{'FontMessages'});
	$button->set_usize(55,25);
	$button->set_sensitive($is_CscHTML);
	$hbox->pack_start($notebook->{'FontMessages'},1,1,5);
	$hbox->pack_end($button,0,0,5);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Allow messages to switch fonts?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'FontSwitch'} = new Gtk::CheckButton;
	$notebook->{'FontSwitch'}->set_usize(16,17);
	$notebook->{'FontSwitch'}->set_active($main::prefs{'FontSwitch'});
	$notebook->{'FontSwitch'}->set_sensitive($is_CscHTML);
	$hbox->pack_start($notebook->{'FontSwitch'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$label = new Gtk::Label(_("Font used for labels in the Header Panel:"));
	$label->set_alignment(0.0,0.5);
	$vbox->pack_start($label,0,0,5);
        $hbox = new Gtk::HBox(0,5);
	$notebook->{'FontUIBold'} = new Gtk::Entry;
	$notebook->{'FontUIBold'}->set_editable('0');
	$notebook->{'FontUIBold'}->set_text($main::prefs{'FontUIBold'});
	$button = new Gtk::Button(_("Change"));
	$button->signal_connect("clicked" => \&init_font_dlg, $notebook->{'FontUIBold'});
	$button->set_usize(55,25);
	$hbox->pack_start($notebook->{'FontUIBold'},1,1,5);
	$hbox->pack_end($button,0,0,5);
	$vbox->pack_start($hbox,0,0,0);

        $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Use my Gtk font in the composer window"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'useGtkFontComposer'} = new Gtk::CheckButton;
	$notebook->{'useGtkFontComposer'}->set_usize(16,17);
	$notebook->{'useGtkFontComposer'}->set_active($main::prefs{'useGtkFontComposer'} eq "y"); 
	$hbox->pack_start($notebook->{'useGtkFontComposer'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);
	my $use_Gtk_font = $notebook->{'useGtkFontComposer'}->active;

	$label = new Gtk::Label(_("Font used for the Message Composer:"));
	$label->set_alignment(0.0,0.5);
	$vbox->pack_start($label,0,0,5);
        $hbox = new Gtk::HBox(0,5);
	$notebook->{'FontComposer'} = new Gtk::Entry;
	$notebook->{'FontComposer'}->set_editable(0);
	$notebook->{'FontComposer'}->set_text($main::prefs{'FontComposer'});
	$notebook->{'FontComposer'}->set_sensitive($use_Gtk_font);
	$button = new Gtk::Button(_("Change"));
	$button->signal_connect("clicked" => \&init_font_dlg, $notebook->{'FontComposer'});
	$button->set_usize(55,25);
	$button->set_sensitive($use_Gtk_font);
	$hbox->pack_start($notebook->{'FontComposer'},1,1,5);
	$hbox->pack_end($button,0,0,5);
	$vbox->pack_start($hbox,0,0,0);

	# Must wait till now to connect this signal, because only now do we
	# have the button that must be enabled/disabled.
	$notebook->{'useGtkFontComposer'}->signal_connect("toggled", sub {
	    my $active = $notebook->{'useGtkFontComposer'}->active;
	    $notebook->{'FontComposer'}->set_sensitive($active); 
	    $button->set_sensitive($active);
	});

	return $vbox;
}


sub init_paths_config
{
    	my $notebook = shift;
	my $vbox = new Gtk::VBox(0,5);
	$vbox->set_border_width(5);

	my $label = new Gtk::Label(_("Ispell or Aspell Path:"));
	$label->set_alignment(0.0,0.5);
	$vbox->pack_start($label,0,0,5);
        my $hbox = new Gtk::HBox(0,5);

	$notebook->{'ispellpath'} = new Gtk::Entry;
	$notebook->{'ispellpath'}->set_text($main::prefs{'ispellpath'});
	my $button = new Gtk::Button(_("Browse"));
	$button->signal_connect("clicked" => \&init_browse_dlg, $notebook->{'ispellpath'}, "ispell_path");
	$button->set_usize(55,25);
	$hbox->pack_start($notebook->{'ispellpath'},1,1,5);
	$hbox->pack_end($button,0,0,5);
	$vbox->pack_start($hbox,0,0,0);

	$label = new Gtk::Label(_("Path to URL Viewer (XmHTML and Alternate Viewer for GtkHTML/CscHTML):"));
	$label->set_alignment(0.0,0.5);
	$vbox->pack_start($label,0,0,5);
        $hbox = new Gtk::HBox(0,5);
	$notebook->{'ViewerPath'} = new Gtk::Entry;
	$notebook->{'ViewerPath'}->set_text($main::prefs{'ViewerPath'});
	$button = new Gtk::Button(_("Browse"));
	$button->signal_connect("clicked" => \&init_browse_dlg, $notebook->{'ViewerPath'}, "viewer_path");
	$button->set_usize(55,25);
	$hbox->pack_start($notebook->{'ViewerPath'},1,1,5);
	$hbox->pack_end($button,0,0,5);
	$vbox->pack_start($hbox,0,0,0);

	$label = new Gtk::Label(_("Path to GPG:"));
	$label->set_alignment(0.0,0.5);
	$vbox->pack_start($label,0,0,5);
        $hbox = new Gtk::HBox(0,5);
	$notebook->{'gpgpath'} = new Gtk::Entry;
	$notebook->{'gpgpath'}->set_text($main::prefs{'gpgpath'});
	$button = new Gtk::Button(_("Browse"));
	$button->signal_connect("clicked" => \&init_browse_dlg, $notebook->{'gpgpath'}, "gpg_path");
	$button->set_usize(55,25);
	$hbox->pack_start($notebook->{'gpgpath'},1,1,5);
	$hbox->pack_end($button,0,0,5);
	$vbox->pack_start($hbox,0,0,0);

	return $vbox;
}


sub init_web_browser_config
{
    	my $notebook = shift;
	my $vbox = new Gtk::VBox(0,5);
	$vbox->set_border_width(5);

	my $hbox = new Gtk::HBox(0,5);
	my $label = new Gtk::Label(_("Homepage"));
	$label->set_usize(90,10);
	$label->set_alignment(0.0,0.5);
	$notebook->{'HomePage'} =  new Gtk::Entry;
	$notebook->{'HomePage'}->set_text($main::prefs{'HomePage'}||'');
	$notebook->{'HomePage'}->set_usize(250,22);
	$hbox->pack_start($label,0,0,5);
	$hbox->pack_start($notebook->{'HomePage'},0,0,5);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label=new Gtk::Label(_("Proxy Server"));
	$label->set_usize(90,10);
	$label->set_alignment(0.0,0.5);
	$notebook->{'Proxy'} = new Gtk::Entry;
	$notebook->{'Proxy'}->set_usize(250,22);
	$notebook->{'Proxy'}->set_text($main::prefs{'Proxy'}||'');
	$hbox->pack_start($label,0,0,5);
	$hbox->pack_start($notebook->{'Proxy'},0,0,5);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label=new Gtk::Label(_("Proxy Port"));
	$label->set_usize(90,10);
	$label->set_alignment(0.0,0.5);
	$notebook->{'ProxyPort'} = new Gtk::Entry;
	$notebook->{'ProxyPort'}->set_usize(50,22);
	$notebook->{'ProxyPort'}->set_text($main::prefs{'ProxyPort'}||'');
	$hbox->pack_start($label,0,0,5);
	$hbox->pack_start($notebook->{'ProxyPort'},0,0,5);
	$vbox->pack_start($hbox,0,0,0);

	return $vbox;
}


sub init_message_colors_config
{
    	my $notebook = shift;
	my $vbox = new Gtk::VBox(0,5);
	$vbox->set_border_width(5);
	my $is_text_widget = $main::HTMLWIDGET eq "text";

	my $hbox = new Gtk::HBox(0,5);
	my $label = new Gtk::Label(_("Colorize Messages?"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'msgcolors'} = new Gtk::CheckButton;
	$notebook->{'msgcolors'}->set_usize(16,17);
	$notebook->{'msgcolors'}->set_active($main::prefs{'UseMessageColors'} eq "y");
	$hbox->pack_start($notebook->{'msgcolors'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Don't colorize Messages bigger than  "));
	$hbox->pack_start($label,0,0,0);
	$notebook->{'MaxLength'} = new Gtk::Entry;
	$notebook->{'MaxLength'}->set_usize(60,22);
	$notebook->{'MaxLength'}->set_text($main::prefs{'UseMessageColorsMaxLength'});
	$label = new Gtk::Label(_(" chars ..."));
	$hbox->pack_start($notebook->{'MaxLength'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Color replies based on these symbols, seperate by commas."));
	$label->set_alignment(0.0,0.5);
	$notebook->{'QuoteSymbol'} = new Gtk::Entry;
	$notebook->{'QuoteSymbol'}->set_usize(60,22);
	$notebook->{'QuoteSymbol'}->set_text($main::prefs{'QuoteSymbols'});
	$notebook->{'QuoteSymbol'}->set_editable(1);
	$hbox->pack_start($label,0,0,0);
	$hbox->pack_start($notebook->{'QuoteSymbol'},0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Use this symbol instead of the  subjects in  threads when I have it turned on."));
	$label->set_alignment(0.0,0.5);
	$notebook->{'threadarrow'} = new Gtk::Entry;
	$notebook->{'threadarrow'}->set_text($main::prefs{'threadarrow'});
	$notebook->{'threadarrow'}->set_usize(40,22);
	$hbox->pack_start($label,0,0,0);
	$hbox->pack_start($notebook->{'threadarrow'},0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Message Color "));
	$label->set_alignment(0.0,0.5);
	$label->set_usize(80,10);
	$notebook->{'MessageColor'} = new Gtk::Entry;
	$notebook->{'MessageColor'}->set_editable(1);
	$notebook->{'MessageColor'}->set_text($main::prefs{'MessageColor'});
	$notebook->{'MessageColor'}->set_usize(60,22);
	my $change_button = new Gtk::Button(_("Change"));
	$change_button->signal_connect("clicked" => \&select_color, $notebook->{'MessageColor'}, "message");
	my $default_button = new Gtk::Button(_("Default"));
	$default_button->signal_connect("clicked", sub { $notebook->{'MessageColor'}->set_text("000000")});
	$hbox->pack_start($label,0,0,0);
	$hbox->pack_start($notebook->{'MessageColor'},0,0,0);
	$hbox->pack_start($change_button,0,0,0);
	$hbox->pack_start($default_button,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label= new Gtk::Label(_("Quote Color 1"));
	$label->set_alignment(0.0,0.5);
	$label->set_usize(80,10);
	$notebook->{'QuoteColor1'} = new Gtk::Entry;
	$notebook->{'QuoteColor1'}->set_text($main::prefs{'QuoteColor1'});
	$notebook->{'QuoteColor1'}->set_usize(60,22);
	$notebook->{'QuoteColor1'}->set_editable(1);
	$change_button = new Gtk::Button(_("Change"));
	$change_button->signal_connect("clicked" => \&select_color, $notebook->{'QuoteColor1'}, "quote1");
	$default_button = new Gtk::Button(_("Default"));
	$default_button->signal_connect("clicked", sub { $notebook->{'QuoteColor1'}->set_text("FF0000");});
	$hbox->pack_start($label,0,0,0);
	$hbox->pack_start($notebook->{'QuoteColor1'},0,0,0);
	$hbox->pack_start($change_button,0,0,0);
	$hbox->pack_start($default_button,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label= new Gtk::Label(_("Quote Color 2"));
	$label->set_alignment(0.0,0.5);
	$label->set_usize(80,10);
	$notebook->{'QuoteColor2'} = new Gtk::Entry;
	$notebook->{'QuoteColor2'}->set_text($main::prefs{'QuoteColor2'});
	$notebook->{'QuoteColor2'}->set_usize(60,22);
	$notebook->{'QuoteColor2'}->set_editable(1);
	$change_button = new Gtk::Button(_("Change"));
	$change_button->signal_connect("clicked" => \&select_color, $notebook->{'QuoteColor2'}, "quote2");
	$default_button = new Gtk::Button(_("Default"));
	$default_button->signal_connect("clicked", sub { $notebook->{'QuoteColor2'}->set_text("0000FF");});
	$hbox->pack_start($label,0,0,0);
	$hbox->pack_start($notebook->{'QuoteColor2'},0,0,0);
	$hbox->pack_start($change_button,0,0,0);
	$hbox->pack_start($default_button,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label= new Gtk::Label(_("Quote Color 3"));
	$label->set_usize(80,10);
	$label->set_alignment(0.0,0.5);
	$notebook->{'QuoteColor3'} = new Gtk::Entry;
	$notebook->{'QuoteColor3'}->set_text($main::prefs{'QuoteColor3'});
	$notebook->{'QuoteColor3'}->set_usize(60,22);
	$notebook->{'QuoteColor3'}->set_editable(1);
	$change_button = new Gtk::Button(_("Change"));
	$change_button->signal_connect("clicked" => \&select_color, $notebook->{'QuoteColor3'}, "quote3");
	$default_button = new Gtk::Button(_("Default"));
	$default_button->signal_connect("clicked", sub { $notebook->{'QuoteColor3'}->set_text("FF00FF");});
	$hbox->pack_start($label,0,0,0);
	$hbox->pack_start($notebook->{'QuoteColor3'},0,0,0);
	$hbox->pack_start($change_button,0,0,0);
	$hbox->pack_start($default_button,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Body Color"));
	$label->set_alignment(0.0,0.5);
	$label->set_usize(80,10);
	$notebook->{'MessageBgColor'} = new Gtk::Entry;
	$notebook->{'MessageBgColor'}->set_editable(1);
	$notebook->{'MessageBgColor'}->set_text($main::prefs{'MessageBgColor'});
	$notebook->{'MessageBgColor'}->set_usize(60,22);
	$notebook->{'MessageBgColor'}->set_sensitive(!$is_text_widget);
	$change_button = new Gtk::Button(_("Change"));
	$change_button->signal_connect("clicked" => \&select_color, $notebook->{'MessageBgColor'}, "bg");
	$change_button->set_sensitive(!$is_text_widget);
	$default_button = new Gtk::Button(_("Default"));
	$default_button->signal_connect("clicked", sub { $notebook->{'MessageBgColor'}->set_text("FFFFFF");});
	$default_button->set_sensitive(!$is_text_widget);
	$hbox->pack_start($label,0,0,0);
	$hbox->pack_start($notebook->{'MessageBgColor'},0,0,0);
	$hbox->pack_start($change_button,0,0,0);
	$hbox->pack_start($default_button,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	return $vbox;
}


sub init_HTML_config
{
    	my $notebook = shift;
	my $vbox = new Gtk::VBox(0,5);
	$vbox->set_border_width(5);

	my $hbox = new Gtk::HBox(0,5);
	my $label = new Gtk::Label(_("Don't use an HTML Widget to display mail"));
	$label->set_alignment(0.0,0.5);
	$notebook->{'NoHTML'} = new Gtk::CheckButton;
	$notebook->{'NoHTML'}->set_usize(16,17);
	$notebook->{'NoHTML'}->set_active($main::prefs{'NoHTML'} eq "y");
	$hbox->pack_start($notebook->{'NoHTML'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);
	$label = new Gtk::Label(
_("If you check this button, Pronto will not use an HTML widget to display your
mail. Such widgets are GtkHTML and GtkXmHTML. Regardless, if you uncheck this 
button and you do not have an appropriate HTML widget installed Pronto will
fall back to the regular text widget. However, if an HTML widget is found, the 
order of fall back is CscHTML, GtkHTML, GtkXmHTML or if neither then GtkText. You should
understand that activating this option means that you will not be able to 
utilize some of  Pronto's functions such as displaying image attachments 
inline. Clickable URL's are supported with the right mouse button in this widget
instead of left to allow for uninterrupted selection."));
	$label->set_justify('left');
	$label->set_alignment(0.0,0.5);
	$vbox->pack_start($label,0,0,0);

	return $vbox;
}
	

sub init_advanced_config
{
    	my $notebook = shift;
	my $vbox = new Gtk::VBox(0,5);
	$vbox->set_border_width(5);

	my $label = new Gtk::Label(_("These options are only for advanced users if you dont know what they mean, you are better off leaving them on the defaults\n\n"));
	$label->set_line_wrap(1);
	$label->set_alignment(0.0,0.5);
	$vbox->pack_start($label,0,0,0);
	
	my $hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Character set: "));
	$label->set_alignment(0.0,0.5);
	$notebook->{'CharSet'} = new Gtk::Entry;
	$notebook->{'CharSet'}->set_text($main::prefs{'CharSet'});
	$hbox->pack_start($label,0,0,0);
	$hbox->pack_start($notebook->{'CharSet'},0,0,0);
	$vbox->pack_start($hbox,0,0,0);
	
	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Include a reply-to header?"));
	$notebook->{'IncludeReplyTo'} = new Gtk::CheckButton();
	$notebook->{'IncludeReplyTo'}->set_active($main::prefs{'IncludeReplyTo'});
	$hbox->pack_start($notebook->{'IncludeReplyTo'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Don't show a splash screen on startup"));
	$notebook->{'Splash'} = new Gtk::CheckButton();
	$notebook->{'Splash'}->set_active(!$main::prefs{'Splash'});
	$hbox->pack_start($notebook->{'Splash'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Remove signature of sender on reply"));
	$notebook->{'SliceSig'} = new Gtk::CheckButton();
	$notebook->{'SliceSig'}->set_active($main::prefs{'SliceSig'});
	$hbox->pack_start($notebook->{'SliceSig'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);
	
	$hbox = new Gtk::HBox(0,5);
	$label = new Gtk::Label(_("Enable Drag and Drop (Enabling Drag and Drop disables FolderTree reording)"));
 	$notebook->{'Drag'} = new Gtk::CheckButton();
 	$notebook->{'Drag'}->set_active($main::prefs{'Drag'});
	$hbox->pack_start($notebook->{'Drag'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$hbox = new Gtk::HBox(0,0);
	$label = new Gtk::Label(_("Auto save compose sessions?"));
 	$notebook->{'autosave'} = new Gtk::CheckButton();
 	$notebook->{'autosave'}->set_active($main::prefs{'autosave'});
	$hbox->pack_start($notebook->{'autosave'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);
	
	$label = new Gtk::Label(_("Enable Undo?"));
	$hbox = new Gtk::HBox(0,0);
	$notebook->{'Undo'} = new Gtk::CheckButton();
	$notebook->{'Undo'}->set_active($main::prefs{'UndoEnabled'});
	$hbox->pack_start($notebook->{'Undo'},0,0,0);
	$hbox->pack_start($label,0,0,0);
	$vbox->pack_start($hbox,0,0,0);
	
	return $vbox;
}

sub init_toolbar_config
{
	my $notebook = shift;
	my $vbox = new Gtk::VBox(0,5);
	$vbox->set_border_width(5);
	my $hbox = new Gtk::HBox(0,5);
	my $apply = new Gtk::Button(_("Apply ..."));
	my $label = new Gtk::Label(_("Which Buttons should appear in Pronto's toolbar"));
	$vbox->pack_start($label, 0, 0, 5);
	my @buttons = (["ButtonNew",_("New")],
		       ["ButtonReply",_("Reply")],
		       ["ButtonReplyAll",_("Reply All")],
		       ["ButtonForward",_("Forward")],
		       ["ButtonDelete",_("Delete")],
		       ["ButtonSAndR",_("Send & Receive")],
		       ["ButtonAddyBook",_("AddressBook")]);		       
	foreach my $button (@buttons) {		       
		$notebook->{@{$button}[0]} = new Gtk::ToggleButton(@{$button}[1]);
		$notebook->{@{$button}[0]}->set_active($main::prefs{@{$button}[0]});
		$notebook->{@{$button}[0]}->signal_connect("toggled",\&toggle_toolbar_button, @{$button}[0]);
		$hbox->pack_start($notebook->{@{$button}[0]},0,0,0);
		
	}
	$vbox->pack_start($hbox,0,0,5);
	$vbox->pack_start($apply,0,0,5);
	$apply->signal_connect("clicked", sub { 
		\&Pronto::MainWindow::create_toolbar(undef,
		$main::root_window->{'toolbar'},
		$main::root_window->window,
		$main::root_window->style->bg('normal'),
		$main::message_clist,
		$main::root_window->{'attbtn'},
		$main::root_window->{'button_pixmap'},
		$main::root_window->{'button_mask'},
		$main::prefs{'PixmapDir'},
		"recreate");		
		});
	return $vbox;
}	

sub toggle_toolbar_button
{
	my ($button,$name) = @_;
	$main::prefs{$name} = $button->active();
}

sub init_config {
	
	if ($ConfigOpened) { 
		if (defined $ConfigWindow) {
			$ConfigWindow->raise();
			return;
		}
	}	
		
	my ($main, $notebook);
	my @node_names = (_("Send"), _("Receive"), _("View"), _("ToolBar"),
			  _("Database"), _("Fonts"), _("Paths"), _("Web Browser"), 
			  _("Message Colors"), _("HTML"), _("Advanced"));
	my @pages = (\&init_send_config, \&init_receive_config, \&init_view_config,
		     \&init_toolbar_config,
		     \&init_database_config, \&init_fonts_config, \&init_paths_config,
		     \&init_web_browser_config, \&init_message_colors_config,
		     \&init_HTML_config, \&init_advanced_config);

	$main = new Gtk::Window("toplevel");
	$main->set_title(_("Pronto Configuration"));
	$main->set_default_size(&main::get_win_size("config",500,330));
	$main->position(-mouse);
	$main->signal_connect("destroy" => sub {$main->destroy;$ConfigOpened=0;});
	$main->signal_connect("delete_event" => \&Gtk::false);
	$notebook = new Gtk::Notebook;
	$notebook->set_show_tabs(0);
	my $ctree = new_with_titles Gtk::CTree(0,("Pronto!"));
	$ctree->set_usize(120,0);

	foreach my $i (0..$#node_names) {
	    $notebook->append_page(&{$pages[$i]}($notebook), new Gtk::Label($node_names[$i]));

	    my $node = $ctree->insert_node(undef,undef,[$node_names[$i]],5,undef,undef,undef,undef,0,1);
	    $ctree->node_set_row_data($node, \$i);
	}	
	$ctree->set_selection_mode("browse");
	$ctree->signal_connect("tree_select_row", \&switch_page, $notebook);

	my $vbox= new Gtk::VBox(0,5);
	$vbox->set_border_width(5);

	my $hbox = new Gtk::HBox(0,0);
	$hbox->pack_start($ctree,1,1,0);
	$hbox->pack_start($notebook,1,1,0);
	$vbox->pack_start($hbox,0,0,0);
	
	$hbox = new Gtk::HBox(0,5);
	my $button = new Gtk::Button(_("OK"));
	$button->set_usize(55,25);
	$button->signal_connect("clicked" => \&update_conf, $main, $notebook);
	$hbox->pack_start($button,1,0,0);

	$button = new Gtk::Button(_("Apply"));
	$button->set_usize(55,25);
	$button->signal_connect("clicked" =>\&update_conf, $main, $notebook,"apply");	
	$hbox->pack_start($button,1,0,0);

	$button = new Gtk::Button(_("Cancel"));
	$button->signal_connect("clicked", sub {$main->destroy;});
	$button->set_usize(55,25);
	$hbox->pack_start($button,1,0,0);

	$button = new Gtk::Button(_("Help"));
	$button->signal_connect("clicked" => \&Pronto::Help::help_win, "option.html" );
	$button->set_usize(55,25);
	$hbox->pack_start($button,1,0,0);
	$vbox->pack_start($hbox,0,0,0);

	$main->add($vbox);
	
	show_all $main;
	$main->signal_connect("size-request" => \&main::save_win_size, "config", $main->window);
	$ConfigWindow = $main->window;
	$ConfigOpened=1;
	return 1;
}

sub switch_page
{
	my ($ctree,$notebook,$node,$col) = @_;
	my $data = ${$ctree->node_get_row_data($node)};
	$notebook->set_page($data);
	return 1;
}	

sub select_color {
	my ($widget, $entry, $name) = @_;
	my ($dialog,$colorsel);
	if ($name eq "quote1") {
		$dialog = new Gtk::ColorSelectionDialog(_("Select Quote Color 1"));
	}
	if ($name eq "quote2") {
		$dialog = new Gtk::ColorSelectionDialog(_("Select Quote Color 2"));
	}
	if ($name eq "quote3") {
		$dialog = new Gtk::ColorSelectionDialog(_("Select Quote Color 3"));
	}
	if ($name eq "message") {
		$dialog = new Gtk::ColorSelectionDialog(_("Select Message text Color"));
	}
	if ($name eq "bg") {
		$dialog = new Gtk::ColorSelectionDialog(_("Select Body Background Color"));
	}
	$dialog->show;
	$colorsel = $dialog->colorsel;
	$dialog->signal_connect("destroy", sub { $dialog->destroy; });
	$dialog->signal_connect("delete_event" => \&Gtk::false);
	$dialog->ok_button->signal_connect("clicked", sub { $dialog->destroy; });
	$dialog->cancel_button->signal_connect("clicked", sub { 
                                        if ($name eq "quote1") {
						$entry->set_text($main::prefs{'QuoteColor1'})
					}
					
					if ($name eq "quote2") {
                	                        $entry->set_text($main::prefs{'QuoteColor2'})
                                        }

					if ($name eq "quote3") {
                        	                $entry->set_text($main::prefs{'QuoteColor3'})
                                        }
					
					if ($name eq "message") {
						$entry->set_text($main::prefs{'MessageColor'})
					}
					
					if ($name eq "bg") {
						$entry->set_text($main::prefs{'MessageBgColor'});
					}
					
                                        $dialog->destroy;});
	$colorsel->signal_connect("color_changed", sub { 
             
				     my @color=$colorsel->get_color();
				     my ($red, $green, $blue, $gdk_color);
	     

    		        	     $gdk_color->{ 'red' } = $color[0] * 65535.0;
    				     $gdk_color->{ 'green' } = $color[1] * 65535.0;
    				     $gdk_color->{ 'blue' } = $color[2] * 65535.0;
	    
          			     # Convert to HTML format
          			     $red = $gdk_color->{ 'red' } / 256;
          			     $green = $gdk_color->{ 'green' } / 256;
          			     $blue = $gdk_color->{ 'blue' } / 256;
			    
			             $red = uc( sprintf( "%lx", $red ) );
	                             $green = uc( sprintf( "%lx", $green ) );
          			     $blue = uc( sprintf( "%lx", $blue ) );
					
	                             $red = "0" . $red if ( $red =~ /^\d$/ );
          			     $green = "0" . $green if ( $green =~ /^\d$/ );
	  			     $blue = "0" . $blue if ( $blue =~ /^\d$/ );
						    
          		             $entry->set_text($red.$green.$blue);});
}
								      
sub update_conf {

	my ($widget, $window, $notebook,$apply) = @_;
	my $remade_layout = 0;
	$main::prefs{'SigCmd'} = $notebook->{'SigCmd'}->get_text;
	$main::prefs{'AutoCheckTime'} = $notebook->{'AutoCheckTime'}->get_text;
	$main::prefs{'MaxFetchSize'} = $notebook->{'MaxFetchSize'}->get_text;
	$main::prefs{'MarkAsReadDelay'} = $notebook->{'MarkAsReadDelay'}->get_text;
	$main::prefs{'DatabaseDriver'} = $notebook->{'DatabaseDriver'}->get_text;
	$main::prefs{'DatabaseUser'} = $notebook->{'DatabaseUser'}->get_text;
	$main::prefs{'DatabasePassword'} = $notebook->{'DatabasePassword'}->get_text;
	$main::prefs{'DatabaseHost'} = $notebook->{'DatabaseHost'}->get_text;
	$main::prefs{'MySQLPort'} = $notebook->{'MySQLPort'}->get_text if ($main::prefs{'DatabaseDriver'} eq "mysql");
	$main::prefs{'PgSQLPort'} = $notebook->{'MySQLPort'}->get_text if ($main::prefs{'DatabaseDriver'} eq "Pg");
	$main::prefs{'DateDisplayFormat'} = $notebook->{'DateDisplayFormat'}->get_text;
	($main::prefs{'QuoteHeader'} = $notebook->{'QuoteHeader'}->get_chars(0,-1)) =~ s/\n/*n/g;
	$main::prefs{'QuoteWith'} = $notebook->{'QuoteWith'}->get_text;
	$main::prefs{'HomePage'} = $notebook->{'HomePage'}->get_text;
	$main::prefs{'FontMLBold'} = $notebook->{'FontMLBold'}->get_text;
	$main::prefs{'FontMLNormal'} = $notebook->{'FontMLNormal'}->get_text;
	$main::prefs{'FontMessages'} = $notebook->{'FontMessages'}->get_text;
	$main::prefs{'UseMessageColorsMaxLength'} = $notebook->{'MaxLength'}->get_text;
	$main::prefs{'threadarrow'} = $notebook->{'threadarrow'}->get_text;
	$main::prefs{'CharSet'} = $notebook->{'CharSet'}->get_text;
	my @fields = split /-/, $main::prefs{'FontMessages'};
	$main::prefs{'MsgFontFace'} = $fields[2];
	if ($notebook->{'FontSwitch'}->active) { $main::prefs{'FontSwitch'} = 1 } else { $main::prefs{'FontSwitch'} = 0 }
	if ($notebook->{'IncludeReplyTo'}->active) { $main::prefs{'IncludeReplyTo'} = 1; } else { $main::prefs{'IncludeReplyTo'} = 0; }
	if ($notebook->{'POP3Verbose'}->active) { $main::prefs{'POP3Verbose'} = 1; } else { $main::prefs{'POP3Verbose'} = 0; }
	if ($main::HTMLWIDGET eq "CscHTML") {
		$main::root_window->{'html_view'}->set_default_font_face($main::prefs{'MsgFontFace'});
		$main::root_window->{'html_view'}->allow_font_switch($main::prefs{'FontSwitch'});
		if (defined $main::view_window and $main::prefs{'viewpane'} eq "n") {
			$main::view_window->{'html'}->set_default_font_face($main::prefs{'MsgFontFace'});
			$main::view_window->{'html'}->allow_font_switch($main::prefs{'FontSwitch'});
		}
	}
	if ($notebook->{'ToolTips'}->active) {
		$main::root_window->{'toolbar'}->set_tooltips(1);
		$main::prefs{'ToolTips'} = 1;
	} else {
		$main::root_window->{'toolbar'}->set_tooltips(0);
		$main::prefs{'ToolTips'} = 0;
	}	
	$main::prefs{'FontUIBold'} = $notebook->{'FontUIBold'}->get_text;
	$main::prefs{'FontComposer'} = $notebook->{'FontComposer'}->get_text;
	$main::prefs{'WrapAfter'} = $notebook->{'WrapAfter'}->get_text;
	$main::prefs{'ViewerPath'} = $notebook->{'ViewerPath'}->get_text;
	$main::prefs{'gpgpath'} = $notebook->{'gpgpath'}->get_text;
	$main::prefs{'PrintCommand'} = $notebook->{'PrintCommand'}->get_text;
	$main::prefs{'Proxy'} = $notebook->{'Proxy'}->get_text;
	$main::prefs{'ProxyPort'} = $notebook->{'ProxyPort'}->get_text;
	$main::prefs{'SndCmd'} = $notebook->{'SndCmd'}->get_text;
	$main::prefs{'SndFl'} = $notebook->{'SndFl'}->get_text;
	$main::prefs{'ispellpath'} = $notebook->{'ispellpath'}->get_text;
	$main::prefs{'QuoteSymbols'} = $notebook->{'QuoteSymbol'}->get_text;
	$main::prefs{'MessageColor'} = $notebook->{'MessageColor'}->get_text;
	$main::prefs{'QuoteColor1'} = $notebook->{'QuoteColor1'}->get_text;
	$main::prefs{'QuoteColor2'} = $notebook->{'QuoteColor2'}->get_text;
	$main::prefs{'QuoteColor3'} = $notebook->{'QuoteColor3'}->get_text;
	$main::prefs{'MessageBgColor'} = $notebook->{'MessageBgColor'}->get_text;
	$main::prefs{'startin'} = $notebook->{'startin'}->entry->get_text;
	$main::prefs{'onfolderchange'} = $notebook->{'onfolderchange'}->entry->get_text;
	if($notebook->{'AutoCheckProgress'}->active) { $main::prefs{'AutoCheckProgress'} = 1 } else { $main::prefs{'AutoCheckProgress'} = 0 }
	if ($notebook->{'Undo'}->active) { $main::prefs{'UndoEnabled'} = 1; } else { $main::prefs{'UndoEnabled'} = 0; }
	if($notebook->{'RetRecAsk'}->active){$main::prefs{'SendReceipt'}='ask';}
	if($notebook->{'RetRecAlways'}->active){$main::prefs{'SendReceipt'}='all';}
	if($notebook->{'RetRecNever'}->active){$main::prefs{'SendReceipt'}='never';}
	if ($notebook->{'forksend'}->active){ $main::prefs{'forksend'} = 1 } else { $main::prefs{'forksend'} = 0 }
	if ($notebook->{'forkget'}->active){ $main::prefs{'forkget'} = 1 } else { $main::prefs{'forkget'} = 0 }
	if ($notebook->{'SendImmediately'}->active) { $main::prefs{'SendImmediately'} = "y"; } else { $main::prefs{'SendImmediately'} = "n"; }
	if ($notebook->{'CheckMailOnStartup'}->active) { $main::prefs{'CheckMailOnStartup'} = "y"; } else { $main::prefs{'CheckMailOnStartup'} = "n";}
	if ($notebook->{'saveSize'}->active) { $main::prefs{'saveSize'} = "y"; } else { $main::prefs{'saveSize'} = "n"; }
        if ($notebook->{'ExternalSig'}->active) { $main::prefs{'ExternalSig'} = 1; } else { $main::prefs{'ExternalSig'} = 0; }
	if ($notebook->{'useAlternateViewer'}->active) { $main::prefs{'useAlternateViewer'} = "y"; } else { $main::prefs{'useAlternateViewer'} = "n"; }
	if ($notebook->{'attachLeftView'}->active) { $main::prefs{'attachLeftView'} = "y"; } else { $main::prefs{'attachLeftView'} = "n"; }
	if ($notebook->{'Scoring'}->active) { $main::prefs{'Scoring'} = "y"; $main::message_clist->set_column_visibility(3, 1); } else { $main::prefs{'Scoring'} = "n"; $main::message_clist->set_column_visibility(3, 0); }
	if ($notebook->{'import'}->active) { $main::prefs{'import'} = "y"; } else { $main::prefs{'import'} = "n";}
	if ($notebook->{'popalwaysnew'}->active) { $main::prefs{'popalwaysnew'} = "y"; } else { $main::prefs{'popalwaysnew'} = "n";}
	if ($notebook->{'checkDupeOnAll'}->active) { $main::prefs{'checkDupeOnAll'} = "y"; } else { $main::prefs{'checkDupeOnAll'} = "n";}
	if ($notebook->{'PlaySound'}->active) { $main::prefs{'PlaySound'} = "y"; } else { $main::prefs{'PlaySound'} = "n";}
	if ($notebook->{'InlineImages'}->active) { $main::prefs{'InlineImages'} = "y"; } else { $main::prefs{'InlineImages'} = "n";}
	if ($notebook->{'empty_trash_on_exit'}->active) { $main::prefs{'empty_trash_on_exit'} = 1; } else { $main::prefs{'empty_trash_on_exit'} = 0; }
	if ($notebook->{'InlineAttachments'}->active) { $main::prefs{'InlineAttachments'} = "y"; } else { $main::prefs{'InlineAttachments'} = "n";}
	if ($notebook->{'InlineIcons'}->active) { $main::prefs{'InlineIcons'} = "y"; } else { $main::prefs{'InlineIcons'} = "n";}
	if ($notebook->{'Splash'}->active) { $main::prefs{'Splash'} = 0;} else { $main::prefs{'Splash'} = 1; }
	if ($notebook->{'SliceSig'}->active) { $main::prefs{'SliceSig'} = 1;} else { $main::prefs{'SliceSig'} = 0; }
	if ($notebook->{'FolderNewBold'}->active) { $main::prefs{'FolderNewBold'} = "y"; } else {$main::prefs{'FolderNewBold'} = "n";}
	if ($notebook->{'BoldMsg'}->active) { $main::prefs{'BoldMsg'} = 1; } else { $main::prefs{'BoldMsg'} = 0; }
	if ($notebook->{'AddReplytoAB'}->active) { $main::prefs{'AddReplytoAB'} = "y";} else {$main::prefs{'AddReplytoAB'} = "n"; }
	if ($notebook->{'MsgInDB'}->active) {
		$main::prefs{'MsgInDB'} = "y"; 
       		if ($main::prefs{'DatabaseDriver'} eq "Pg" && $main::prefs{'DriverVersion'} < 0.96) {
			&main::err_dialog(_("Your DBD::Pg version is less than 0.96 which is the required version for storing messages in the database for PostgreSQL, turning MsgInDB off"));
			$main::prefs{'MsgInDB'} = "n";
		}	
	} else { 
		$main::prefs{'MsgInDB'} = "n"; 
       	}
	if ($notebook->{'ForwardAttachments'}->active) { $main::prefs{'ForwardAttachments'} = "y";} else {$main::prefs{'ForwardAttachments'} = "n"; }
	if ($notebook->{'ForwardHeader'}->active) {$main::prefs{'ForwardHeader'} = "y";} else { $main::prefs{'ForwardHeader'} = "n"; }
        if ($notebook->{'autospell'}->active) {$main::prefs{'autospell'} = "y";} else { $main::prefs{'autospell'} = "n"; }
	if ($notebook->{'DeleteMarksAsRead'}->active) { $main::prefs{'DeleteMarksAsRead'} = "y"; } else { $main::prefs{'DeleteMarksAsRead'} = "n"; }
	if ($notebook->{'msgcolors'}->active) { $main::prefs{'UseMessageColors'} = "y"; } else { $main::prefs{'UseMessageColors'} = "n";}
	if ($notebook->{'NoHTML'}->active) { 
		$main::prefs{'NoHTML'} = "y";
		if ($main::HTMLWIDGET ne "text") {
			$main::HTMLWIDGET = "text";
			&Pronto::MainWindow::make_layout("flag");
			$remade_layout = 1;
		}	
        } else { 
		$main::prefs{'NoHTML'} = "n";
		if ($main::HTMLWIDGET eq "text" && $main::hashtml == 1) {
			$main::HTMLWIDGET = $main::hashtml_widget;
			&Pronto::MainWindow::make_layout("flag");
      			$remade_layout = 1;
		}	
	}
	
	my $old_drag = $main::prefs{'Drag'};
	if ($notebook->{'Drag'}->active) { 		
		$main::prefs{'Drag'} = 1;
		if (!$old_drag && !$remade_layout) {
			&Pronto::MainWindow::make_layout("flag");
		}
	} else {		
		$main::prefs{'Drag'} = 0;
		if ($old_drag && !$remade_layout) {
			&Pronto::MainWindow::make_layout("flag");
		}
	}	

	if ($notebook->{'useGtkFontComposer'}->active) { $main::prefs{'useGtkFontComposer'} = "y"} else { $main::prefs{'useGtkFontComposer'} = "n"}
	if ($main::check_timer) { Gtk->timeout_remove($main::check_timer); }
	if ($main::prefs{'AutoCheckTime'} > 0) {
		my $seconds = 60*$main::prefs{'AutoCheckTime'};
		alarm $seconds;
	}
	&main::save_prefs;
	#apply fonts
	$main::bold->font(Gtk::Gdk::Font->load($main::prefs{'FontMLBold'}));
	$main::normal->font(Gtk::Gdk::Font->load($main::prefs{'FontMLNormal'}));	  

	&Pronto::FolderTree::refresh_folder_tree;
	&Pronto::MessageList::refresh_messages;
	if (not defined $apply or $apply ne "apply"){
		$window->destroy;
	}
	return 1;  
}

sub init_browse_dlg {
	my ($widget, $entry, $dlg_type) = @_;
	my ($fs_window);
	$fs_window = new Gtk::FileSelection _("Choose Directory...");
	$fs_window->position(-mouse);
	$fs_window->signal_connect("destroy", sub {$fs_window->destroy;});
	$fs_window->signal_connect("delete_event" => \&Gtk::false);
	if($dlg_type eq "ispell_path") {
		$fs_window->set_title(_("Select Ispell or Aspell path ..."));
		$fs_window->ok_button->signal_connect("clicked", \&check_ispell_path, $fs_window, $entry);
	}
	elsif($dlg_type eq "viewer_path") {
                $fs_window->set_title(_("Select Viewer path ..."));
                $fs_window->ok_button->signal_connect("clicked", \&check_viewer_path, $fs_window, $entry);
      	} elsif($dlg_type eq "install_theme") {
		$fs_window->set_title(_("Select Theme ..."));
                $fs_window->ok_button->signal_connect("clicked", \&check_install_theme, $fs_window, $entry);
        } elsif($dlg_type eq "gpg_path") {
		$fs_window->set_title(_("Select GPG Path ..."));
		$fs_window->ok_button->signal_connect("clicked", \&check_gpg_path, $fs_window, $entry);
	}	
	$fs_window->cancel_button->signal_connect("clicked", sub {$fs_window->destroy;});
	$fs_window->show;
	return 1;
}

sub check_ispell_path {
        my ($widget, $fs_window, $entry) = @_;
	if (($fs_window->get_filename =~ /ispell/) || ($fs_window->get_filename =~ /aspell/)) {
		$entry->set_text($fs_window->get_filename);
                $fs_window->destroy;
                return 1;
        } else {
                &main::err_dialog(_("You must select the location of ispell"));
                return 1;
        }
}

sub check_gpg_path {
	my ($widget, $fs_window, $entry)=@_;
	if (($fs_window->get_filename =~ /gpg/) || ($fs_window->get_filename =~ /pgp/)) {
		$entry->set_text($fs_window->get_filename);
		$fs_window->destroy;
		return 1;
	} else {
		&main::err_dialog(_("Select an appropriate GPG path please !"));
		return 1;
	}
}	

sub check_viewer_path {
        my ($widget, $fs_window, $entry) = @_;
        if (($fs_window->get_filename =~ /netscape/) || (-f $fs_window->get_filename)) {
                $entry->set_text($fs_window->get_filename);
                $fs_window->destroy;
                return 1;
        } else {
                &main::err_dialog(_("The path to the viewer you entered does not exist!"));
                return 1;
        }
}

sub init_font_dlg {
	my ($widget, $entry) = @_;
	my ($font_dlg);
	$font_dlg = new Gtk::FontSelectionDialog(_("Select Font"));
	$font_dlg->position(-mouse);
	$font_dlg->set_font_name($entry->get_text);
	$font_dlg->set_preview_text("Pronto $main::version");
	$font_dlg->signal_connect("destroy", sub {$font_dlg->destroy;});
	$font_dlg->ok_button->signal_connect("clicked", sub {$entry->set_text($font_dlg->get_font_name()); $font_dlg->destroy; return 1;});
	$font_dlg->cancel_button->signal_connect("clicked", sub {$font_dlg->destroy;});
	$font_dlg->show;
}

sub check_install_theme {
        my ($widget, $fs_window, $entry) = @_;
        if ((-f $fs_window->get_filename) && ($fs_window->get_filename =~ /\.tar\.gz$/i)) {
		my $filename =  $fs_window->get_filename();
                $fs_window->destroy;
		if(!(-f $main::prefs{'MailDir'} . "/pixmaps")) {
			system("mkdir " . $main::prefs{'MailDir'} . "/pixmaps");
		}
		system("cp $filename " . $main::prefs{'MailDir'} . "/pixmaps");
        	my $file;
        	foreach(split(/\//, $filename)) {
                	$file = $_;
        	}
        	system("tar zxf " . $main::prefs{'MailDir'} . "/pixmaps/$file --directory=" . $main::prefs{'MailDir'} . "/pixmaps");
        	system("rm -f " . $main::prefs{'MailDir'} . "/pixmaps/$file");
		$entry->signal_emit("activate");
		return 1;
        } else {
                &main::err_dialog(_("You must select a Theme in .tar.gz format"));
                return 1;
        }
}



1;
