/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import java.io.Serializable;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;

public class HDF5Object
implements Serializable {
    public static final int UNKNOWN = -1;
    public static final int LINK = 0;
    public static final int GROUP = 1;
    public static final int DATASET = 2;
    public static final int DATATYPE = 3;
    public static final int DATASPACE = 4;
    public static final int ATTRIBUTE = 5;
    public static final int HDF5FILE = 6;
    protected int type;
    protected String name;
    protected String shortName;
    protected int id;
    protected String description;

    public HDF5Object() {
        this(null);
    }

    public HDF5Object(String objName) {
        this.name = objName;
        this.type = -1;
        this.description = "";
        if (this.name != null && !this.name.equals("/")) {
            int idx = this.name.lastIndexOf(47) + 1;
            this.shortName = this.name.substring(idx);
        } else {
            this.shortName = this.name;
        }
    }

    public void init() throws HDF5Exception {
        if (this.id < 0) {
            return;
        }
    }

    public void setID(int new_id) throws HDF5Exception {
        this.id = new_id;
        this.init();
    }

    public void setShortName(String sname) {
        this.shortName = sname;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int t) {
        this.type = t;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getID() {
        return this.id;
    }

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.getClass().getName() + "[name=" + this.name + "]";
    }
}

