#ifndef ROUTINES_H
#define ROUTINES_H

#include <Python.h>

#if defined(_WIN32) || defined(__WIN32__)
#define snprintf _snprintf
#endif

#define EXTRA 100
#define QUOTE    '\''

#define DOUBLE_INTEGER_DIGITS  309
#define DOUBLE_FRACTION_DIGITS 340

typedef struct DigitList {
    char digits[DOUBLE_FRACTION_DIGITS];
    short count;
    short decimalAt;
} DigitList;

typedef struct PatternInfo {
    char *positivePattern;
    char *positivePrefix;
    char *positiveSuffix;

    char *negativePattern;
    char *negativePrefix;
    char *negativeSuffix;

    int maxIntegerDigits;
    int minIntegerDigits;
    int maxFractionDigits;
    int minFractionDigits;

    int multiplier;
    int groupingSize;

    short groupingUsed;          /* true/false */
    short showDecimalPoint;      /* true/false */
} PatternInfo;

typedef struct DecimalFormatSymbols {
    char zeroDigit;
    char groupingSeparator;
    char decimalSeparator;
    char percent;
    char perMill;
    char digit;
    char separator;
    char minus;
    char *infinity;
    char *NaN;
} DecimalFormatSymbols;

int parsePattern(PatternInfo *patternInfo, DecimalFormatSymbols *symbols);
void parseNumber(double number, int maximumDigits, DigitList *digitList);

#ifdef __cplusplus
extern "C" {
#endif
    extern PyObject *DecimalFormat(PyObject *self, PyObject *args);

    extern void initroutines(void);
#ifdef __cplusplus
}
#endif
#endif /* ROUTINES_H */
