########################################################################
#
# File Name: 	        UnionCase.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/UnionCase.py.html
#
"""
Implements the UnionCase meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


from Ft.Ods.MetaData import Specifier
from Ft.Ods.MetaData import MetaKind
from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

from Ft.Ods.StorageManager.Adapters import Constants

class UnionCase(Specifier.Specifier):
    def __init__(self,db,data):
        Specifier.Specifier.__init__(self,db,data,MetaKind.mk_union_case)

    def form_union_type(self,target,inverse = 1):
        from Ft.Ods.MetaData import Union
        self._4ods_formRelationship('union_type',Union.Union,'cases','add',target,inverse)
    def drop_union_type(self,target,inverse = 1):
        self._4ods_dropRelationship('union_type','cases','remove',target,inverse)

    def add_case_labels(self,target,inverse = 1):
        from Ft.Ods.MetaData import Operand
        self._4ods_addRelationship('case_labels',Operand.Operand,'case_in','form',target,inverse)
    form_case_labels=add_case_labels


    def remove_case_labels(self,target,inverse = 1):
        self._4ods_removeRelationship('case_labels','case_in','drop',target,inverse)
    drop_case_labels=remove_case_labels


    def _4ods_getOdl(self,indent):
        if len(self.case_labels):
            for cl in self.case_labels:
                st = indent + 'case %s: ' % cl._4ods_getOdl('')
        else:
            st = indent + 'default: '
        return st + "%s %s" % (self.type.absolute_name(),self.name)


    def _4ods_getGeneratedMetaClasses(self,found,checked):
        if self in checked: return
        checked.append(self)
        return found



    _tupleNames = (('union_type',),('case_labels',))

    _tupleDefinitions = {'union_type':{td.TYPE:Constants.Types.ROBJECT,
                                       td.RELATIONSHIP:1,
                                       td.READONLY:1,
                                       },
                         'case_labels':{td.TYPE: Constants.Types.LIST_COLLECTION,
                                        td.READONLY:1,
                                        td.RELATIONSHIP:1,
                                        td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                        },
                         }
                                       
    _localExtents = ()
