########################################################################
#
# File Name:            ApplyImportsElement.py
#
# Documentation:        http://docs.4suite.org/4XSLT/ApplyImportsElement.py.html
#
"""
Implementation of the XSLT Spec apply-imports stylesheet element.
WWW: http://4suite.org/4XSLT        e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import xml.dom.ext
import xml.xslt
from xml.xslt import XsltElement, XSL_NAMESPACE, XsltException, Error

class ApplyImportsElement(XsltElement):
    legalAttrs = []

    def __init__(self, doc, uri=xml.xslt.XSL_NAMESPACE,
                 localName='apply-imports', prefix='xsl', baseUri=''):

        XsltElement.__init__(self, doc, uri, localName, prefix, baseUri)

    def setup(self):
        self._nss = xml.dom.ext.GetAllNs(self)
        for child in self.childNodes:
            #No significant children allowed
            if not ((child.nodeType == Node.TEXT_NODE \
                 and not string.strip(child.data)) \
                 or child.nodeType == Node.COMMENT_NODE):
                raise XsltException(Error.ILLEGAL_APPLYIMPORTS_CHILD)
        return

    def instantiate(self, context, processor):
        origState = context.copy()
        context.setNamespaces(self._nss)

        processor.applyImports(context)

        context.set(origState)
        return (context,)

    def __getinitargs__(self):
        return (None, self.namespaceURI, self.localName, self.prefix,
                self.baseUri)

    def __getstate__(self):
         base_state = XsltElement.__getstate__(self)
         new_state = (base_state, self._nss, self._mode, self._sortSpecs, self._select, self._expr)
         return new_state

    def __setstate__(self, state):
        XsltElement.__setstate__(self, state[0])
        self._nss = state[1]
        self._mode = state[2]
        self._sortSpecs = state[3]
        self._select = state[4]
        self._expr = state[5]
        return


