



from Ft.Ods.StorageManager.Adapters.Dbm import DManager
from Ft.Ods.StorageManager.Adapters.Dbm import DAdapter
from Ft.Ods.StorageManager.Adapters import Util


from Ft.Lib import DbmDatabase

class Validator:

    def validateCreate(self,tester,dbName):
        dbName = Util.SplitDbConnectString(dbName)[0]
        if 'ft__' + dbName not in DbmDatabase.GetAllDatabaseNames():
            tester.error("DBM driver failed creation test")

    def validateDestroy(self,tester,dbName):
        dbName = Util.SplitDbConnectString(dbName)[0]
        if 'ft__' + dbName in DbmDatabase.GetAllDatabaseNames():
            db = DbmDatabase.Database('ft__'+dbName)
            for t in db.getAllTableNames():
                if t[:6] == 'ftods_':
                    tester.error("DBM driver failed destroy test")

    def validateInit(self,tester,dbName,mang):
        dbName = Util.SplitDbConnectString(dbName)[0]
        if 'ft__' + dbName in DbmDatabase.GetAllDatabaseNames():
            db = DbmDatabase.Database('ft__'+dbName)
            found = {}
            for t in db.getAllTableNames():
                if t in mang.tables:
                    found[t] = 1
            for t in mang.tables:
                if not found.has_key(t):
                    tester.error("DBM driver failed init test, table %s not created" % t)
            found = {}
            for s in db['ftods_sequences'].keys():
                if s in mang.sequences:
                    found[s] = 1
            for s in mang.sequences:
                if not found.has_key(s):
                    tester.error("DBM driver failed init test, sequence %s not created" % s)
                
        else:
            tester.error("DBM driver failed init test")


        



