/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "UnionVolPy.h"

using namespace boost::python;

    void exportUnionVol()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      class_<UnionVol, bases<AVolume3D> >(
        "UnionVol",
        "A class defining a volume consisting of the union of two volumes in 3D.",
        init<>()
      )
      .def(init<const UnionVol &>())
      .def(
        init<AVolume3D&,AVolume3D&>(
          ( arg("volume1"), arg("volume2") ),
          "Constructs a volume comprised of the union of two volumes.\n"
          "@type volume1: L{AVolume3D}\n"
          "@kwarg volume1: The first volume comprising the union\n"
          "@type volume2: L{AVolume3D}\n"
          "@kwarg volume2: The second volume comprising the union\n"
        )
      )
      .def(self_ns::str(self))
      ;
    }



