/***************************************************************************
                          cupshelper.h  -  description
                             -------------------
    begin                : Thu Jun 15 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@imec.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CUPSHELPER_H
#define CUPSHELPER_H

#include <cups/cups.h>
#include <cups/ipp.h>

const char* cupsGetPasswordCB(const char *prompt);

#include <qstring.h>

/**
  *@author Michael Goffioul
  */

class CupsHelper {
public: 
	CupsHelper();
	~CupsHelper();

	static CupsHelper* get();

  void setLoginInfo(const char *usr = 0, const char *pwd = 0);
  void setHostInfo(const char *host, int port = 631);

  int port();
  const QString& host();
  const QString& password();
  const QString& login();

  ipp_t* newIppRequest();
  ipp_t* processRequest(ipp_t *req, const char *res);

  bool checkHost();
  const char* cupsGetPassword();
  void setup();
  int printerType(const char *name, int* state = 0);

private: // Private attributes
  QString host_;
  QString password_;
  QString login_;
  int port_;
  int count_;

	static CupsHelper	*unique_;
};

#endif
