/***************************************************************************
                          passworddialog.cpp  -  description
                             -------------------
    begin                : Mon Jan 22 2001
    copyright            : (C) 2001 by Michael Goffioul
    email                : goffioul@imec.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "passworddialog.h"
#include "cupshelper.h"

#include <qlineedit.h>
#include <qlabel.h>

PasswordDialog::PasswordDialog(QWidget *parent, const char *name)
: PasswordDialogBase(parent,name,true)
{
	initDialog();
}

PasswordDialog::~PasswordDialog()
{
}

const char* PasswordDialog::password()
{
	return (const char*)(password_->text());
}

const char* PasswordDialog::login()
{
	return (const char*)(login_->text());
}

void PasswordDialog::setLogin(const QString& user)
{
	login_->setText(user);
	login_->selectAll();
	login_->setFocus();
}

void PasswordDialog::initDialog()
{
	QString	msg = tr("<p>The access to the requested resource on the CUPS server running on <b>%1</b> (port <b>%2</b>) requires a password.</p>").arg(CupsHelper::get()->host()).arg(CupsHelper::get()->port());
	explabel_->setText(msg);
}

int PasswordDialog::doIt()
{
	return exec();
}
