/***************************************************************************
                          qcupsprinter.cpp  -  description
                             -------------------
    begin                : Thu Jun 15 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@imec.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qcupsprinter.h"

#include "qcupsprintdialog.h"
#include <qpainter.h>
#include <qprinter.h>

#include <stdlib.h>

class QPrinterWrapper : public QPrinter
{
friend class QCupsPrinter;
public:
	QPrinterWrapper() : QPrinter() {}
	~QPrinterWrapper() {}
protected:
	bool cmd(int c, QPainter *painter, QPDevCmdParam *p) { return QPrinter::cmd(c,painter,p); }
};

//************************************************************************

QCupsPrinter::QCupsPrinter() : QPaintDevice(QInternal::Printer|QInternal::ExternalDevice)
{
	// initialize temporary print file
	tmpPrintFile_ = cupsTempFile(NULL,0);
	// initialize QPrinter wrapper
	wrapper_ = new QPrinterWrapper();
	wrapper_->setOutputToFile(true);
	wrapper_->setOutputFileName(tmpPrintFile_.data());
	// initialize CUPS stuffs
	options_ = NULL;
	num_options_ = 0;
	printerName_ = getenv("PRINTER");
}

QCupsPrinter::~QCupsPrinter()
{
	if (!tmpPrintFile_.isEmpty()) unlink(tmpPrintFile_.data());
	delete wrapper_;
}

bool QCupsPrinter::cmd(int c, QPainter *painter, QPDevCmdParam *p)
{
	bool	value;
	value = wrapper_->cmd(c,painter,p);
	if (c == QPaintDevice::PdcEnd) {
		value = value && printFile(tmpPrintFile_.data());
	}
	return value;
}

bool QCupsPrinter::printFile(const char *filename)
{
	return (bool)(cupsPrintFile(printerName_.data(),filename,"QCupsPrinter",num_options_,options_));
}

bool QCupsPrinter::setup(QWidget *parent)
{
	QCupsPrintDialog	*dlg = new QCupsPrintDialog(parent);
	dlg->allowCurrentPage(true);
	bool	value(false);
	if (dlg->exec()) {
		printerName_ = dlg->printerName();
		dlg->getAllOptions(num_options_,&options_);
		value = true;
	}
	delete dlg;
	return value;
}

bool QCupsPrinter::newPage()
{
	return wrapper_->newPage();
}
