/***************************************************************************
                          qcupsprinter.h  -  description
                             -------------------
    begin                : Thu Jun 15 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@imec.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QCUPSPRINTER_H
#define QCUPSPRINTER_H

#include <qpaintdevice.h>
#include <qstring.h>
#include <cups/cups.h>

// forward declaration
class QPrinterWrapper;

/**
  *@author Michael Goffioul
  */

class QCupsPrinter : public QPaintDevice {
public: 
	QCupsPrinter();
	~QCupsPrinter();
	bool setup(QWidget *parent = 0);
	bool newPage();
	bool printFile(const char *filename);
protected:
	bool cmd(int c, QPainter *painter, QPDevCmdParam *p);
private:
	QPrinterWrapper	*wrapper_;
	QString	tmpPrintFile_;
	QString	printerName_;
	cups_option_t	*options_;
	int	num_options_;
};

#endif
