/***************************************************************************
                          qcupsprinterconfigdialog.h  -  description
                             -------------------
    begin                : Tue Jul 4 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@imec.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QCUPSPRINTERCONFIGDIALOG_H
#define QCUPSPRINTERCONFIGDIALOG_H

#include <qwidget.h>
#include <qtabdialog.h>

#include <cups/cups.h>
#include "globalppd.h"

class QConfigPage;
class QGeneralConfig;
class QImageConfig;
class QTextConfig;
class QHPGL2Config;
class QPPDConfigPage;

/**
  *@author Michael Goffioul
  */

class QCupsPrinterConfigDialog : public QTabDialog  {
   Q_OBJECT
public: 
	QCupsPrinterConfigDialog(int pages = 0xFF, QWidget *parent=0, const char *name=0, bool useSave = true);
	~QCupsPrinterConfigDialog();

  bool initialize(cups_dest_t *dest = 0);
  void getCupsOptions(int& num_options, cups_option_t **options);
  bool hasConflict();

private: // Private attributes
  cups_dest_t* dest_;
  ipp_t* request_;
  global_ppd_file_t* ppd_;
  QString ppdFileName_;

  QGeneralConfig* generalPage_;
  QImageConfig*	imagePage_;
  QTextConfig* textPage_;
  QHPGL2Config* hpgl2Page_;
  QPPDConfigPage* advancedPage_;

protected slots:
  void tabSelected(const QString& name);
  virtual void done(int result);
private: // Private methods
  void closeRequest();
  QConfigPage *currentPage_;
  // temporary options
  int num_options_;
  cups_option_t *options_;
private: // Private methods
  void closePpd();
};

#endif
