/***************************************************************************
                          qimageconfig.cpp  -  description
                             -------------------
    begin                : Tue Jul 4 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@emic.ucl.ac.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "qimageconfig.h"

#include <qpixmap.h>
#include <qscrollbar.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qlabel.h>

#include <stdlib.h>

#include "previewimage.h"
#include "position.h"
#include "preview.xpm"

QImageConfig::QImageConfig(QWidget *parent, const char *name)
: QImageConfigBase(parent,name), QConfigPage()
{
	initDialog();
}

QImageConfig::~QImageConfig()
{
}

void QImageConfig::initDialog()
{
  preview_->setImage(QImage(preview));

	hue_->setSteps(1,72);
	hue_->setRange(-360,360);
	hue_->setValue(0);
	hue_->setOrientation(QScrollBar::Horizontal);
	saturation_->setSteps(1,20);
	saturation_->setRange(0,200);
	saturation_->setValue(100);
	saturation_->setOrientation(QScrollBar::Horizontal);
	brightness_->setSteps(1,20);
	brightness_->setRange(0,200);
	brightness_->setValue(100);
	brightness_->setOrientation(QScrollBar::Horizontal);
	gamma_->setSteps(1,100);
	gamma_->setRange(1,3000);
	gamma_->setValue(1000);
	gamma_->setOrientation(QScrollBar::Horizontal);
	scaling_->setSteps(1,80);
	scaling_->setRange(1,800);
	scaling_->setValue(100);
	scaling_->setOrientation(QScrollBar::Horizontal);
	ppi_->setSteps(1,120);
	ppi_->setRange(1,1200);
	ppi_->setValue(72);
	ppi_->setOrientation(QScrollBar::Horizontal);

	colorSettingsChanged(0);
	ppiCheckClicked();
	scalingCheckClicked();

	horizgrp_ = new QButtonGroup(this);
	horizgrp_->hide();
	vertgrp_ = new QButtonGroup(this);
	vertgrp_->hide();
	connect(horizgrp_, SIGNAL(clicked(int)), SLOT(horizChanged(int)));
	connect(vertgrp_, SIGNAL(clicked(int)), SLOT(vertChanged(int)));

	horizpos_ = vertpos_ = 1;
	pospix_->setPosition(horizpos_,vertpos_);
	wcenter_->setChecked(true);
	hcenter_->setChecked(true);

	horizgrp_->insert(left_,0);
	horizgrp_->insert(wcenter_,1);
	horizgrp_->insert(right_,2);
	vertgrp_->insert(top_,0);
	vertgrp_->insert(hcenter_,1);
	vertgrp_->insert(bottom_,2);
}

void QImageConfig::ppiCheckClicked()
{
	bool	val = ppicheck_->isChecked();
	ppi_->setEnabled(val);
	if (val) {
		ppiChanged(ppi_->value());
		if (scalingcheck_->isChecked()) {
			scalingcheck_->setChecked(false);
			scalingCheckClicked();
		}
	}
	else
		ppivalue_->setText("");
}

void QImageConfig::scalingCheckClicked()
{
	bool	val = scalingcheck_->isChecked();
	scaling_->setEnabled(val);
	if (val) {
		scalingChanged(scaling_->value());
		if (ppicheck_->isChecked()) {
			ppicheck_->setChecked(false);
			ppiCheckClicked();
		}
	}
	else
		scalingvalue_->setText("");
}

void QImageConfig::ppiChanged(int value)
{
	QString	str;
	str.setNum(value);
	ppivalue_->setText(str.data());
}

void QImageConfig::scalingChanged(int value)
{
	QString	str;
	str.setNum(value);
	scalingvalue_->setText(str.data());
}

void QImageConfig::defaultClicked()
{
	hue_->setValue(0);
	brightness_->setValue(100);
	saturation_->setValue(100);
	gamma_->setValue(1000);
}

void QImageConfig::colorSettingsChanged(int)
{
	int	h(hue_->value()), b(brightness_->value()), s(saturation_->value()), g(gamma_->value());
	QString	value;

	value.setNum(h);
	huevalue_->setText(value.data());
	value.setNum(s);
	saturationvalue_->setText(value.data());
	value.setNum(b);
	brightnessvalue_->setText(value.data());
	value.setNum(float(g)/1000,'f',3);
	gammavalue_->setText(value.data());

	preview_->setParameters(b,h,s,1000);
}

void QImageConfig::initOptions(int num_options, cups_option_t *options, global_ppd_file_t *ppd, ipp_t*)
{
	const char*	str = cupsGetOption("ColorModel",num_options,options);
	if ((ppd && ppd->ppd && !ppd->ppd->color_device) || (str && strncmp(str,"Gray",4) == 0)) {
		hue_->setEnabled(false);
		saturation_->setEnabled(false);
		huevalue_->hide();
		saturationvalue_->hide();
		preview_->setBlackAndWhite(true);
	}
	else {
		hue_->setEnabled(true);
		saturation_->setEnabled(true);
		huevalue_->show();
		saturationvalue_->show();
		preview_->setBlackAndWhite(false);
	}

	// init "hue"
	if ((str=cupsGetOption("hue",num_options,options)) != NULL)
		hue_->setValue(atoi(str));
	// init "saturation"
	if ((str=cupsGetOption("saturation",num_options,options)) != NULL)
		saturation_->setValue(atoi(str));
	// init "brightness"
	if ((str=cupsGetOption("brightness",num_options,options)) != NULL)
		brightness_->setValue(atoi(str));
	// init "gamma"
	if ((str=cupsGetOption("gamma",num_options,options)) != NULL)
		gamma_->setValue(atoi(str));

	// init "ppi"
	if ((str=cupsGetOption("ppi",num_options,options)) != NULL) {
		ppi_->setValue(atoi(str));
		if (!(str=cupsGetOption("ppi-flag",num_options,options)) || strcmp(str,"on") == 0)
			ppicheck_->setChecked(true);
		else
			ppicheck_->setChecked(false);
		ppiCheckClicked();
	}

	// init "scaling"
	if ((str=cupsGetOption("scaling",num_options,options)) != NULL) {
		scaling_->setValue(atoi(str));
		if (!(str=cupsGetOption("scaling-flag",num_options,options)) || strcmp(str,"on") == 0)
			scalingcheck_->setChecked(true);
		else
			scalingcheck_->setChecked(false);
		scalingCheckClicked();
	}

	// init "image position"
	if ((str=cupsGetOption("position",num_options,options)) != NULL) {
		pospix_->setPosition(str);
		int	pos = pospix_->position();
		vertgrp_->setButton((vertpos_=pos/3));
		horizgrp_->setButton((horizpos_=pos%3));
	}
}

void QImageConfig::getCupsOptions(int& num_options, cups_option_t **options, bool incldef, ipp_t*)
{
	QString	value;

	// Brightness
	if (incldef || brightness_->value() != 100) {
		value.setNum(brightness_->value());
		num_options = cupsAddOption("brightness",value.data(),num_options,options);
	}
	// Gamma
	if (incldef || gamma_->value() != 1000) {
		value.setNum(gamma_->value());
		num_options = cupsAddOption("gamma",value.data(),num_options,options);
	}

	// Hue and saturation
	if (hue_->isEnabled()) {
		if (incldef || hue_->value() != 0) {
			value.setNum(hue_->value());
			num_options = cupsAddOption("hue",value.data(),num_options,options);
		}
		if (incldef || saturation_->value() != 100) {
			value.setNum(saturation_->value());
			num_options = cupsAddOption("saturation",value.data(),num_options,options);
		}
	}

	// Resolution
	if (ppicheck_->isChecked()) {
		value.setNum(ppi_->value());
		num_options = cupsAddOption("ppi",value.data(),num_options,options);
	}

	// Scaling
	if (scalingcheck_->isChecked()) {
		value.setNum(scaling_->value());
		num_options = cupsAddOption("scaling",value.data(),num_options,options);
	}

	if (incldef) {
		num_options = cupsAddOption("ppi-flag",(ppicheck_->isChecked() ? "on" : "off"),num_options,options);
		num_options = cupsAddOption("scaling-flag",(scalingcheck_->isChecked() ? "on" : "off"),num_options,options);
	}

	// Image position
	if (incldef || pospix_->position() != ImagePosition::Center) {
		value = pospix_->positionString();
		num_options = cupsAddOption("position",value.data(),num_options,options);
	}
}

void QImageConfig::vertChanged(int ID)
{
	vertpos_ = ID;
	pospix_->setPosition(horizpos_,vertpos_);
}

void QImageConfig::horizChanged(int ID)
{
	horizpos_ = ID;
	pospix_->setPosition(horizpos_,vertpos_);
}
