#include "qppdbaseitem.h"

#include <qpainter.h>
#include <qapplication.h>

QPPDBaseItem::QPPDBaseItem(global_ppd_file_t *ppd, QListView *parent)
	: QListViewItem(parent)
{
	children_.setAutoDelete(false);
	ppd_ = ppd;
	type_ = Regular;
}

QPPDBaseItem::QPPDBaseItem(global_ppd_file_t *ppd, QListViewItem *parent)
	: QListViewItem(parent)
{
	children_.setAutoDelete(false);
	((QPPDBaseItem*)parent)->children_.append(this);
	ppd_ = ppd;
	type_ = Regular;
}

QPPDBaseItem::QPPDBaseItem(global_ppd_file_t *ppd, QListViewItem *parent, QListViewItem *after)
	: QListViewItem(parent,after)
{
	children_.setAutoDelete(false);
	((QPPDBaseItem*)parent)->children_.append(this);
	ppd_ = ppd;
	type_ = Regular;
}

QPPDBaseItem::~QPPDBaseItem()
{
}

int QPPDBaseItem::textWidth(QPainter *p) const
{
	return p->fontMetrics().width(text(0));
}

void QPPDBaseItem::setConflict(bool on)
{
	conflict_ = on;
	if (conflict_)
	{
		if (depth() > 0) ((QPPDBaseItem*)parent())->setConflict(on);
	}
	else
	{
		QListIterator<QPPDBaseItem>	it(children_);
		for (;it.current();++it) it.current()->setConflict(on);
	}
	repaint();
}

void QPPDBaseItem::paintText(QPainter *p, const QColorGroup& cg, int r)
{
	p->setPen(isSelected() ? white : (showConflict() ? red : cg.text()));
	p->drawText(r,0,textWidth(p),height(),AlignVCenter|AlignLeft,text(0));
}

void QPPDBaseItem::paintCell(QPainter *p, const QColorGroup& cg, int column, int width, int)
{
    QListView *lv = listView();
    int r = lv->itemMargin();
    const QPixmap * icon = pixmap( column );

    p->fillRect( 0, 0, width, height(), cg.base() );

    int marg = r;
    int	w = textWidth(p) + 2 * marg;

    if (icon) w += (icon->width() + marg);

    if ( isSelected() ) {
	    p->fillRect( r - marg, 0, w, height(),
			 (showConflict() ? red : QApplication::winStyleHighlightColor()) );
    }

    if ( icon ) {
	p->drawPixmap( r, (height()-icon->height())/2, *icon );
	r += icon->width() + marg;
    }

    paintText( p, cg, r );
}

void QPPDBaseItem::markChoices(global_ppd_file_t *ppd)
{
	QListIterator<QPPDBaseItem>	it(children_);
	for (;it.current();++it) it.current()->markChoices(ppd);
}

void QPPDBaseItem::updateChoices(global_ppd_file_t *ppd)
{
	QListIterator<QPPDBaseItem>	it(children_);
	for (;it.current();++it) it.current()->updateChoices(ppd);
}

void QPPDBaseItem::getCupsOptions(int& num_options, cups_option_t **options, bool incldef)
{
	QListIterator<QPPDBaseItem>	it(children_);
	for (;it.current();++it) it.current()->getCupsOptions(num_options,options,incldef);
}

void QPPDBaseItem::setupDict(QDict<QPPDBaseItem>& dict) const
{
	QListIterator<QPPDBaseItem>	it(children_);
	for (;it.current();++it) it.current()->setupDict(dict);
}
