#include "qppdnumericaloptionitem.h"

#include "numeric.xpm"
#include "icons.h"

QPPDNumericalOptionItem::QPPDNumericalOptionItem(global_ppd_file_t *ppd, numerical_opt_t *option, QListViewItem *parent)
	: QPPDBaseItem(ppd,parent)
{
	type_ = Numeric;
	option_ = option;
	value_ = option_->defvalue;
	updateText();

	const char	**xpm = getOptionXPMString(option_->keyword);
	setPixmap(0,(xpm ? QPixmap(xpm) : QPixmap(numeric)));
}

QPPDNumericalOptionItem::~QPPDNumericalOptionItem()
{
}

void QPPDNumericalOptionItem::updateText()
{
	QString	txt;
	if (option_->type == 0) txt.sprintf("%s: <%d>",option_->text,(int)(value_));
	else txt.sprintf("%s: <%.3f>",option_->text,value_);
	setText(0,txt.data());
}

void QPPDNumericalOptionItem::markChoices(global_ppd_file_t *ppd)
{
	globalPpdMarkNumericalOption(ppd,option_->keyword,value_);
}

void QPPDNumericalOptionItem::updateChoices(global_ppd_file_t*)
{
	value_ = option_->value;
	updateText();
}

void QPPDNumericalOptionItem::getCupsOptions(int& num_options, cups_option_t **options, bool incldef)
{
	if (incldef || value_ != option_->defvalue)
	{
		QString	valstr;
		if (option_->type == 0) valstr.sprintf("%d",(int)value_);
		else valstr.sprintf("%.3f",value_);
		num_options = cupsAddOption(option_->keyword,valstr.data(),num_options,options);
	}
}

void QPPDNumericalOptionItem::paintText(QPainter *p, const QColorGroup& cg, int r)
{
	QString	txt;
	QFontMetrics	fm(p->fontMetrics());

	// first part (normal color)
	txt.sprintf("%s: <",option_->text);
	p->setPen(isSelected() ? white : cg.text());
	p->drawText(r,0,fm.width(txt.data()),height(),AlignLeft|AlignVCenter,txt.data());
	r += fm.width(txt.data());
	// second part (option color)
	p->setPen(isSelected() ? white : darkGreen);
	if (option_->type == 0) txt.sprintf("%d",(int)value_);
	else txt.sprintf("%.3f",value_);
	p->drawText(r,0,fm.width(txt.data()),height(),AlignLeft|AlignVCenter,txt.data());
	r += fm.width(txt.data());
	// last part (normal color)
	p->setPen(isSelected() ? white : cg.text());
	txt = ">";
	p->drawText(r,0,fm.width(txt.data()),height(),AlignLeft|AlignVCenter,txt.data());
}

void QPPDNumericalOptionItem::setValue(double value)
{
	value_ = value;
	option_->value = value;
	updateText();
}
