/***************************************************************************
                          qtcups.cpp  -  description
                             -------------------
    begin                : Tue Jan 23 2001
    copyright            : (C) 2001 by Michael Goffioul
    email                : goffioul@imec.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qtcups.h"

#include <qtranslator.h>
#include <qapplication.h>
#include <stdlib.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#define QTCUPS_TRANSLATION_DIR "/usr/share/qtcups"
#endif

QTranslator* QtCUPS::t = 0;

QString getDefaultLanguage()
{
	QString	l = getenv("LANG");
	if (l.isEmpty()) l = getenv("LC_ALL");
	return l;
}

void QtCUPS::setLocale(const QString& _lang)
{
	QString	lang = _lang;
	if (lang.isEmpty())
		lang = getDefaultLanguage();

	if (!t)
		t = new QTranslator(0);
	else
		qApp->removeTranslator(t);

	lang.prepend("qtcups.");
	t->load(lang,QTCUPS_TRANSLATION_DIR);
	qApp->installTranslator(t);
}
