// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SETTINGS_CHROMEOS_SEARCH_SEARCH_HANDLER_FACTORY_H_
#define CHROME_BROWSER_UI_WEBUI_SETTINGS_CHROMEOS_SEARCH_SEARCH_HANDLER_FACTORY_H_

#include "base/memory/singleton.h"
#include "components/keyed_service/content/browser_context_keyed_service_factory.h"

class Profile;

namespace chromeos {
namespace settings {

class SearchHandler;

// Factory for SearchHandler; available for incognito and multi-profile cases to
// support settings search in those contexts.
class SearchHandlerFactory : public BrowserContextKeyedServiceFactory {
 public:
  static SearchHandler* GetForProfile(Profile* profile);
  static SearchHandlerFactory* GetInstance();

 private:
  friend struct base::DefaultSingletonTraits<SearchHandlerFactory>;

  SearchHandlerFactory();
  ~SearchHandlerFactory() override;

  SearchHandlerFactory(const SearchHandlerFactory&) = delete;
  SearchHandlerFactory& operator=(const SearchHandlerFactory&) = delete;

  // BrowserContextKeyedServiceFactory:
  KeyedService* BuildServiceInstanceFor(
      content::BrowserContext* context) const override;
  bool ServiceIsNULLWhileTesting() const override;
  content::BrowserContext* GetBrowserContextToUse(
      content::BrowserContext* context) const override;
};

}  // namespace settings
}  // namespace chromeos

#endif  // CHROME_BROWSER_UI_WEBUI_SETTINGS_CHROMEOS_SEARCH_SEARCH_HANDLER_FACTORY_H_
