% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\docType{class}
\name{DiversityTest-class}
\alias{DiversityTest-class}
\alias{DiversityTest}
\alias{print,DiversityTest-method}
\alias{DiversityTest-method}
\alias{plot,DiversityTest,missing-method}
\title{S4 class defining diversity significance}
\usage{
\S4method{print}{DiversityTest}(x)

\S4method{plot}{DiversityTest,missing}(x, y, ...)
}
\arguments{
\item{x}{DiversityTest object.}

\item{y}{ignored.}

\item{...}{arguments to pass to \link{plotDiversityTest}.}
}
\description{
\code{DiversityTest} defines the signifance of diversity (\eqn{D}) differences at a 
fixed diversity order (\eqn{q}).
}
\section{Slots}{

\describe{
\item{\code{tests}}{data.frame describing the significance test results with columns:
\itemize{
  \item  \code{TEST}:        string listing the two groups tested.
  \item  \code{DELTA_MEAN}:  mean of the \eqn{D} bootstrap delta 
                             distribution for the test.
  \item  \code{DELTA_SD}:    standard deviation of the \eqn{D} 
                             bootstrap delta distribution for the test.
  \item  \code{PVALUE}:      p-value for the test.
}}

\item{\code{summary}}{data.frame containing summary statistics for the diversity index 
bootstrap distributions, at the given value of \eqn{q}, with columns:
\itemize{
  \item  \code{GROUP}:   the name of the group.
  \item  \code{MEAN}:    mean of the \eqn{D} bootstrap distribution.
  \item  \code{SD}:      standard deviation of the \eqn{D} bootstrap 
                         distribution.
}}

\item{\code{groups}}{character vector of groups retained in diversity calculation.}

\item{\code{q}}{diversity order tested (\eqn{q}).}

\item{\code{n}}{numeric vector indication the number of sequences sampled from each group.}

\item{\code{nboot}}{number of bootstrap realizations.}
}}

