% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapMiss.R
\name{gapMiss}
\alias{gapMiss}
\title{Missing value gap statistics}
\usage{
gapMiss(x, what = mean)
}
\arguments{
\item{x}{a numeric vector}

\item{what}{default is the arithmetic mean.
One can include an own function that returns a vector of lenght 1 (e.g. median)}
}
\value{
The gap statistics
}
\description{
Computes the average missing value gap of a vector.
}
\details{
The length of each sequence of missing values (gap) in a vector is calculated and the
mean gap is reported
}
\examples{
v <- rnorm(20)
v[3] <- NA
v[6:9] <- NA
v[13:17] <- NA
v
gapMiss(v)
gapMiss(v, what = median)
gapMiss(v, what = function(x) mean(x, trim = 0.1))
gapMiss(v, what = var)
}
\author{
Matthias Templ based on a suggestion and draft from Huang Tian Yuan.
}
\keyword{manip}
