#### Header variables
%define name root-portal
%define version 0.4.10
%define release 1
%define serial 1

#### Useful macros
# Attempt to avoid disaster
%define clean_build_root if test -O "%{buildroot}" -a "%{buildroot}" != "/" -a "%{buildroot}" != "$HOME"; then %{__rm} -rf %{buildroot}; fi
# To delete directory where compilation takes place
%define clean_build_dir %{__rm} -rf %{buildsubdir}

#### Header
Summary: Displays info such as file tails on the root-window
Name: %{name}
Version: %{version}
Release: %{release}
Serial: %{serial}
Copyright: GPL
Group: X11/Monitoring
Vendor: David Price, Michael Lucas-Smith
Packager: Daniel Serodio <dserodio@email.com>, Sourav K. Mandal <Sourav.Mandal@ikaran.com>
Url: http://root-portal.sourceforge.net
Source: %{name}-%{version}.tar.gz
Prefix: %{_prefix}
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

#### Description
%description
Root-Portal displays text of various sorts on the root-window (desktop).  Currently it supports the display of file tails and also info on processes starting/stopping.

#### Prep
%prep
%setup -q

#### Build
%build
%configure
# Build user might have his/her own special "make" hooks
%__make

#### Install
%install
%clean_build_root
%makeinstall
# Delete superfluous Makefiles
%{__rm} -f examples/Makefile*

#### Clean
%clean
%clean_build_root
%clean_build_dir


#### Post
# Unnecessary -- plugins built-in by default now
#%post -p /sbin/ldconfig
#%postun -p /sbin/ldconfig

#### Files
%files
%defattr(-, root, root)
%doc AUTHORS BUGS COPYING ChangeLog INSTALL NEWS README README.help TODO
%doc examples
%{_bindir}/*
#%{_libdir}/%{name} # plugins built-in by default now
%{_datadir}/gnome/help/%{name}
%{_mandir}/man1/*
%{_sysconfdir}/CORBA/servers/root-portal_applet.gnorba
%{_datadir}/applets/Monitors/root-portal_applet.desktop
%{_datadir}/pixmaps/root-portal.png

#### Changelog
%changelog

* Tue Dec 19 2000 Sourav K. Mandal <Sourav.Mandal@ikaran.com>
- Added tweaks Matthias Saou <matthias.saou@est.une.marmotte.net>
- Implemented some tasks as macros, to improve readability
- General clean up

* Mon Dec 18 2000 Sourav K. Mandal <Sourav.Mandal@ikaran.com>
- Version 0.4.9, release 2
- Defaulted prefix to /usr; added relocatability through "prefix" tag.  
  This is so the user can make the package compatible with his or her
  GNOME installation.
- Fixed "release" v. "rel" variable mismatch in spec header.

* Sun Dec 10 2000 David Price <mantys@goldweb.com.au>
- Merged previous two sets of changes together (probably making
  numerous mistakes).

* Sat Dec 09 2000 Sourav K. Mandal <Sourav.Mandal@ikaran.com>
- Revamped file to work
- Added some doc files
- Put in safety checks for cleaning up build root
- Tweaked to improve buildability for non-root users

* Wed Nov 16 2000 Daniel Serodio <dserodio@email.com> 0.4.7-1
- Added a bunch of missing files
- Changed prefix from /usr/local to /usr
- Added sysconfdir so .gnorba file goes to right place
- Removed .info file (doesn't exist anymore)

